/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance("#" + InferenceSession.class.getName());
    private static final Key<PsiType> LOWER_BOUND = Key.create("LowBound");
    private static final Key<PsiType> UPPER_BOUND = Key.create("UpperBound");
    private static final Key<Boolean> ERASED = Key.create("UNCHECKED_CONVERSION");
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = new Function<Pair<PsiType, PsiType>, PsiType>(){

        @Override
        public PsiType fun(Pair<PsiType, PsiType> pair) {
            if (!this.isValidGlb((PsiType)pair.first, (PsiType)pair.second)) {
                return null;
            }
            if (!this.isValidGlb((PsiType)pair.second, (PsiType)pair.first)) {
                return null;
            }
            return GenericsUtil.getGreatestLowerBound((PsiType)pair.first, (PsiType)pair.second);
        }

        private boolean isValidGlb(PsiType first, PsiType second) {
            PsiClass conjunct;
            if (second instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)second, first)) {
                return false;
            }
            return !(second instanceof PsiCapturedWildcardType) || first.isAssignableFrom(second) || (conjunct = PsiUtil.resolveClassInType(first)) == null || conjunct.isInterface();
        }
    };
    private static final String EQUALITY_CONSTRAINTS_PRESENTATION = "equality constraints";
    private static final String UPPER_BOUNDS_PRESENTATION = "upper bounds";
    private static final String LOWER_BOUNDS_PRESENTATION = "lower bounds";
    private final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private InferenceSessionContainer myInferenceSessionContainer = new InferenceSessionContainer();
    private PsiSubstitutor mySiteSubstitutor;
    private final PsiManager myManager;
    private int myConstraintIdx;
    private List<String> myErrorMessages;
    private boolean myErased;
    private boolean myCheckApplicabilityPhase = true;
    public final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private ParameterTypeInferencePolicy myPolicy;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;
    private PsiSubstitutor myRestoreNameSubstitution = PsiSubstitutor.EMPTY;

    public InferenceSession(InitialInferenceState initialState) {
        this.myContext = initialState.getContext();
        this.myManager = this.myContext.getManager();
        this.myInferenceSubstitution = initialState.getInferenceSubstitutor();
        this.myInferenceVariables.addAll(initialState.getInferenceVariables());
        this.mySiteSubstitutor = initialState.getSiteSubstitutor();
        for (Pair<InferenceVariable[], PsiClassType> capture : initialState.getCaptures()) {
            this.myIncorporationPhase.addCapture((InferenceVariable[])capture.first, (PsiClassType)capture.second);
        }
        this.myInferenceSessionContainer = initialState.getInferenceSessionContainer();
        this.myErased = initialState.isErased();
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i2 = 0; i2 < leftTypes.length; ++i2) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i2]);
            PsiType t = this.substituteWithInferenceVariables(leftTypes[i2]);
            PsiType s = this.substituteWithInferenceVariables(rightType);
            if (t == null || s == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(t, s));
        }
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this(typeParams, siteSubstitutor, manager, context, DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context, ParameterTypeInferencePolicy policy) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.myPolicy = policy;
        this.initBounds(typeParams);
    }

    public static PsiType getUpperBound(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getUpperBound"));
        }
        return psiClass.getUserData(UPPER_BOUND);
    }

    public static PsiType getLowerBound(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getLowerBound"));
        }
        return psiClass.getUserData(LOWER_BOUND);
    }

    public static PsiType createTypeParameterTypeWithUpperBound(PsiType upperBound, PsiElement place) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(place.getProject());
        PsiTypeParameter parameter = elementFactory.createTypeParameterFromText("T", place);
        parameter.putUserData(UPPER_BOUND, upperBound);
        return elementFactory.createType(parameter);
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        this.initExpressionConstraints(parameters, args, parent, null, currentProperties != null && currentProperties.isVarargs());
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method, boolean varargs) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        if (method == null && currentProperties != null) {
            method = currentProperties.getMethod();
        }
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters.length > 0) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (!varargs && i2 >= parameters.length || args[i2] == null || !InferenceSession.isPertinentToApplicability(args[i2], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters, i2, this.mySiteSubstitutor, varargs);
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i2], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(this.substituteWithInferenceVariables(thrownType));
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    private static MethodCandidateInfo.CurrentCandidateProperties getCurrentProperties(PsiElement parent) {
        if (parent instanceof PsiCall) {
            return MethodCandidateInfo.getCurrentMethod(((PsiCall)parent).getArgumentList());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr, method, null);
    }

    private static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method, PsiType expectedReturnType) {
        if ((expr instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr).hasFormalParameterTypes() || expr instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr).isExact()) && method != null) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp(expr.getParent());
            PsiType paramType = null;
            if (parent instanceof PsiExpressionList) {
                PsiElement gParent = parent.getParent();
                PsiTypeParameterListOwner owner = InferenceSession.getTypeParameterOwner(method, gParent);
                if (owner != null) {
                    PsiParameter[] parameters;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent, expr);
                    if (idx > (parameters = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters[parameters.length - 1].getType();
                        paramType = parameters[parameters.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters[idx].getType();
                    }
                    if (InferenceSession.isTypeParameterType(owner, paramType)) {
                        return false;
                    }
                }
            } else if (expectedReturnType != null && parent instanceof PsiLambdaExpression) {
                if (InferenceSession.isTypeParameterType(method, expectedReturnType)) {
                    return false;
                }
                paramType = expectedReturnType;
            }
            if (expr instanceof PsiLambdaExpression) {
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                    if (InferenceSession.isPertinentToApplicability(expression, method, LambdaUtil.getFunctionalInterfaceReturnType(paramType))) continue;
                    return false;
                }
                return true;
            }
        }
        if (expr instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)expr).hasFormalParameterTypes();
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiTypeParameterListOwner getTypeParameterOwner(@NotNull PsiMethod method, PsiElement gParent) {
        PsiClass containingClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getTypeParameterOwner"));
        }
        PsiTypeParameterListOwner owner = null;
        if (method.getTypeParameters().length > 0 && gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
            owner = method;
        } else if (method.isConstructor() && gParent instanceof PsiNewExpression && (containingClass = method.getContainingClass()) != null && containingClass.hasTypeParameters() && PsiDiamondType.hasDiamond((PsiNewExpression)gParent)) {
            owner = containingClass;
        }
        return owner;
    }

    private static boolean isTypeParameterType(PsiTypeParameterListOwner method, PsiType paramType) {
        PsiClass psiClass = PsiUtil.resolveClassInType(paramType);
        return psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method;
    }

    private static PsiType getParameterType(PsiParameter[] parameters, int i2, @Nullable PsiSubstitutor substitutor, boolean varargs) {
        if (substitutor == null) {
            return null;
        }
        return substitutor.substitute(PsiTypesUtil.getParameterType(parameters, i2, varargs));
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor collectAdditionalAndInfer(@NotNull PsiParameter[] parameters, @NotNull PsiExpression[] args, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull PsiSubstitutor psiSubstitutor) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        if (psiSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        return this.performGuardedInference(parameters, args, this.myContext, properties, psiSubstitutor);
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        PsiSubstitutor psiSubstitutor = this.infer(parameters, args, parent, InferenceSession.getCurrentProperties(parent));
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties) {
        PsiSubstitutor psiSubstitutor = this.performGuardedInference(parameters, args, parent, properties, PsiSubstitutor.EMPTY);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PsiSubstitutor performGuardedInference(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull PsiSubstitutor initialSubstitutor) {
        if (initialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "performGuardedInference"));
        }
        this.doInfer(parameters, args, parent, properties, initialSubstitutor);
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
        if (psiSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "performGuardedInference"));
        }
        return psiSubstitutor2;
        finally {
            for (ConstraintFormula formula : this.myConstraintsCopy) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                LambdaUtil.getFunctionalTypeMap().remove(((InputOutputConstraintFormula)formula).getExpression());
            }
            if (properties != null && this.myErrorMessages != null) {
                properties.getInfo().setInferenceError(StringUtil.join(this.myErrorMessages, "\n"));
            }
        }
    }

    private void doInfer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull PsiSubstitutor initialSubstitutor) {
        if (initialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "doInfer"));
        }
        if (!this.repeatInferencePhases()) {
            return;
        }
        this.myCheckApplicabilityPhase = false;
        if (properties != null && !properties.isApplicabilityCheck()) {
            PsiType returnType;
            PsiMethod method = properties.getMethod();
            if (parent instanceof PsiCallExpression && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)parent, method) && !PsiType.VOID.equals(returnType = method.getReturnType()) && returnType != null) {
                Ref<String> errorMessage = new Ref<String>();
                PsiType targetType = InferenceSession.getTargetTypeFromParent(parent, errorMessage, false);
                if (targetType == null && errorMessage.get() != null) {
                    return;
                }
                if (targetType != null && !PsiType.VOID.equals(targetType)) {
                    this.registerReturnTypeConstraints(PsiUtil.isRawSubstitutor(method, this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType), targetType);
                }
            }
            if (!this.repeatInferencePhases()) {
                this.resolveBounds(this.getInputInferenceVariablesFromTopLevelFunctionalExpressions(args, properties), initialSubstitutor);
                return;
            }
            if (parameters != null && args != null && !this.isOverloadCheck()) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                HashSet<ConstraintFormula> ignoredConstraints = new HashSet<ConstraintFormula>();
                if (parameters.length > 0) {
                    this.collectAdditionalConstraints(parameters, args, properties.getMethod(), this.mySiteSubstitutor, additionalConstraints, ignoredConstraints, properties.isVarargs(), initialSubstitutor);
                }
                if (!additionalConstraints.isEmpty() && !this.proceedWithAdditionalConstraints(additionalConstraints, ignoredConstraints)) {
                    this.resolveBounds(this.getInputInferenceVariablesFromTopLevelFunctionalExpressions(args, properties), initialSubstitutor);
                    return;
                }
            }
        }
        this.resolveBounds(this.myInferenceVariables, initialSubstitutor);
    }

    private Collection<InferenceVariable> getInputInferenceVariablesFromTopLevelFunctionalExpressions(PsiExpression[] args, MethodCandidateInfo.CurrentCandidateProperties properties) {
        if (args == null) {
            return Collections.emptyList();
        }
        PsiMethod method = properties.getMethod();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        HashSet<InferenceVariable> dependencies = new HashSet<InferenceVariable>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            PsiSubstitutor nestedSubstitutor;
            PsiType parameterType;
            PsiClassType.ClassResolveResult result;
            PsiMethod interfaceMethod;
            PsiExpression arg = args[i2];
            if ((!(arg instanceof PsiLambdaExpression) || ((PsiLambdaExpression)arg).hasFormalParameterTypes()) && (!(arg instanceof PsiMethodReferenceExpression) || ((PsiMethodReferenceExpression)arg).isExact()) || (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(result = PsiUtil.resolveGenericsClassInType(parameterType = (nestedSubstitutor = this.myInferenceSessionContainer.findNestedSubstitutor(arg, this.myInferenceSubstitution)).substitute(InferenceSession.getParameterType(parameters, i2, this.mySiteSubstitutor, properties.isVarargs()))))) == null) continue;
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, result);
            for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                this.collectDependencies(substitutor.substitute(parameter.getType()), dependencies);
            }
        }
        return dependencies;
    }

    private boolean isOverloadCheck() {
        if (this.myContext != null) {
            for (Object o : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
                if (!(o instanceof PsiExpressionList)) continue;
                PsiExpressionList element = (PsiExpressionList)o;
                for (PsiExpression expression : element.getExpressions()) {
                    if (expression != this.myContext) continue;
                    return true;
                }
            }
            return false;
        }
        return MethodCandidateInfo.isOverloadCheck();
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, boolean varargs, PsiSubstitutor initialSubstitutor) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown(args[i2]);
            if (arg == null) continue;
            PsiSubstitutor nestedSubstitutor = this.myInferenceSessionContainer.findNestedSubstitutor(arg, this.myInferenceSubstitution);
            PsiType parameterType = nestedSubstitutor.substitute(InferenceSession.getParameterType(parameters, i2, siteSubstitutor, varargs));
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                if (arg instanceof PsiLambdaExpression) {
                    for (Object expr : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
                        if (PsiTreeUtil.getParentOfType((PsiElement)expr, PsiLambdaExpression.class) != arg) continue;
                        return;
                    }
                    for (Object expr : LambdaUtil.ourParameterGuard.currentStack()) {
                        if (!(expr instanceof PsiParameter) || ((PsiParameter)expr).getDeclarationScope() != arg) continue;
                        ignoredConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
                        return;
                    }
                }
                additionalConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCall) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCall)((Object)arg));
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression(arg, calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCall)((Object)arg), initialSubstitutor);
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression) || !InferenceSession.isPertinentToApplicability(arg, parentMethod)) continue;
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)arg, FunctionalInterfaceParameterizationUtil.getGroundTargetType(parameterType, (PsiLambdaExpression)arg), !this.isProperType(initialSubstitutor.substitute(parameterType)), initialSubstitutor);
        }
    }

    public static PsiMethod getCalledMethod(PsiCall arg) {
        PsiExpressionList argumentList = arg.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(argumentList);
        if (properties != null) {
            return properties.getMethod();
        }
        JavaResolveResult resolveResult = InferenceSession.getResolveResult(arg);
        if (resolveResult instanceof MethodCandidateInfo) {
            return (PsiMethod)resolveResult.getElement();
        }
        return null;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType, boolean addConstraint, PsiSubstitutor initialSubstitutor) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(parameterType);
        if (interfaceReturnType != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
            for (PsiExpression returnExpression : returnExpressions) {
                this.processReturnExpression(additionalConstraints, ignoredConstraints, returnExpression, interfaceReturnType, addConstraint, initialSubstitutor);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiExpression returnExpression, PsiType functionalType, boolean addConstraint, PsiSubstitutor initialSubstitutor) {
        if (returnExpression instanceof PsiCallExpression) {
            if (addConstraint) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCallExpression)returnExpression);
                if (calledMethod != null && PsiPolyExpressionUtil.isMethodCallPolyExpression(returnExpression, calledMethod)) {
                    this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCallExpression)returnExpression, initialSubstitutor);
                }
            } else {
                this.getInferenceSessionContainer().registerNestedSession(this, functionalType, returnExpression);
            }
        } else if (returnExpression instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiParenthesizedExpression)returnExpression).getExpression(), functionalType, addConstraint, initialSubstitutor);
        } else if (returnExpression instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression).getThenExpression(), functionalType, addConstraint, initialSubstitutor);
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression).getElseExpression(), functionalType, addConstraint, initialSubstitutor);
        } else if (returnExpression instanceof PsiLambdaExpression) {
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)returnExpression, functionalType, this.myErased, initialSubstitutor);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiCall callExpression, PsiSubstitutor initialSubstitutor) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult result;
            MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(argumentList);
            JavaResolveResult javaResolveResult = result = properties != null ? null : InferenceSession.getResolveResult(callExpression);
            PsiMethod psiMethod = properties != null ? properties.getMethod() : (method = result instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result).getElement() : null);
            if (method != null) {
                PsiExpression[] newArgs = argumentList.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs, method, InferenceSession.chooseSiteSubstitutor(properties, result, method), additionalConstraints, ignoredConstraints, InferenceSession.chooseVarargsMode(properties, result), initialSubstitutor);
                }
            }
        }
    }

    public static JavaResolveResult getResolveResult(final PsiCall callExpression) {
        if (callExpression instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)callExpression)) {
            PsiUtilCore.ensureValid(callExpression);
            return CachedValuesManager.getCachedValue(callExpression, new CachedValueProvider<JavaResolveResult>(){

                @Override
                @Nullable
                public CachedValueProvider.Result<JavaResolveResult> compute() {
                    PsiElement psiClass;
                    PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)callExpression).getClassOrAnonymousClassReference();
                    JavaResolveResult constructor = JavaResolveResult.EMPTY;
                    JavaResolveResult resolveResult = null;
                    if (classReference != null && (psiClass = (resolveResult = classReference.advancedResolve(false)).getElement()) != null) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance(callExpression.getProject());
                        PsiExpressionList argumentList = callExpression.getArgumentList();
                        if (argumentList != null) {
                            constructor = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType((PsiClass)psiClass).rawType(), argumentList, callExpression);
                        }
                    }
                    return new CachedValueProvider.Result<JavaResolveResult>(constructor.getElement() == null && resolveResult != null ? resolveResult : constructor, PsiModificationTracker.MODIFICATION_COUNT);
                }
            });
        }
        return callExpression.resolveMethodGenerics();
    }

    public static PsiSubstitutor chooseSiteSubstitutor(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult, PsiMethod method) {
        return resolveResult instanceof MethodCandidateInfo && method != null && !method.isConstructor() ? ((MethodCandidateInfo)resolveResult).getSiteSubstitutor() : (candidateProperties != null ? candidateProperties.getSubstitutor() : PsiSubstitutor.EMPTY);
    }

    public static boolean chooseVarargsMode(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult) {
        return resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isVarargs() || candidateProperties != null && candidateProperties.isVarargs();
    }

    public PsiSubstitutor getInstantiations(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : variables) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor);
            if (equalsBound == null || PsiType.NULL.equals(equalsBound)) continue;
            substitutor = substitutor.put(variable.getParameter(), equalsBound);
        }
        return substitutor;
    }

    PsiSubstitutor prepareSubstitution() {
        boolean foundErrorMessage = false;
        Iterator<List<InferenceVariable>> iterator = InferenceVariablesOrder.resolveOrderIterator(this.myInferenceVariables, this);
        while (iterator.hasNext()) {
            List<InferenceVariable> variables = iterator.next();
            for (InferenceVariable inferenceVariable : variables) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                PsiType instantiation = inferenceVariable.getInstantiation();
                if (instantiation != PsiType.NULL) continue;
                if (!foundErrorMessage) {
                    foundErrorMessage = this.checkBoundsConsistency(this.mySiteSubstitutor, inferenceVariable) == PsiType.NULL;
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter));
            }
        }
        return this.mySiteSubstitutor;
    }

    public InitialInferenceState createInitialState(InferenceSessionContainer container, Collection<InferenceVariable> variables, PsiSubstitutor topInferenceSubstitutor) {
        return new InitialInferenceState(variables, topInferenceSubstitutor, this.myContext, this.myInferenceSubstitution, this.mySiteSubstitutor, this.myIncorporationPhase.getCaptures(), this.myErased, container);
    }

    public void initBounds(PsiTypeParameter ... typeParameters) {
        this.initBounds(this.myContext, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiTypeParameter ... typeParameters) {
        return this.initBounds(context, this.mySiteSubstitutor, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiSubstitutor siteSubstitutor, PsiTypeParameter ... typeParameters) {
        ArrayList<InferenceVariable> result = new ArrayList<InferenceVariable>(typeParameters.length);
        for (PsiTypeParameter parameter : typeParameters) {
            String name = parameter.getName();
            if (this.myContext != null) {
                name = name + Math.abs(this.myContext.hashCode());
            }
            InferenceVariable variable = new InferenceVariable(context, parameter, name);
            result.add(variable);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(parameter.getProject());
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter, elementFactory.createType(variable));
            this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.put(variable, elementFactory.createType(parameter));
            this.myInferenceVariables.add(variable);
        }
        for (InferenceVariable variable : result) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter = variable.getParameter();
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.substituteWithInferenceVariables(siteSubstitutor.substitute(classType)))) {
                    added = true;
                }
                variable.addBound(classType, InferenceBound.UPPER, null);
            }
            if (added) continue;
            variable.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER, null);
        }
        return result.toArray(new InferenceVariable[result.size()]);
    }

    public void registerReturnTypeConstraints(PsiType returnType, PsiType targetType) {
        returnType = this.substituteWithInferenceVariables(returnType);
        if (this.myErased) {
            PsiSubstitutor substitutor;
            InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
            if (inferenceVariable != null && (returnType = (substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor)).substitute(inferenceVariable)) == null) {
                return;
            }
            this.addConstraint(new TypeCompatibilityConstraint(targetType, TypeConversionUtil.erasure(returnType)));
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiClassType substitutedCapture = (PsiClassType)PsiUtil.captureToplevelWildcards(returnType, this.myContext);
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                PsiType[] parameters = substitutedCapture.getParameters();
                InferenceVariable[] copy = this.initFreshVariablesForCapturedBounds(typeParameters, parameters);
                PsiType[] newParameters = new PsiType[parameters.length];
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.myManager.getProject());
                int idx = 0;
                for (int i2 = 0; i2 < parameters.length; ++i2) {
                    newParameters[i2] = parameters[i2];
                    if (!(parameters[i2] instanceof PsiCapturedWildcardType)) continue;
                    newParameters[i2] = elementFactory.createType(copy[idx++]);
                }
                substitutedCapture = elementFactory.createType(psiClass, newParameters);
                this.myIncorporationPhase.addCapture(copy, (PsiClassType)returnType);
                this.addConstraint(new TypeCompatibilityConstraint(targetType, substitutedCapture));
            }
        } else {
            InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType, targetType);
            if (inferenceVariable != null) {
                PsiSubstitutor substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
                PsiType substitutedReturnType = substitutor.substitute(inferenceVariable);
                if (substitutedReturnType != null) {
                    this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiUtil.captureToplevelWildcards(substitutedReturnType, this.myContext)));
                }
            } else {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, returnType));
            }
        }
    }

    private InferenceVariable[] initFreshVariablesForCapturedBounds(PsiTypeParameter[] typeParameters, PsiType[] parameters) {
        if (Registry.is("javac.fresh.variables.for.captured.wildcards.only")) {
            ArrayList<PsiTypeParameter> capturedParams = new ArrayList<PsiTypeParameter>();
            PsiSubstitutor restParamSubstitution = PsiSubstitutor.EMPTY;
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                PsiType parameter = parameters[i2];
                if (parameter instanceof PsiCapturedWildcardType) {
                    capturedParams.add(typeParameters[i2]);
                    continue;
                }
                restParamSubstitution = restParamSubstitution.put(typeParameters[i2], parameter);
            }
            return this.initBounds(null, restParamSubstitution, capturedParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
        }
        return this.initBounds((PsiElement)null, typeParameters);
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType(bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion(targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(targetType)) {
            Processor<Pair<PsiType, PsiType>> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceSession.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = new Processor<Pair<PsiType, PsiType>>(){

                @Override
                public boolean process(Pair<PsiType, PsiType> pair) {
                    return pair.first == null || pair.second == null || !TypesDistinctProver.provablyDistinct((PsiType)pair.first, (PsiType)pair.second);
                }
            }) != null) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            ArrayList<PsiType> boundsToCheck = new ArrayList<PsiType>(bounds);
            boundsToCheck.addAll(eqBounds);
            for (PsiType lowBound : boundsToCheck) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiElement context) {
        return InferenceSession.getTargetTypeFromParent(context, new Ref<String>(), true);
    }

    private static PsiType getTargetTypeFromParent(PsiElement context, Ref<String> errorMessage, boolean inferParent) {
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(context.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCall && (argumentList = ((PsiCall)gParent).getArgumentList()) != null) {
                MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(argumentList);
                if (properties != null && properties.isApplicabilityCheck()) {
                    return InferenceSession.getTypeByMethod(context, argumentList, properties.getMethod(), properties.isVarargs(), properties.getSubstitutor());
                }
                JavaResolveResult result = ((PsiCall)gParent).resolveMethodGenerics();
                PsiElement element = result.getElement();
                if (element == null) {
                    errorMessage.set("Overload resolution failed");
                    return null;
                }
                if (element instanceof PsiMethod && (inferParent || !((PsiMethod)element).hasTypeParameters())) {
                    boolean varargs = result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).isVarargs();
                    return InferenceSession.getTypeByMethod(context, argumentList, result.getElement(), varargs, result.getSubstitutor());
                }
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetTypeFromParent(parent, errorMessage, inferParent);
            }
            if (parent instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)parent, errorMessage, inferParent);
            }
            if (parent instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeFromParentLambda(PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class, true, PsiMethod.class), errorMessage, inferParent);
            }
        }
        return null;
    }

    private static PsiType getTargetTypeFromParentLambda(PsiLambdaExpression lambdaExpression, Ref<String> errorMessage, boolean inferParent) {
        if (lambdaExpression != null) {
            PsiType typeTypeByParentCall = InferenceSession.getTargetTypeFromParent(lambdaExpression, errorMessage, inferParent);
            if (typeTypeByParentCall != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType(FunctionalInterfaceParameterizationUtil.getGroundTargetType(typeTypeByParentCall, lambdaExpression));
            }
            PsiType cachedLambdaType = LambdaUtil.getFunctionalTypeMap().get(lambdaExpression);
            if (cachedLambdaType != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType(FunctionalInterfaceParameterizationUtil.getGroundTargetType(cachedLambdaType, lambdaExpression));
            }
            return inferParent || !(PsiUtil.skipParenthesizedExprUp(lambdaExpression.getParent()) instanceof PsiExpressionList) ? LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getFunctionalInterfaceType()) : null;
        }
        return null;
    }

    private static PsiType getTypeByMethod(PsiElement context, PsiExpressionList argumentList, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i2 = ArrayUtilRt.find(args, arg);
            if (i2 < 0) {
                return null;
            }
            PsiType parameterType = InferenceSession.getParameterType(parameters, i2, substitutor, varargs);
            boolean isRaw = substitutor != null && PsiUtil.isRawSubstitutor((PsiMethod)parentMethod, substitutor);
            return isRaw ? TypeConversionUtil.erasure(parameterType) : parameterType;
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        return psiClass instanceof InferenceVariable ? this.getInferenceVariable((PsiTypeParameter)psiClass) : null;
    }

    public boolean isProperType(@Nullable PsiType type) {
        return this.collectDependencies(type, null);
    }

    public boolean collectDependencies(@Nullable PsiType type, @Nullable Set<InferenceVariable> dependencies) {
        return InferenceSession.collectDependencies(type, dependencies, new Function<PsiClassType, InferenceVariable>(){

            @Override
            public InferenceVariable fun(PsiClassType classType) {
                return InferenceSession.this.getInferenceVariable(classType);
            }
        });
    }

    public static boolean collectDependencies(@Nullable PsiType type, final @Nullable Set<InferenceVariable> dependencies, final Function<PsiClassType, InferenceVariable> fun) {
        if (type == null) {
            return true;
        }
        Boolean isProper = type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = (InferenceVariable)fun.fun(classType);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (psiType.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases() {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (!this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i2 = this.myConstraintIdx; i2 < this.myConstraints.size(); ++i2) {
            ConstraintFormula constraint = this.myConstraints.get(i2);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        if (!this.collectDependencies(bound, dependencies)) {
            return bound;
        }
        for (InferenceVariable dependency : dependencies) {
            PsiType instantiation = dependency.getInstantiation();
            if (instantiation == PsiType.NULL) continue;
            substitutor = substitutor.put(dependency, instantiation);
        }
        return substitutor.substitute(bound);
    }

    private boolean hasBoundProblems(List<InferenceVariable> typeParams, PsiSubstitutor substitutor) {
        for (InferenceVariable typeParameter : typeParams) {
            List<PsiType> extendsTypes;
            PsiType[] bounds;
            PsiClass aClass;
            PsiType type;
            if (typeParameter.getInstantiation() != PsiType.NULL || (type = substitutor.substitute(typeParameter)) instanceof PsiClassType && (aClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass) || GenericsUtil.findTypeParameterBoundError(typeParameter, bounds = (extendsTypes = typeParameter.getBounds(InferenceBound.UPPER)).toArray(new PsiType[extendsTypes.size()]), substitutor, this.myContext, true) == null) continue;
            return true;
        }
        return false;
    }

    private void resolveBounds(Collection<InferenceVariable> inferenceVariables, @NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "resolveBounds"));
        }
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, this);
            List<InferenceVariable> unresolved = new ArrayList<InferenceVariable>();
            for (InferenceVariable var : vars) {
                PsiType eqBound = this.getEqualsBound(var, substitutor);
                if (eqBound != PsiType.NULL) continue;
                unresolved.add(var);
            }
            if (!unresolved.isEmpty() && vars.size() > unresolved.size()) {
                vars.removeAll(unresolved);
                vars.addAll(unresolved);
            }
            if (!this.myIncorporationPhase.hasCaptureConstraints(unresolved)) {
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor);
                if (this.hasBoundProblems(vars, firstSubstitutor)) {
                    firstSubstitutor = null;
                    unresolved = vars;
                }
                if (firstSubstitutor != null) {
                    substitutor = firstSubstitutor;
                    allVars.removeAll(vars);
                    continue;
                }
            }
            if (!this.initFreshVariables(substitutor, unresolved)) {
                return;
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases()) continue;
            return;
        }
        if (this.myContext != null) {
            this.myContext.putUserData(ERASED, this.myErased);
        }
        Map<PsiTypeParameter, PsiType> map = substitutor.getSubstitutionMap();
        for (PsiTypeParameter parameter : map.keySet()) {
            PsiTypeParameter param;
            PsiType mapping = map.get(parameter);
            if (parameter instanceof InferenceVariable) {
                ((InferenceVariable)parameter).setInstantiation(mapping);
                if (((InferenceVariable)parameter).getCallContext() != this.myContext) continue;
                param = ((InferenceVariable)parameter).getParameter();
            } else {
                param = parameter;
            }
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(param, mapping);
        }
    }

    private boolean initFreshVariables(PsiSubstitutor substitutor, List<InferenceVariable> vars) {
        int i2;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getManager().getProject());
        PsiSubstitutor ySubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        for (i2 = 0; i2 < vars.size(); ++i2) {
            InferenceVariable var = vars.get(i2);
            PsiTypeParameter parameter = var.getParameter();
            yVars[i2] = elementFactory.createTypeParameterFromText(parameter.getName(), parameter);
            ySubstitutor = ySubstitutor.put(var, elementFactory.createType(yVars[i2]));
        }
        for (i2 = 0; i2 < yVars.length; ++i2) {
            PsiTypeParameter parameter = yVars[i2];
            InferenceVariable var = vars.get(i2);
            PsiType lub = this.getLowerBound(var, substitutor);
            if (lub != PsiType.NULL) {
                for (PsiClassType upperBoundType : parameter.getExtendsListTypes()) {
                    if (TypeConversionUtil.isAssignable(upperBoundType, lub)) continue;
                    return false;
                }
                parameter.putUserData(LOWER_BOUND, lub);
            }
            parameter.putUserData(UPPER_BOUND, this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, ySubstitutor.putAll(substitutor), true));
            TypeConversionUtil.markAsFreshVariable(parameter, this.myContext);
            if (var.addBound(elementFactory.createType(parameter), InferenceBound.EQ, this.myIncorporationPhase)) continue;
            return false;
        }
        return true;
    }

    private PsiSubstitutor resolveSubsetOrdered(Set<InferenceVariable> varsToResolve, PsiSubstitutor siteSubstitutor) {
        PsiSubstitutor substitutor = siteSubstitutor;
        Iterator<List<InferenceVariable>> varsIterator = InferenceVariablesOrder.resolveOrderIterator(varsToResolve, this);
        while (varsIterator.hasNext()) {
            List<InferenceVariable> vars = varsIterator.next();
            PsiSubstitutor resolveSubset = this.resolveSubset(vars, substitutor);
            substitutor = substitutor.putAll(resolveSubset);
        }
        return substitutor;
    }

    @NotNull
    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor) {
        if (this.myErased) {
            for (InferenceVariable var : vars) {
                substitutor = substitutor.put(var, null);
            }
        }
        for (InferenceVariable var : vars) {
            PsiType instantiation = var.getInstantiation();
            PsiType type = instantiation == PsiType.NULL ? this.checkBoundsConsistency(substitutor, var) : instantiation;
            if (type == PsiType.NULL) continue;
            substitutor = substitutor.put(var, type);
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "resolveSubset"));
        }
        return psiSubstitutor;
    }

    private PsiType checkBoundsConsistency(PsiSubstitutor substitutor, InferenceVariable var) {
        PsiType type;
        PsiType eqBound = this.getEqualsBound(var, substitutor);
        if (eqBound != PsiType.NULL && eqBound instanceof PsiPrimitiveType) {
            return PsiType.NULL;
        }
        PsiType lowerBound = this.getLowerBound(var, substitutor);
        PsiType upperBound = this.getUpperBound(var, substitutor);
        if (eqBound != PsiType.NULL && (this.myErased || eqBound != null)) {
            if (lowerBound != PsiType.NULL && !TypeConversionUtil.isAssignable(eqBound, lowerBound)) {
                String incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION);
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
            type = eqBound;
            if (!TypeConversionUtil.isAssignable(eqBound, lowerBound, false)) {
                this.setErased();
            }
        } else {
            type = lowerBound;
        }
        if (type == PsiType.NULL) {
            String conflictingConjunctsMessage;
            if (var.isThrownBound() && this.myPolicy.inferRuntimeExceptionForThrownBoundWithNoConstraints() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                type = PsiType.getJavaLangRuntimeException(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
            } else {
                PsiType psiType = type = var.getBounds(InferenceBound.UPPER).size() == 1 ? (PsiType)this.myPolicy.getInferredTypeWithNoConstraint((PsiManager)this.myManager, (PsiType)upperBound).first : upperBound;
            }
            if (type instanceof PsiIntersectionType && (conflictingConjunctsMessage = ((PsiIntersectionType)type).getConflictingConjunctsMessage()) != null) {
                this.registerIncompatibleErrorMessage("Type parameter " + var.getParameter().getName() + " has incompatible upper bounds: " + conflictingConjunctsMessage);
                return PsiType.NULL;
            }
        } else {
            for (PsiType upperType : var.getBounds(InferenceBound.UPPER)) {
                if (!this.isProperType(upperType)) continue;
                String incompatibleBoundsMessage = null;
                if (type != lowerBound && !TypeConversionUtil.isAssignable(upperType, type)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                } else if (type == lowerBound && !TypeConversionUtil.isAssignable(upperType, lowerBound)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                }
                if (incompatibleBoundsMessage == null) continue;
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
        }
        return type;
    }

    public String getPresentableText(PsiType psiType) {
        PsiType substituted = this.myRestoreNameSubstitution.substitute(psiType);
        return substituted != null ? substituted.getPresentableText() : null;
    }

    public void registerIncompatibleErrorMessage(Collection<InferenceVariable> variables, String incompatibleTypesMessage) {
        variables = new ArrayList<InferenceVariable>(variables);
        Collections.sort((ArrayList)variables, new Comparator<InferenceVariable>(){

            @Override
            public int compare(InferenceVariable v1, InferenceVariable v2) {
                return Comparing.compare(v1.getName(), v2.getName());
            }
        });
        String variablesEnumeration = StringUtil.join(variables, new Function<InferenceVariable, String>(){

            @Override
            public String fun(InferenceVariable variable) {
                return variable.getParameter().getName();
            }
        }, ", ");
        this.registerIncompatibleErrorMessage("no instance(s) of type variable(s) " + variablesEnumeration + " exist so that " + incompatibleTypesMessage);
    }

    public void registerIncompatibleErrorMessage(@NotNull String incompatibleBoundsMessage) {
        if (incompatibleBoundsMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibleBoundsMessage", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "registerIncompatibleErrorMessage"));
        }
        if (this.myErrorMessages == null) {
            this.myErrorMessages = new ArrayList<String>();
        }
        if (!this.myErrorMessages.contains(incompatibleBoundsMessage)) {
            this.myErrorMessages.add(incompatibleBoundsMessage);
        }
    }

    private String incompatibleBoundsMessage(InferenceVariable var, final PsiSubstitutor substitutor, InferenceBound lowBound, String lowBoundName, InferenceBound upperBound, String upperBoundName) {
        Function<PsiType, String> typePresentation = new Function<PsiType, String>(){

            @Override
            public String fun(PsiType type) {
                PsiType substituted = InferenceSession.this.substituteNonProperBound(type, substitutor);
                return InferenceSession.this.getPresentableText(substituted != null ? substituted : type);
            }
        };
        return "inference variable " + var.getParameter().getName() + " has incompatible bounds:\n " + lowBoundName + ": " + StringUtil.join(var.getBounds(lowBound), typePresentation, ", ") + "\n" + upperBoundName + ": " + StringUtil.join(var.getBounds(upperBound), typePresentation, ", ");
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.LOWER, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return GenericsUtil.getLeastUpperBound((PsiType)pair.first, (PsiType)pair.second, InferenceSession.this.myManager);
            }
        }, substitutor);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor);
    }

    public PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.EQ, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return !Comparing.equal(pair.first, pair.second) ? null : (PsiType)pair.first;
            }
        }, substitutor);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor) {
        return this.composeBound(variable, boundType, fun, substitutor, false);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor, boolean includeNonProperBounds) {
        List<PsiType> lowerBounds = variable.getBounds(boundType);
        PsiType lub = PsiType.NULL;
        for (PsiType lowerBound : lowerBounds) {
            lowerBound = this.substituteNonProperBound(lowerBound, substitutor);
            if (!includeNonProperBounds && !this.isProperType(lowerBound)) continue;
            if (lub == PsiType.NULL) {
                lub = lowerBound;
                continue;
            }
            Pair<PsiPrimitiveType, PsiType> pair = Pair.create(lub, lowerBound);
            if ((lub = fun.fun(pair)) != null) continue;
            return PsiType.NULL;
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        if (this.myContext != null) {
            return this.myContext.getResolveScope();
        }
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        PsiSubstitutor siteSubstitutor = PsiSubstitutor.EMPTY;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints, ignoredConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            PsiSubstitutor substitutor = this.resolveSubsetOrdered(varsToResolve, siteSubstitutor);
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, additionalConstraints, substitutor, ignoredConstraints)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    private boolean processOneConstraint(ConstraintFormula formula, Set<ConstraintFormula> additionalConstraints, PsiSubstitutor substitutor, Set<ConstraintFormula> ignoredConstraints) {
        PsiExpression expression;
        if (this.myContext instanceof PsiCall) {
            PsiExpressionList argumentList = ((PsiCall)this.myContext).getArgumentList();
            LOG.assertTrue(argumentList != null);
            MethodCandidateInfo.updateSubstitutor(argumentList, substitutor);
        }
        formula.apply(substitutor, true);
        this.addConstraint(formula);
        if (!this.repeatInferencePhases()) {
            return false;
        }
        if (formula instanceof ExpressionCompatibilityConstraint && (expression = ((ExpressionCompatibilityConstraint)formula).getExpression()) instanceof PsiLambdaExpression) {
            PsiType parameterType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(((ExpressionCompatibilityConstraint)formula).getT(), (PsiLambdaExpression)expression);
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)expression, parameterType, !this.isProperType(parameterType), substitutor);
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        Set<InferenceVariable> outputVariables = this.getOutputVariables(additionalConstraints);
        Set<InferenceVariable> ignoredOutputVariables = this.getOutputVariables(ignoredConstraints);
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        LinkedHashSet<ConstraintFormula> noInputVariables = new LinkedHashSet<ConstraintFormula>();
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            if (this.dependsOnOutput(ignoredOutputVariables, dependencies)) {
                                dependsOnOutput = true;
                                ignoredConstraints.add(constraint);
                                break;
                            }
                            dependsOnOutput = this.dependsOnOutput(outputVariables, dependencies);
                        }
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    if (!inputVariables.isEmpty()) continue;
                    noInputVariables.add(constraint);
                    continue;
                }
                subset.add(constraint);
                noInputVariables.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            additionalConstraints.removeAll(ignoredConstraints);
            if (!additionalConstraints.isEmpty()) {
                subset.add(additionalConstraints.iterator().next());
            }
        }
        if (!noInputVariables.isEmpty()) {
            subset = noInputVariables;
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    private boolean dependsOnOutput(Set<InferenceVariable> outputVariables, Set<InferenceVariable> dependencies) {
        for (InferenceVariable outputVariable : outputVariables) {
            if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Set<InferenceVariable> getOutputVariables(Set<ConstraintFormula> constraintFormulas) {
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : constraintFormulas) {
            Set<InferenceVariable> inputVariables;
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        HashSet<InferenceVariable> hashSet = outputVariables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getOutputVariables"));
        }
        return hashSet;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block10: {
            PsiType normalizedPType;
            PsiSubstitutor receiverSubstitutor;
            PsiSubstitutor psiSubstitutor;
            boolean isStatic;
            PsiParameter[] parameters;
            PsiClass containingClass;
            PsiClass methodContainingClass;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature;
            block9: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                LOG.assertTrue(interfaceMethod != null, this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                signature = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                methodContainingClass = method.getContainingClass();
                PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference);
                containingClass = qualifierResolveResult.getContainingClass();
                if (containingClass == null) {
                    return this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
                }
                PsiParameter[] functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                psiSubstitutor = qualifierResolveResult.getSubstitutor();
                if ((parameters.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block9;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor)) {
                    this.initBounds(containingClass.getTypeParameters());
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (methodContainingClass != null) {
                    psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), psiSubstitutor);
                    LOG.assertTrue(psiSubstitutor != null, "derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference.getText() + "; containingFile: " + reference.getContainingFile().getName());
                }
                for (int i2 = 0; i2 < functionalMethodParameters.length; ++i2) {
                    PsiType pType = signature.getParameterTypes()[i2];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i2, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards(pType, reference)));
                }
                break block10;
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch(reference, signature, varargs, isStatic, parameters.length)) break block10;
            PsiType pType = signature.getParameterTypes()[0];
            if (PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor) && (receiverSubstitutor = PsiMethodReferenceCompatibilityConstraint.getParameterizedTypeSubstitutor(containingClass, normalizedPType = PsiUtil.captureToplevelWildcards(pType, this.myContext))) != null) {
                if (!method.hasTypeParameters() && (signature.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor(containingClass, receiverSubstitutor))) {
                    return receiverSubstitutor;
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(receiverSubstitutor);
                if (methodContainingClass != null) {
                    PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), receiverSubstitutor);
                    LOG.assertTrue(superSubstitutor != null, "mContainingClass: " + methodContainingClass.getName() + "; containingClass: " + containingClass.getName());
                    this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(superSubstitutor);
                }
                psiSubstitutor = receiverSubstitutor;
            }
            PsiClassType qType = JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(qType), pType));
            if (methodContainingClass != null) {
                psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), psiSubstitutor);
                LOG.assertTrue(psiSubstitutor != null, "derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference.getText() + "; containingFile: " + reference.getContainingFile().getName());
            }
            for (int i3 = 0; i3 < signature.getParameterTypes().length - 1; ++i3) {
                PsiType interfaceParamType = signature.getParameterTypes()[i3 + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i3, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards(interfaceParamType, reference)));
            }
        }
        return null;
    }

    public void setErasedDuringApplicabilityCheck() {
        if (this.myCheckApplicabilityPhase) {
            this.myErased = true;
        }
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return parameter instanceof InferenceVariable && this.myInferenceVariables.contains(parameter) ? (InferenceVariable)parameter : null;
    }

    public static boolean isMoreSpecific(final PsiMethod m1, final PsiMethod m2, final PsiSubstitutor siteSubstitutor1, final PsiExpression[] args, final PsiElement context, final boolean varargs) {
        return LambdaUtil.performWithSubstitutedParameterBounds(m1.getTypeParameters(), siteSubstitutor1, new Producer<Boolean>(){

            @Override
            @Nullable
            public Boolean produce() {
                return InferenceSession.isMoreSpecificInternal(m1, m2, siteSubstitutor1, args, context, varargs);
            }
        });
    }

    private static boolean isMoreSpecificInternal(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        ArrayList<PsiTypeParameter> params = new ArrayList<PsiTypeParameter>();
        for (PsiTypeParameter param : PsiUtil.typeParametersIterable(m2)) {
            params.add(param);
        }
        siteSubstitutor1 = InferenceSession.getSiteSubstitutor(siteSubstitutor1, params);
        InferenceSession session = new InferenceSession(params.toArray(new PsiTypeParameter[params.size()]), siteSubstitutor1, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : Math.max(parameters1.length, parameters2.length) - 1;
        for (int i2 = 0; i2 < paramsLength; ++i2) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i2, siteSubstitutor1, false);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i2, siteSubstitutor1, varargs));
            if (sType instanceof PsiClassType && tType instanceof PsiClassType && LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args[i2])) continue;
                return false;
            }
            if (session.isProperType(tType) && !TypeConversionUtil.isAssignable(tType, sType)) {
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, siteSubstitutor1, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, siteSubstitutor1, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases();
    }

    private static PsiSubstitutor getSiteSubstitutor(PsiSubstitutor siteSubstitutor1, List<PsiTypeParameter> params) {
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter param : params) {
            subst = subst.put(param, siteSubstitutor1.substitute(param));
        }
        return subst;
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType(capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor(sInterfaceMethod, sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType(tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor(tInterfaceMethod, tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals(tReturnType)) {
                return true;
            }
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
            if (sReturnType instanceof PsiClassType && tReturnType instanceof PsiClassType && LambdaUtil.isFunctionalType(sReturnType) && LambdaUtil.isFunctionalType(tReturnType) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(sReturnType), TypeConversionUtil.erasure(tReturnType)) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(tReturnType), TypeConversionUtil.erasure(sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(sReturnType);
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(tReturnType);
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (!PsiPolyExpressionUtil.isPolyExpression(returnExpression)) {
                            PsiType returnExpressionType = returnExpression.getType();
                            if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                            return false;
                        }
                        if (!sPrimitive) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            LOG.assertTrue(sParameters.length == (tParameters = tInterfaceMethod.getParameterList().getParameters()).length, "s: " + sInterfaceMethod.getParameterList().getText() + "; t: " + tInterfaceMethod.getParameterList().getText());
            for (int i2 = 0; i2 < tParameters.length; ++i2) {
                PsiType tSubstituted = tSubstitutor.substitute(tParameters[i2].getType());
                PsiType sSubstituted = sSubstitutor.substitute(sParameters[i2].getType());
                if (session != null) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    continue;
                }
                if (Comparing.equal(tSubstituted, sSubstituted)) continue;
                return false;
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals(tReturnType)) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(sReturnType);
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(tReturnType);
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null, arg);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(methodReturnType) || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure(tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure(sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable(sConjunctErasure, erasedType);
                subRelation |= TypeConversionUtil.isAssignable(erasedType, sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure(sType)) != null) {
            return TypeConversionUtil.isAssignable(sTypeErasure, erasedType) || TypeConversionUtil.isAssignable(erasedType, sTypeErasure);
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    public boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Collections.singletonList(inferenceVariable));
    }

    public static boolean wasUncheckedConversionPerformed(PsiElement call) {
        Boolean erased = call.getUserData(ERASED);
        return erased != null && erased != false;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public void propagateVariables(Collection<InferenceVariable> variables, PsiSubstitutor restoreNamesSubstitution) {
        this.myInferenceVariables.addAll(variables);
        this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.putAll(restoreNamesSubstitution);
    }

    public PsiType substituteWithInferenceVariables(@Nullable PsiType type) {
        return this.myInferenceSubstitution.substitute(type);
    }

    public PsiSubstitutor getInferenceSubstitution() {
        return this.myInferenceSubstitution;
    }

    public PsiSubstitutor getRestoreNameSubstitution() {
        return this.myRestoreNameSubstitution;
    }

    public InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    public PsiType startWithFreshVars(PsiType type) {
        PsiSubstitutor s = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : this.myInferenceVariables) {
            s = s.put(variable, JavaPsiFacade.getElementFactory(variable.getProject()).createType(variable.getParameter()));
        }
        return s.substitute(type);
    }

    public static PsiClass findParameterizationOfTheSameGenericClass(List<PsiType> upperBounds, Processor<Pair<PsiType, PsiType>> processor) {
        for (int i2 = 0; i2 < upperBounds.size(); ++i2) {
            PsiType sBound = upperBounds.get(i2);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly(sBound);
            if (sClass == null) continue;
            LinkedHashSet<PsiClass> superClasses = InheritanceUtil.getSuperClasses(sClass);
            superClasses.add(sClass);
            for (int j = i2 + 1; j < upperBounds.size(); ++j) {
                PsiType tBound = upperBounds.get(j);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly(tBound);
                if (tClass == null) continue;
                LinkedHashSet<PsiClass> tSupers = InheritanceUtil.getSuperClasses(tClass);
                tSupers.add(tClass);
                tSupers.retainAll(superClasses);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)sBound);
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)tBound);
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substitute(typeParameter);
                        Pair<PsiType, PsiType> typePair = Pair.create(sType, tType = tSubstitutor.substitute(typeParameter));
                        if (processor.process(typePair)) continue;
                        return gClass;
                    }
                }
            }
        }
        return null;
    }

    public List<String> getIncompatibleErrorMessages() {
        return this.myErrorMessages;
    }

    public boolean isErased() {
        return this.myErased;
    }
}

