/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.LambdaExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExpressionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;
    private PsiType myT;

    public ExpressionCompatibilityConstraint(@NotNull PsiExpression expression, @NotNull PsiType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        this.myExpression = expression;
        this.myT = type;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiExpression expression;
        if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
            PsiType exprType = this.myExpression.getType();
            if (session.isProperType(this.myT)) {
                boolean assignmentCompatible;
                boolean bl = assignmentCompatible = exprType == null || TypeConversionUtil.isAssignable(this.myT, exprType);
                if (!assignmentCompatible) {
                    PsiType type = this.myExpression.getType();
                    session.registerIncompatibleErrorMessage((type != null ? type.getPresentableText() : this.myExpression.getText()) + " is not compatible with " + session.getPresentableText(this.myT));
                } else if (TypeCompatibilityConstraint.isUncheckedConversion(this.myT, exprType) && !JavaGenericsUtil.isReifiableType(this.myT)) {
                    session.setErasedDuringApplicabilityCheck();
                }
                return assignmentCompatible;
            }
            if (exprType instanceof PsiLambdaParameterType) {
                return false;
            }
            if (exprType instanceof PsiClassType && ((PsiClassType)exprType).resolve() == null) {
                return true;
            }
            if (exprType != null && exprType != PsiType.NULL) {
                if (exprType instanceof PsiDisjunctionType) {
                    exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
                }
                constraints.add(new TypeCompatibilityConstraint(this.myT, exprType));
            }
            return true;
        }
        if (this.myExpression instanceof PsiParenthesizedExpression && (expression = ((PsiParenthesizedExpression)this.myExpression).getExpression()) != null) {
            constraints.add(new ExpressionCompatibilityConstraint(expression, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiConditionalExpression) {
            PsiExpression elseExpression;
            PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
            if (thenExpression != null) {
                constraints.add(new ExpressionCompatibilityConstraint(thenExpression, this.myT));
            }
            if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                constraints.add(new ExpressionCompatibilityConstraint(elseExpression, this.myT));
            }
            return true;
        }
        if (this.myExpression instanceof PsiCall) {
            InferenceSession callSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, this.myExpression, this.myT);
            if (callSession == null) {
                return false;
            }
            if (callSession != session) {
                session.getInferenceSessionContainer().registerNestedSession(callSession);
                session.propagateVariables(callSession.getInferenceVariables(), callSession.getRestoreNameSubstitution());
            }
            return true;
        }
        if (this.myExpression instanceof PsiMethodReferenceExpression) {
            constraints.add(new PsiMethodReferenceCompatibilityConstraint((PsiMethodReferenceExpression)this.myExpression, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiLambdaExpression) {
            constraints.add(new LambdaExpressionCompatibilityConstraint((PsiLambdaExpression)this.myExpression, this.myT));
            return true;
        }
        return true;
    }

    public static InferenceSession reduceExpressionCompatibilityConstraint(InferenceSession session, PsiExpression expression, PsiType targetType) {
        PsiExpressionList argumentList = ((PsiCall)((Object)expression)).getArgumentList();
        if (argumentList != null) {
            MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(argumentList);
            PsiType returnType = null;
            PsiTypeParameter[] typeParams = null;
            JavaResolveResult resolveResult = candidateProperties != null ? null : InferenceSession.getResolveResult((PsiCall)((Object)expression));
            PsiMethod method = InferenceSession.getCalledMethod((PsiCall)((Object)expression));
            if (method != null && !method.isConstructor()) {
                returnType = method.getReturnType();
                typeParams = method.getTypeParameters();
            } else if (resolveResult != null) {
                PsiClass psiClass;
                PsiClass psiClass2 = psiClass = method != null ? method.getContainingClass() : (PsiClass)resolveResult.getElement();
                if (psiClass != null) {
                    returnType = JavaPsiFacade.getElementFactory(argumentList.getProject()).createType(psiClass, PsiSubstitutor.EMPTY);
                    typeParams = psiClass.getTypeParameters();
                    if (method != null && method.hasTypeParameters()) {
                        typeParams = ArrayUtil.mergeArrays(typeParams, method.getTypeParameters());
                    }
                }
            }
            if (typeParams != null) {
                List<String> messages;
                PsiSubstitutor siteSubstitutor = InferenceSession.chooseSiteSubstitutor(candidateProperties, resolveResult, method);
                InferenceSession callSession = new InferenceSession(typeParams, siteSubstitutor, expression.getManager(), expression);
                callSession.propagateVariables(session.getInferenceVariables(), session.getRestoreNameSubstitution());
                if (method != null) {
                    PsiExpression[] args = argumentList.getExpressions();
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    callSession.initExpressionConstraints(parameters, args, expression, method, InferenceSession.chooseVarargsMode(candidateProperties, resolveResult));
                }
                if (callSession.repeatInferencePhases()) {
                    if (PsiType.VOID.equals(targetType)) {
                        return callSession;
                    }
                    if (returnType != null) {
                        callSession.registerReturnTypeConstraints(siteSubstitutor.substitute(returnType), targetType);
                    }
                    if (callSession.repeatInferencePhases()) {
                        return callSession;
                    }
                }
                if ((messages = callSession.getIncompatibleErrorMessages()) != null) {
                    for (String message : messages) {
                        session.registerIncompatibleErrorMessage(message);
                    }
                }
            }
            return null;
        }
        return session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCompatibilityConstraint that = (ExpressionCompatibilityConstraint)o;
        return this.myExpression.equals(that.myExpression);
    }

    public int hashCode() {
        return this.myExpression.hashCode();
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    public PsiType getT() {
        return this.myT;
    }

    @Override
    protected void setT(PsiType t) {
        this.myT = t;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type, PsiExpression expression) {
        return new ExpressionCompatibilityConstraint(expression, type);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<InferenceVariable> result) {
        if (psiExpression instanceof PsiLambdaExpression && !PsiType.VOID.equals(returnType)) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)psiExpression);
            for (PsiExpression expression : returnExpressions) {
                Set<InferenceVariable> resultInputVars = this.createSelfConstraint(returnType, expression).getInputVariables(session);
                if (resultInputVars == null) continue;
                result.addAll(resultInputVars);
            }
        }
    }
}

