/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class FunctionalExpressionSearch
extends ExtensibleQueryFactory<PsiFunctionalExpression, SearchParameters> {
    public static final FunctionalExpressionSearch INSTANCE = new FunctionalExpressionSearch();

    public static Query<PsiFunctionalExpression> search(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/FunctionalExpressionSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/FunctionalExpressionSearch", "search"));
        }
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope));
    }

    public static Query<PsiFunctionalExpression> search(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/psi/search/searches/FunctionalExpressionSearch", "search"));
        }
        return FunctionalExpressionSearch.search(psiMethod, (SearchScope)GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(psiMethod)));
    }

    public static Query<PsiFunctionalExpression> search(final @NotNull PsiMethod psiMethod, final @NotNull SearchScope scope) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/psi/search/searches/FunctionalExpressionSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/FunctionalExpressionSearch", "search"));
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Query<PsiFunctionalExpression>>(){

            @Override
            public Query<PsiFunctionalExpression> compute() {
                PsiClass containingClass;
                if (!psiMethod.hasModifierProperty("static") && !psiMethod.hasModifierProperty("default") && (containingClass = psiMethod.getContainingClass()) != null) {
                    return INSTANCE.createUniqueResultsQuery(new SearchParameters(containingClass, scope));
                }
                return EmptyQuery.getEmptyQuery();
            }
        });
    }

    public static Query<PsiFunctionalExpression> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/FunctionalExpressionSearch", "search"));
        }
        return FunctionalExpressionSearch.search(aClass, (SearchScope)GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(aClass)));
    }

    public static class SearchParameters {
        private final PsiClass myElementToSearch;
        private final SearchScope myScope;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/FunctionalExpressionSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/FunctionalExpressionSearch$SearchParameters", "<init>"));
            }
            this.myElementToSearch = aClass;
            this.myScope = scope;
        }

        public PsiClass getElementToSearch() {
            return this.myElementToSearch;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            SearchScope accessScope = PsiSearchHelper.SERVICE.getInstance(this.myElementToSearch.getProject()).getUseScope(this.myElementToSearch);
            SearchScope searchScope = this.myScope.intersectWith(accessScope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/FunctionalExpressionSearch$SearchParameters", "getEffectiveSearchScope"));
            }
            return searchScope;
        }
    }
}

