/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java.compiler;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public class AnnotationProcessorProfileSerializer {
    private static final Comparator<String> ALPHA_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    private static final String ENTRY = "entry";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String ENABLED = "enabled";
    private static final String OPTION = "option";
    private static final String MODULE = "module";

    public static void readExternal(ProcessorConfigProfile profile2, Element element) {
        profile2.setName(element.getAttributeValue(NAME, ""));
        profile2.setEnabled(Boolean.valueOf(element.getAttributeValue(ENABLED, "false")));
        Element srcOutput = element.getChild("sourceOutputDir");
        String out = srcOutput != null ? srcOutput.getAttributeValue(NAME) : null;
        profile2.setGeneratedSourcesDirectoryName(out != null ? FileUtil.toSystemDependentName(out) : null, false);
        Element srcTestOutput = element.getChild("sourceTestOutputDir");
        String testOut = srcTestOutput != null ? srcTestOutput.getAttributeValue(NAME) : null;
        profile2.setGeneratedSourcesDirectoryName(testOut != null ? FileUtil.toSystemDependentName(testOut) : null, true);
        Element isRelativeToContentRoot = element.getChild("outputRelativeToContentRoot");
        if (isRelativeToContentRoot != null) {
            profile2.setOutputRelativeToContentRoot(Boolean.parseBoolean(isRelativeToContentRoot.getAttributeValue(VALUE)));
        }
        profile2.clearProcessorOptions();
        for (Object optionElement : element.getChildren(OPTION)) {
            Element elem = (Element)optionElement;
            String key = elem.getAttributeValue(NAME);
            String value = elem.getAttributeValue(VALUE);
            if (StringUtil.isEmptyOrSpaces(key) || value == null) continue;
            profile2.setOption(key, value);
        }
        profile2.clearProcessors();
        for (Object procElement : element.getChildren("processor")) {
            String name = ((Element)procElement).getAttributeValue(NAME);
            if (StringUtil.isEmptyOrSpaces(name)) continue;
            profile2.addProcessor(name);
        }
        Element pathElement = element.getChild("processorPath");
        if (pathElement != null) {
            profile2.setObtainProcessorsFromClasspath(Boolean.parseBoolean(pathElement.getAttributeValue("useClasspath", "true")));
            StringBuilder pathBuilder = new StringBuilder();
            for (Object entry : pathElement.getChildren(ENTRY)) {
                String path = ((Element)entry).getAttributeValue(NAME);
                if (StringUtil.isEmptyOrSpaces(path)) continue;
                if (pathBuilder.length() > 0) {
                    pathBuilder.append(File.pathSeparator);
                }
                pathBuilder.append(FileUtil.toSystemDependentName(path));
            }
            profile2.setProcessorPath(pathBuilder.toString());
        }
        profile2.clearModuleNames();
        for (Object moduleElement : element.getChildren(MODULE)) {
            String name = ((Element)moduleElement).getAttributeValue(NAME);
            if (StringUtil.isEmptyOrSpaces(name)) continue;
            profile2.addModuleName(name);
        }
    }

    public static void writeExternal(@NotNull ProcessorConfigProfile profile2, @NotNull Element element) {
        Set<String> moduleNames;
        String string;
        Set<String> processors;
        Map<String, String> options;
        String testSrcDirName;
        String srcDirName;
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "org/jetbrains/jps/model/serialization/java/compiler/AnnotationProcessorProfileSerializer", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/model/serialization/java/compiler/AnnotationProcessorProfileSerializer", "writeExternal"));
        }
        element.setAttribute(NAME, profile2.getName());
        if (profile2.isEnabled()) {
            element.setAttribute(ENABLED, Boolean.toString(profile2.isEnabled()));
        }
        if (!StringUtil.equals("generated", srcDirName = profile2.getGeneratedSourcesDirectoryName(false))) {
            AnnotationProcessorProfileSerializer.addChild(element, "sourceOutputDir").setAttribute(NAME, FileUtil.toSystemIndependentName(srcDirName));
        }
        if (!StringUtil.equals("generated_tests", testSrcDirName = profile2.getGeneratedSourcesDirectoryName(true))) {
            AnnotationProcessorProfileSerializer.addChild(element, "sourceTestOutputDir").setAttribute(NAME, FileUtil.toSystemIndependentName(testSrcDirName));
        }
        if (profile2.isOutputRelativeToContentRoot()) {
            AnnotationProcessorProfileSerializer.addChild(element, "outputRelativeToContentRoot").setAttribute(VALUE, "true");
        }
        if (!(options = profile2.getProcessorOptions()).isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(options.keySet());
            Collections.sort(keys, ALPHA_COMPARATOR);
            for (String string2 : keys) {
                AnnotationProcessorProfileSerializer.addChild(element, OPTION).setAttribute(NAME, string2).setAttribute(VALUE, options.get(string2));
            }
        }
        if (!(processors = profile2.getProcessors()).isEmpty()) {
            ArrayList<String> processorList = new ArrayList<String>(processors);
            Collections.sort(processorList, ALPHA_COMPARATOR);
            for (String proc : processorList) {
                AnnotationProcessorProfileSerializer.addChild(element, "processor").setAttribute(NAME, proc);
            }
        }
        Element pathElement = null;
        if (!profile2.isObtainProcessorsFromClasspath()) {
            pathElement = AnnotationProcessorProfileSerializer.addChild(element, "processorPath");
            pathElement.setAttribute("useClasspath", Boolean.toString(profile2.isObtainProcessorsFromClasspath()));
        }
        if (!StringUtil.isEmpty(string = profile2.getProcessorPath())) {
            if (pathElement == null) {
                pathElement = AnnotationProcessorProfileSerializer.addChild(element, "processorPath");
            }
            StringTokenizer tokenizer = new StringTokenizer(string, File.pathSeparator, false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                AnnotationProcessorProfileSerializer.addChild(pathElement, ENTRY).setAttribute(NAME, FileUtil.toSystemIndependentName(token));
            }
        }
        if (!(moduleNames = profile2.getModuleNames()).isEmpty()) {
            ArrayList<String> names = new ArrayList<String>(moduleNames);
            Collections.sort(names, ALPHA_COMPARATOR);
            for (String name : names) {
                AnnotationProcessorProfileSerializer.addChild(element, MODULE).setAttribute(NAME, name);
            }
        }
    }

    private static Element addChild(Element parent, String childName) {
        Element child = new Element(childName);
        parent.addContent(child);
        return child;
    }
}

