/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.InputSource;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.RootPaneContainer;

public class ComponentSettings {
    private static final RegistryValue HIGH_PRECISION_SCROLLING = Registry.get("idea.true.smooth.scrolling.high.precision");
    private static final RegistryValue PIXEL_PERFECT_SCROLLING = Registry.get("idea.true.smooth.scrolling.pixel.perfect");
    private static final RegistryValue SCROLLING_INTERPOLATION = Registry.get("idea.true.smooth.scrolling.interpolation");
    private static final RegistryValue SCROLLBAR_INTERPOLATION = Registry.get("idea.true.smooth.scrolling.interpolation.scrollbar");
    private static final RegistryValue MOUSE_WHEEL_INTERPOLATION = Registry.get("idea.true.smooth.scrolling.interpolation.mouse.wheel");
    private static final RegistryValue PRECISION_TOUCHPAD_INTERPOLATION = Registry.get("idea.true.smooth.scrolling.interpolation.precision.touchpad");
    private static final RegistryValue OTHER_SOURCES_INTERPOLATION = Registry.get("idea.true.smooth.scrolling.interpolation.other");
    private static final RegistryValue DYNAMIC_SCROLLBARS = Registry.get("idea.true.smooth.scrolling.dynamic.scrollbars");
    private boolean mySmoothScrollingEnabled = true;
    private boolean myRemoteDesktopConnected;
    private boolean myPowerSaveModeEnabled;
    private static final ComponentSettings ourInstance = new ComponentSettings();

    public static ComponentSettings getInstance() {
        return ourInstance;
    }

    public boolean isTrueSmoothScrollingEligibleFor(Component component) {
        return SystemProperties.isTrueSmoothScrollingEnabled() && !ApplicationManager.getApplication().isUnitTestMode() && this.mySmoothScrollingEnabled && !this.myRemoteDesktopConnected && !this.myPowerSaveModeEnabled && component != null && component.isShowing();
    }

    public boolean isHighPrecisionScrollingEnabled() {
        return HIGH_PRECISION_SCROLLING.asBoolean();
    }

    public boolean isPixelPerfectScrollingEnabled() {
        return PIXEL_PERFECT_SCROLLING.asBoolean();
    }

    public boolean isInterpolationEnabledFor(InputSource source) {
        if (!SCROLLING_INTERPOLATION.asBoolean()) {
            return false;
        }
        switch (source) {
            case SCROLLBAR: {
                return SCROLLBAR_INTERPOLATION.asBoolean();
            }
            case MOUSE_WHEEL: {
                return MOUSE_WHEEL_INTERPOLATION.asBoolean();
            }
            case PRECISION_TOUCHPAD: {
                return PRECISION_TOUCHPAD_INTERPOLATION.asBoolean();
            }
        }
        return OTHER_SOURCES_INTERPOLATION.asBoolean();
    }

    public boolean areDynamicScrollbarsEnabled() {
        return DYNAMIC_SCROLLBARS.asBoolean();
    }

    public boolean isInterpolationEligibleFor(JScrollBar scrollbar) {
        String name;
        Component[] subComponents;
        Window window = (Window)scrollbar.getTopLevelAncestor();
        if (window instanceof JDialog && "Commit Changes".equals(((JDialog)window).getTitle())) {
            return false;
        }
        if (!(window instanceof RootPaneContainer)) {
            return true;
        }
        Component[] components = ((RootPaneContainer)((Object)window)).getContentPane().getComponents();
        if (components.length == 1 && components[0].getClass().getName().contains("DiffWindow")) {
            return false;
        }
        return components.length != 2 || !(components[0] instanceof Container) || (subComponents = ((Container)components[0]).getComponents()).length != 1 || !(name = subComponents[0].getClass().getName()).contains("DiffWindow") && !name.contains("MergeWindow");
    }

    public void setSmoothScrollingEnabled(boolean enabled) {
        this.mySmoothScrollingEnabled = enabled;
    }

    public void setRemoteDesktopConnected(boolean connected) {
        this.myRemoteDesktopConnected = connected;
    }

    public void setPowerSaveModeEnabled(boolean enabled) {
        this.myPowerSaveModeEnabled = enabled;
    }
}

