/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.BindingCacheKey;
import com.intellij.configurationStore.KotlinAwareBeanBinding;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import gnu.trove.THashMap;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a'\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f\u00a2\u0006\u0002\u0010\u0010\u001a2\u0010\u0011\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u001a,\u0010\u0016\u001a\u0004\u0018\u00010\u00042\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u001a\u001e\u0010\n\u001a\u0002H\u000b\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\u0019*\u00020\u001aH\u0086\b\u00a2\u0006\u0002\u0010\u001b\u001a#\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u00020\u001a2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f\u00a2\u0006\u0002\u0010\u001c\u001a\u0016\u0010\u001d\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u001a\u001a\u0012\u0010!\u001a\u00020\u001e*\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0019\u001a'\u0010#\u001a\u00020\u001a\"\b\b\u0000\u0010\u000b*\u00020\u0019*\u0002H\u000b2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007\u00a2\u0006\u0002\u0010&\u001a!\u0010'\u001a\u00020\u001e\"\b\b\u0000\u0010\u000b*\u00020\u0019*\u0002H\u000b2\u0006\u0010 \u001a\u00020\u001a\u00a2\u0006\u0002\u0010(\"\"\u0010\u0000\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\" \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"_bindingCache", "Lcom/intellij/reference/SoftReference;", "", "Lcom/intellij/configurationStore/BindingCacheKey;", "Lcom/intellij/util/xmlb/Binding;", "bindingCache", "getBindingCache", "()Ljava/util/Map;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "deserialize", "T", "url", "Ljava/net/URL;", "aClass", "Ljava/lang/Class;", "(Ljava/net/URL;Ljava/lang/Class;)Ljava/lang/Object;", "getBinding", "originalType", "Ljava/lang/reflect/Type;", "accessor", "Lcom/intellij/util/xmlb/MutableAccessor;", "getClassBinding", "clazz", "type", "", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)Ljava/lang/Object;", "(Lorg/jdom/Element;Ljava/lang/Class;)Ljava/lang/Object;", "deserializeAndLoadState", "", "Lcom/intellij/openapi/components/PersistentStateComponent;", "element", "deserializeInto", "bean", "serialize", "filter", "Lcom/intellij/util/xmlb/SerializationFilter;", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/SerializationFilter;)Lorg/jdom/Element;", "serializeInto", "(Ljava/lang/Object;Lorg/jdom/Element;)V", "projectModel-impl"})
@JvmName(name="XmlSerializer")
public final class XmlSerializer {
    private static SoftReference<Map<BindingCacheKey, Binding>> _bindingCache;
    private static final ReentrantReadWriteLock cacheLock;

    @JvmOverloads
    @NotNull
    public static final <T> Element serialize(@NotNull T $receiver, @Nullable SerializationFilter filter) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        try {
            Class<?> clazz = $receiver.getClass();
            Binding binding = XmlSerializer.getBinding$default(clazz, null, null, 6, null);
            if (binding instanceof BeanBinding) {
                Element element = ((BeanBinding)binding).serialize($receiver, true, filter);
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"binding.serialize(this, true, filter)");
                return element;
            }
            Object object = binding.serialize($receiver, null, filter);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jdom.Element");
            }
            return (Element)object;
        }
        catch (XmlSerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException("Can't serialize instance of " + $receiver.getClass(), e);
        }
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Element serialize$default(Object object, SerializationFilter serializationFilter, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: serialize");
        }
        if ((n & 1) != 0) {
            serializationFilter = new SkipDefaultsSerializationFilter();
        }
        return XmlSerializer.serialize(object, serializationFilter);
    }

    @JvmOverloads
    @NotNull
    public static <T> Element serialize(T $receiver) {
        return XmlSerializer.serialize$default($receiver, null, 1, null);
    }

    private static final <T> T deserialize(@NotNull Element $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)XmlSerializer.deserialize($receiver, Object.class);
    }

    public static final <T> T deserialize(@NotNull Element $receiver, @NotNull Class<T> aClass) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
        try {
            Binding binding = XmlSerializer.getBinding$default(aClass, null, null, 6, null);
            if (binding == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.NotNullDeserializeBinding");
            }
            return (T)((NotNullDeserializeBinding)binding).deserialize(null, $receiver);
        }
        catch (XmlSerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException("Cannot deserialize class " + aClass.getName(), e);
        }
    }

    public static final <T> T deserialize(@NotNull URL url, @NotNull Class<T> aClass) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
        try {
            Document document = JDOMUtil.loadDocument(url);
            document = JDOMXIncluder.resolve(document, url.toExternalForm());
            return XmlSerializer.deserialize(document.getRootElement(), aClass);
        }
        catch (IOException e) {
            throw (Throwable)new XmlSerializationException(e);
        }
        catch (JDOMException e) {
            throw (Throwable)new XmlSerializationException(e);
        }
    }

    public static final void deserializeInto(@NotNull Element $receiver, @NotNull Object bean) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        try {
            Binding binding = XmlSerializer.getBinding$default(bean.getClass(), null, null, 6, null);
            if (binding == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
            }
            ((BeanBinding)binding).deserializeInto(bean, $receiver);
        }
        catch (XmlSerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException(e);
        }
    }

    public static final void deserializeAndLoadState(@NotNull PersistentStateComponent<?> $receiver, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Class clazz = ComponentSerializationUtil.getStateClass($receiver.getClass());
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"ComponentSerializationUt\u2026tateClass<Any>(javaClass)");
        Object state = XmlSerializer.deserialize(element, clazz);
        Object s = state;
        if (!(s instanceof BaseState)) {
            s = null;
        }
        BaseState baseState = (BaseState)s;
        if (baseState != null) {
            baseState.resetModificationCount();
        }
        PersistentStateComponent<?> persistentStateComponent = $receiver;
        if (persistentStateComponent == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.PersistentStateComponent<kotlin.Any>");
        }
        persistentStateComponent.loadState(state);
    }

    public static final <T> void serializeInto(@NotNull T $receiver, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        try {
            Binding binding;
            Binding binding2 = binding = XmlSerializer.getBinding$default($receiver.getClass(), null, null, 6, null);
            if (binding2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
            }
            ((BeanBinding)binding2).serializeInto($receiver, element, null);
        }
        catch (XmlSerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException(e);
        }
    }

    private static final Map<BindingCacheKey, Binding> getBindingCache() {
        Map map;
        SoftReference<Map<BindingCacheKey, Binding>> softReference = _bindingCache;
        Map map2 = map = softReference != null ? (Map)softReference.get() : null;
        if (map == null) {
            map = (Map)new THashMap();
            _bindingCache = new SoftReference<Map>(map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> Binding getBinding(Class<T> aClass, Type originalType, MutableAccessor accessor) {
        Binding binding;
        BindingCacheKey key = new BindingCacheKey(originalType, accessor);
        Map<BindingCacheKey, Binding> map = XmlSerializer.getBindingCache();
        ReentrantReadWriteLock reentrantReadWriteLock = cacheLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            binding = map.get(key);
        }
        finally {
            readLock.unlock();
        }
        Binding binding2 = binding;
        if (binding2 == null) {
            Binding binding3;
            int n;
            reentrantReadWriteLock = cacheLock;
            readLock = reentrantReadWriteLock.readLock();
            int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2 - 1;
            if (n3 <= n4) {
                do {
                    n = ++n3;
                    readLock.unlock();
                } while (n3 != n4);
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Binding binding4;
                Binding binding5 = map.get(key);
                if (binding5 != null) {
                    Binding it;
                    Binding binding6 = binding5;
                    Binding binding7 = it = binding6;
                    return binding7;
                }
                Binding binding8 = XmlSerializerImpl.createClassBinding(aClass, accessor, originalType);
                if (binding8 == null) {
                    binding8 = new KotlinAwareBeanBinding(aClass, accessor);
                }
                Binding binding9 = binding4 = binding8;
                Intrinsics.checkExpressionValueIsNotNull((Object)binding9, (String)"binding");
                map.put(key, binding9);
                try {
                    binding4.init(originalType);
                }
                catch (XmlSerializationException e) {
                    map.remove(key);
                    throw (Throwable)e;
                }
                binding3 = binding4;
            }
            finally {
                n = 0;
                int n5 = n2 - 1;
                if (n <= n5) {
                    do {
                        int it = ++n;
                        readLock.lock();
                    } while (n != n5);
                }
                writeLock.unlock();
            }
            Binding binding10 = binding3;
            binding2 = binding10;
            Intrinsics.checkExpressionValueIsNotNull((Object)binding10, (String)"cacheLock.write {\n    ma\u2026w e\n    }\n    binding\n  }");
        }
        return binding2;
    }

    static /* bridge */ /* synthetic */ Binding getBinding$default(Class clazz, Type type, MutableAccessor mutableAccessor, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBinding");
        }
        if ((n & 2) != 0) {
            type = clazz;
        }
        if ((n & 4) != 0) {
            mutableAccessor = null;
        }
        return XmlSerializer.getBinding(clazz, type, mutableAccessor);
    }

    private static final Binding getClassBinding(Class<?> clazz, Type type, MutableAccessor accessor) {
        return XmlSerializerImpl.isPrimitive(clazz) ? (Binding)null : XmlSerializer.getBinding(clazz, type, accessor);
    }

    static /* bridge */ /* synthetic */ Binding getClassBinding$default(Class clazz, Type type, MutableAccessor mutableAccessor, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getClassBinding");
        }
        if ((n & 2) != 0) {
            type = clazz;
        }
        if ((n & 4) != 0) {
            mutableAccessor = null;
        }
        return XmlSerializer.getClassBinding(clazz, type, mutableAccessor);
    }

    static {
        cacheLock = new ReentrantReadWriteLock();
    }

    @Nullable
    public static final /* synthetic */ Binding access$getClassBinding(@NotNull Class clazz, @NotNull Type type, @Nullable MutableAccessor accessor) {
        return XmlSerializer.getClassBinding(clazz, type, accessor);
    }
}

