/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.fileEditor.impl.LoadTextUtil");
    @Nls
    private static final String AUTO_DETECTED_FROM_BOM = "auto-detected from BOM";
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<String> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create("CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static Pair<CharSequence, String> convertLineSeparators(@NotNull CharBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparators"));
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        String detectedLineSeparator = null;
        if (crlfCount > crCount && crlfCount > lfCount) {
            detectedLineSeparator = "\r\n";
        } else if (crCount > lfCount) {
            detectedLineSeparator = "\r";
        } else if (lfCount > 0) {
            detectedLineSeparator = "\n";
        }
        CharBuffer result = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        Pair<CharSequence, String> pair = Pair.create(result, detectedLineSeparator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparators"));
        }
        return pair;
    }

    @NotNull
    private static Charset detectCharset(@NotNull VirtualFile virtualFile, @NotNull byte[] content, @NotNull FileType fileType) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        Charset charset = null;
        String charsetName = fileType.getCharset(virtualFile, content);
        if (charsetName != null) {
            charset = CharsetToolkit.forName(charsetName);
        } else {
            Charset hardCodedCharset;
            Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(virtualFile, content, content.length);
            Charset charset2 = hardCodedCharset = guessed == null ? null : (Charset)guessed.first;
            if (hardCodedCharset == null) {
                Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile, true);
                if (specifiedExplicitly != null) {
                    charset = specifiedExplicitly;
                }
            } else {
                charset = hardCodedCharset;
            }
        }
        if (charset == null) {
            charset = EncodingRegistry.getInstance().getDefaultCharset();
        }
        virtualFile.setCharset(charset);
        Charset charset3 = charset;
        if (charset3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        return charset3;
    }

    @NotNull
    public static Charset detectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        Charset charset = (Charset)LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, content, true, virtualFile.getFileType()).getFirst();
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        return charset;
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> doDetectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content, boolean saveBOM, @NotNull FileType fileType) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        Charset charset = virtualFile.isCharsetSet() ? virtualFile.getCharset() : LoadTextUtil.detectCharset(virtualFile, content, fileType);
        Pair.NonNull<Charset, byte[]> bomAndCharset = LoadTextUtil.getCharsetAndBOM(content, charset);
        byte[] bom = (byte[])bomAndCharset.second;
        if (saveBOM && bom.length != 0) {
            virtualFile.setBOM(bom);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, AUTO_DETECTED_FROM_BOM);
        }
        Pair.NonNull<Charset, byte[]> nonNull = bomAndCharset;
        if (nonNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        return nonNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means no luck, otherwise it's tuple(guessed encoding, hint about content if was unable to guess, BOM)")
    public static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromContent(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int length) {
        String detectedFromBytes;
        block8: {
            CharsetToolkit.GuessedEncoding guessed;
            block10: {
                CharsetToolkit toolkit;
                block9: {
                    if (virtualFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
                    }
                    if (content == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
                    }
                    Charset defaultCharset = ObjectUtils.notNull(EncodingManager.getInstance().getEncoding(virtualFile, true), CharsetToolkit.getDefaultSystemCharset());
                    toolkit = GUESS_UTF ? new CharsetToolkit(content, defaultCharset) : null;
                    detectedFromBytes = null;
                    if (!GUESS_UTF) break block8;
                    toolkit.setEnforce8Bit(true);
                    Charset charset = toolkit.guessFromBOM();
                    if (charset == null) break block9;
                    detectedFromBytes = AUTO_DETECTED_FROM_BOM;
                    byte[] bom = ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(charset), CharsetToolkit.UTF8_BOM);
                    Trinity<Charset, Object, byte[]> trinity = Trinity.create(charset, null, bom);
                    LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
                    return trinity;
                }
                guessed = toolkit.guessFromContent(length);
                if (guessed != CharsetToolkit.GuessedEncoding.VALID_UTF8) break block10;
                detectedFromBytes = "auto-detected from bytes";
                Trinity<Charset, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(CharsetToolkit.UTF8_CHARSET, guessed, null);
                LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
                return trinity;
            }
            if (guessed != CharsetToolkit.GuessedEncoding.SEVEN_BIT) break block8;
            Trinity<Object, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(null, guessed, null);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
            return trinity;
        }
        try {
            Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> trinity = null;
            return trinity;
        }
        finally {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
        }
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> getCharsetAndBOM(@NotNull byte[] content, @NotNull Charset charset) {
        block8: {
            Pair.NonNull<Charset, byte[]> nonNull;
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getCharsetAndBOM"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getCharsetAndBOM"));
            }
            if (charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom(content)) {
                Pair.NonNull<Charset, byte[]> nonNull2 = Pair.createNonNull(charset, CharsetToolkit.UTF8_BOM);
                if (nonNull2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getCharsetAndBOM"));
                }
                return nonNull2;
            }
            try {
                Charset fromBOM = CharsetToolkit.guessFromBOM(content);
                if (fromBOM == null) break block8;
                nonNull = Pair.createNonNull(fromBOM, ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(fromBOM), ArrayUtil.EMPTY_BYTE_ARRAY));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
            if (nonNull == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getCharsetAndBOM"));
            }
            return nonNull;
        }
        Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(charset, ArrayUtil.EMPTY_BYTE_ARRAY);
        if (nonNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getCharsetAndBOM"));
        }
        return nonNull;
    }

    public static void changeLineSeparators(@Nullable Project project, @NotNull VirtualFile file, @NotNull String newSeparator, @NotNull Object requestor) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "changeLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "changeLineSeparators"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "changeLineSeparators"));
        }
        CharSequence currentText = LoadTextUtil.getTextByBinaryPresentation(file.contentsToByteArray(), file, true, false);
        String currentSeparator = LoadTextUtil.detectLineSeparator(file, false);
        if (newSeparator.equals(currentSeparator)) {
            return;
        }
        String newText = StringUtil.convertLineSeparators(currentText.toString(), newSeparator);
        file.setDetectedLineSeparator(newSeparator);
        LoadTextUtil.write(project, file, requestor, newText, -1L);
    }

    public static void write(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull Object requestor, @NotNull String text, long newModificationStamp) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        Charset existing = virtualFile.getCharset();
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project, virtualFile, text, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (!charset.equals(existing)) {
            virtualFile.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile, buffer);
        virtualFile.setBinaryContent(buffer, newModificationStamp, -1L, requestor);
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> charsetForWriting(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text, @NotNull Charset existing) {
        Charset fromBom;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile, text);
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM(bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.createNonNull(fromBom, LoadTextUtil.toBytes(text, fromBom));
        }
        Pair.NonNull<Charset, byte[]> nonNull = chosen;
        if (nonNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        return nonNull;
    }

    private static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setDetectedFromBytesFlagBack"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setDetectedFromBytesFlagBack"));
        }
        if (virtualFile.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile, content, content.length);
        } else {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, AUTO_DETECTED_FROM_BOM);
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> chooseMostlyHarmlessCharset(@NotNull Charset existing, @NotNull Charset specified, @NotNull String text) {
        block15: {
            byte[] out;
            block14: {
                block13: {
                    Pair.NonNull<Charset, byte[]> nonNull;
                    if (existing == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    if (specified == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specified", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    try {
                        if (!specified.equals(existing)) break block13;
                        nonNull = Pair.createNonNull(specified, LoadTextUtil.toBytes(text, existing));
                    }
                    catch (RuntimeException e) {
                        Pair.NonNull<Charset, byte[]> nonNull2 = Pair.createNonNull(Charset.defaultCharset(), LoadTextUtil.toBytes(text, null));
                        if (nonNull2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                        }
                        return nonNull2;
                    }
                    if (nonNull == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    return nonNull;
                }
                out = LoadTextUtil.isSupported(specified, text);
                if (out == null) break block14;
                Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, out);
                if (nonNull == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                }
                return nonNull;
            }
            out = LoadTextUtil.isSupported(existing, text);
            if (out == null) break block15;
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(existing, out);
            if (nonNull == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
            }
            return nonNull;
        }
        Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, LoadTextUtil.toBytes(text, specified));
        if (nonNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
        }
        return nonNull;
    }

    @NotNull
    private static byte[] toBytes(@NotNull String text, @Nullable Charset charset) throws RuntimeException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "toBytes"));
        }
        byte[] byArray = charset == null ? text.getBytes() : text.getBytes(charset);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "toBytes"));
        }
        return byArray;
    }

    @Nullable(value="null means not supported, otherwise it is converted byte stream")
    private static byte[] isSupported(@NotNull Charset charset, @NotNull String str) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "isSupported"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "isSupported"));
        }
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        Charset charset = ObjectUtils.notNull(LoadTextUtil.charsetFromContentOrNull(project, virtualFile, text), virtualFile.getCharset());
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetFromContentOrNull"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetFromContentOrNull"));
        }
        return CharsetUtil.extractCharsetFromFileContent(project, virtualFile, virtualFile.getFileType(), text);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file) {
        CharSequence charSequence;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        if (file instanceof LightVirtualFile) {
            CharSequence charSequence2 = ((LightVirtualFile)file).getContent();
            if (charSequence2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
            }
            return charSequence2;
        }
        if (file.isDirectory()) {
            throw new AssertionError((Object)("'" + file.getPresentableUrl() + "' is a directory"));
        }
        FileType fileType = file.getFileType();
        if (fileType.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType);
            if (decompiler != null) {
                CharSequence text = decompiler.decompile(file);
                try {
                    StringUtil.assertValidSeparators(text);
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
                CharSequence charSequence3 = text;
                if (charSequence3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
                }
                return charSequence3;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file.getPresentableUrl() + ". File type: " + fileType.getName());
        }
        try {
            byte[] bytes = file.contentsToByteArray();
            charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, file);
        }
        catch (IOException e) {
            CharSequence charSequence4 = ArrayUtil.EMPTY_CHAR_SEQUENCE;
            if (charSequence4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
            }
            return charSequence4;
        }
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true, true);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, saveDetectedSeparators, saveBOM, virtualFile.getFileType());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM, @NotNull FileType fileType) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        Pair.NonNull<Charset, byte[]> pair = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, bytes, saveBOM, fileType);
        Charset charset = (Charset)pair.getFirst();
        byte[] bom = (byte[])pair.getSecond();
        int offset = bom.length;
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, charset, offset);
        if (saveDetectedSeparators) {
            virtualFile.setDetectedLineSeparator(result.getSecond());
        }
        CharSequence charSequence = result.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @Nullable
    public static String detectLineSeparator(@NotNull VirtualFile file, boolean checkFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectLineSeparator"));
        }
        String lineSeparator = LoadTextUtil.getDetectedLineSeparator(file);
        if (lineSeparator == null && checkFile) {
            try {
                LoadTextUtil.getTextByBinaryPresentation(file.contentsToByteArray(), file);
                lineSeparator = LoadTextUtil.getDetectedLineSeparator(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lineSeparator;
    }

    static String getDetectedLineSeparator(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getDetectedLineSeparator"));
        }
        return file.getDetectedLineSeparator();
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        Pair.NonNull<Charset, byte[]> pair = LoadTextUtil.getCharsetAndBOM(bytes, charset);
        byte[] bom = (byte[])pair.getSecond();
        int offset = bom.length;
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, (Charset)pair.first, offset);
        CharSequence charSequence = result.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    private static Pair<CharSequence, String> convertBytes(@NotNull byte[] bytes, @NotNull Charset charset, int startOffset) {
        CharBuffer charBuffer;
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, bytes.length - startOffset);
        try {
            charBuffer = charset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        Pair<CharSequence, String> pair = LoadTextUtil.convertLineSeparators(charBuffer);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        return pair;
    }

    @Nullable(value="null if was not detected, otherwise the reason it was")
    public static String wasCharsetDetectedFromBytes(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "wasCharsetDetectedFromBytes"));
        }
        return virtualFile.getUserData(CHARSET_WAS_DETECTED_FROM_BYTES);
    }

    public static void setCharsetWasDetectedFromBytes(@NotNull VirtualFile virtualFile, @Nullable(value="null if was not detected, otherwise the reason it was") String reason) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setCharsetWasDetectedFromBytes"));
        }
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, reason);
    }
}

