/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class AdditionalLibraryRootsProvider {
    public static final ExtensionPointName<AdditionalLibraryRootsProvider> EP_NAME = ExtensionPointName.create("com.intellij.additionalLibraryRootsProvider");

    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/AdditionalLibraryRootsProvider", "getAdditionalProjectLibraries"));
        }
        Collection<VirtualFile> roots = this.getAdditionalProjectLibrarySourceRoots(project);
        if (roots.isEmpty()) {
            List<SyntheticLibrary> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/AdditionalLibraryRootsProvider", "getAdditionalProjectLibraries"));
            }
            return list;
        }
        List<SyntheticLibrary> list = Collections.singletonList(SyntheticLibrary.newImmutableLibrary(null, roots));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/AdditionalLibraryRootsProvider", "getAdditionalProjectLibraries"));
        }
        return list;
    }

    @NotNull
    public Collection<VirtualFile> getAdditionalProjectLibrarySourceRoots(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/AdditionalLibraryRootsProvider", "getAdditionalProjectLibrarySourceRoots"));
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/AdditionalLibraryRootsProvider", "getAdditionalProjectLibrarySourceRoots"));
        }
        return list;
    }
}

