/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class SyntheticLibrary {
    @Nullable
    public abstract String getName();

    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(final @Nullable String name, final @NotNull Collection<VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        SyntheticLibrary syntheticLibrary = new SyntheticLibrary(){

            @Override
            @Nullable
            public String getName() {
                return name;
            }

            @Override
            @NotNull
            public Collection<VirtualFile> getSourceRoots() {
                Collection collection = sourceRoots;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary$1", "getSourceRoots"));
                }
                return collection;
            }
        };
        if (syntheticLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        return syntheticLibrary;
    }
}

