/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleRootManagerImpl
extends ModuleRootManager
implements Disposable {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.ModuleRootManagerImpl");
    private final Module myModule;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final VirtualFilePointerManager myFilePointerManager;
    protected RootModelImpl myRootModel;
    private boolean myIsDisposed = false;
    private boolean myLoaded = false;
    private final OrderRootsCache myOrderRootsCache;
    private final Map<RootModelImpl, Throwable> myModelCreations = new THashMap();
    protected volatile long myModificationCount;

    public ModuleRootManagerImpl(Module module, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        this.myModule = module;
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myRootModel = new RootModelImpl(this, this.myProjectRootManager, this.myFilePointerManager);
        this.myOrderRootsCache = new OrderRootsCache(module);
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getModule"));
        }
        return module;
    }

    @Override
    @NotNull
    public ModuleFileIndex getFileIndex() {
        ModuleFileIndex moduleFileIndex = ModuleServiceManager.getService(this.myModule, ModuleFileIndex.class);
        if (moduleFileIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getFileIndex"));
        }
        return moduleFileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.myRootModel.dispose();
        this.myIsDisposed = true;
        if (Disposer.isDebugMode()) {
            ArrayList<Map.Entry<RootModelImpl, Throwable>> entries;
            Map<RootModelImpl, Throwable> map = this.myModelCreations;
            synchronized (map) {
                entries = new ArrayList<Map.Entry<RootModelImpl, Throwable>>(this.myModelCreations.entrySet());
            }
            for (Map.Entry entry : entries) {
                LOG.warn("\n***********************************************************************************************\n***                        R O O T   M O D E L   N O T   D I S P O S E D                    ***\n***********************************************************************************************\nCreated at:", (Throwable)entry.getValue());
                ((RootModelImpl)entry.getKey()).dispose();
            }
        }
    }

    @Override
    @NotNull
    public ModifiableRootModel getModifiableModel() {
        ModifiableRootModel modifiableRootModel = this.getModifiableModel(new RootConfigurationAccessor());
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getModifiableModel"));
        }
        return modifiableRootModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ModifiableRootModel getModifiableModel(RootConfigurationAccessor accessor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootModelImpl model = new RootModelImpl(this.myRootModel, this, true, accessor, this.myFilePointerManager, this.myProjectRootManager){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                super.dispose();
                Throwable created = null;
                if (Disposer.isDebugMode()) {
                    Map object = ModuleRootManagerImpl.this.myModelCreations;
                    synchronized (object) {
                        created = (Throwable)ModuleRootManagerImpl.this.myModelCreations.remove(this);
                    }
                }
                for (OrderEntry entry : ModuleRootManagerImpl.this.getOrderEntries()) {
                    assert (!((RootModelComponentBase)((Object)entry)).isDisposed()) : entry + "(" + entry.getClass() + ") in " + ModuleRootManagerImpl.this.myRootModel + " is already disposed." + (created == null ? "" : "\nThis modifiable model was created at:\n" + ExceptionUtil.getThrowableText(created));
                }
            }
        };
        if (Disposer.isDebugMode()) {
            Map<RootModelImpl, Throwable> map = this.myModelCreations;
            synchronized (map) {
                this.myModelCreations.put(model, new Throwable());
            }
        }
        RootModelImpl rootModelImpl = model;
        if (rootModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getModifiableModel"));
        }
        return rootModelImpl;
    }

    void makeRootsChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "makeRootsChange"));
        }
        ProjectRootManagerEx projectRootManagerEx = (ProjectRootManagerEx)ProjectRootManager.getInstance(this.myModule.getProject());
        projectRootManagerEx.makeRootsChange(runnable, false, this.myModule.isLoaded());
    }

    public RootModelImpl getRootModel() {
        return this.myRootModel;
    }

    @Override
    @NotNull
    public ContentEntry[] getContentEntries() {
        ContentEntry[] contentEntryArray = this.myRootModel.getContentEntries();
        if (contentEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getContentEntries"));
        }
        return contentEntryArray;
    }

    @Override
    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] orderEntryArray = this.myRootModel.getOrderEntries();
        if (orderEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getOrderEntries"));
        }
        return orderEntryArray;
    }

    @Override
    public Sdk getSdk() {
        return this.myRootModel.getSdk();
    }

    @Override
    public boolean isSdkInherited() {
        return this.myRootModel.isSdkInherited();
    }

    void commitModel(RootModelImpl rootModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(rootModel.myModuleRootManager == this);
        boolean changed = rootModel.isChanged();
        Project project = this.myModule.getProject();
        ModifiableModuleModel moduleModel = ModuleManager.getInstance(project).getModifiableModel();
        ModifiableModelCommitter.multiCommit(Collections.singletonList(rootModel), moduleModel);
        if (changed) {
            this.stateChanged();
        }
    }

    static void doCommit(RootModelImpl rootModel) {
        rootModel.docommit();
        rootModel.dispose();
        try {
            ((ModuleRootManagerImpl)ModuleRootManagerImpl.getInstance(rootModel.getModule())).stateChanged();
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    @Override
    @NotNull
    public Module[] getDependencies() {
        Module[] moduleArray = this.myRootModel.getModuleDependencies();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getDependencies"));
        }
        return moduleArray;
    }

    @Override
    @NotNull
    public Module[] getDependencies(boolean includeTests) {
        Module[] moduleArray = this.myRootModel.getModuleDependencies(includeTests);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getDependencies"));
        }
        return moduleArray;
    }

    @Override
    @NotNull
    public Module[] getModuleDependencies() {
        Module[] moduleArray = this.myRootModel.getModuleDependencies();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getModuleDependencies"));
        }
        return moduleArray;
    }

    @Override
    @NotNull
    public Module[] getModuleDependencies(boolean includeTests) {
        Module[] moduleArray = this.myRootModel.getModuleDependencies(includeTests);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getModuleDependencies"));
        }
        return moduleArray;
    }

    @Override
    public boolean isDependsOn(Module module) {
        return this.myRootModel.isDependsOn(module);
    }

    @Override
    @NotNull
    public String[] getDependencyModuleNames() {
        String[] stringArray = this.myRootModel.getDependencyModuleNames();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getDependencyModuleNames"));
        }
        return stringArray;
    }

    @Override
    public <T> T getModuleExtension(Class<T> klass) {
        return this.myRootModel.getModuleExtension(klass);
    }

    @Override
    public <R> R processOrder(RootPolicy<R> policy, R initialValue) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.processOrder(policy, initialValue);
    }

    @Override
    @NotNull
    public OrderEnumerator orderEntries() {
        ModuleOrderEnumerator moduleOrderEnumerator = new ModuleOrderEnumerator(this.myRootModel, this.myOrderRootsCache);
        if (moduleOrderEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "orderEntries"));
        }
        return moduleOrderEnumerator;
    }

    public static OrderRootsEnumerator getCachingEnumeratorForType(OrderRootType type, Module module) {
        return ModuleRootManagerImpl.getEnumeratorForType(type, module).usingCache();
    }

    @NotNull
    private static OrderRootsEnumerator getEnumeratorForType(OrderRootType type, Module module) {
        OrderEnumerator base = OrderEnumerator.orderEntries(module);
        if (type == OrderRootType.CLASSES) {
            OrderRootsEnumerator orderRootsEnumerator = base.exportedOnly().withoutModuleSourceEntries().recursively().classes();
            if (orderRootsEnumerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getEnumeratorForType"));
            }
            return orderRootsEnumerator;
        }
        if (type == OrderRootType.SOURCES) {
            OrderRootsEnumerator orderRootsEnumerator = base.exportedOnly().recursively().sources();
            if (orderRootsEnumerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getEnumeratorForType"));
            }
            return orderRootsEnumerator;
        }
        OrderRootsEnumerator orderRootsEnumerator = base.roots(type);
        if (orderRootsEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getEnumeratorForType"));
        }
        return orderRootsEnumerator;
    }

    @Override
    @NotNull
    public VirtualFile[] getContentRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getContentRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getContentRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getContentRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getContentRootUrls();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getContentRootUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getExcludeRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getExcludeRootUrls();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getExcludeRootUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludeRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getExcludeRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getExcludeRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getSourceRootUrls() {
        String[] stringArray = this.getSourceRootUrls(true);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getSourceRootUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getSourceRootUrls(includingTests);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getSourceRootUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots() {
        VirtualFile[] virtualFileArray = this.getSourceRoots(true);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getSourceRoots"));
        }
        List<VirtualFile> list = this.myRootModel.getSourceRoots(rootType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getSourceRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getSourceRoots"));
        }
        List<VirtualFile> list = this.myRootModel.getSourceRoots(rootTypes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleRootManagerImpl", "getSourceRoots"));
        }
        return list;
    }

    public void dropCaches() {
        this.myOrderRootsCache.clearCache();
    }

    public ModuleRootManagerState getState() {
        if (Registry.is("store.track.module.root.manager.changes", false)) {
            LOG.error("getState, module " + this.myModule.getName());
        }
        return new ModuleRootManagerState(this.myRootModel);
    }

    public void loadState(ModuleRootManagerState object) {
        this.loadState(object, this.myLoaded || this.myModule.isLoaded());
        this.myLoaded = true;
    }

    protected void loadState(ModuleRootManagerState object, boolean throwEvent) {
        ThrowableRunnable r = () -> {
            RootModelImpl newModel = new RootModelImpl(object.getRootModelElement(), this, this.myProjectRootManager, this.myFilePointerManager, throwEvent);
            if (throwEvent) {
                this.makeRootsChange(() -> ModuleRootManagerImpl.doCommit(newModel));
            } else {
                this.myRootModel.dispose();
                this.myRootModel = newModel;
            }
            assert (!this.myRootModel.isOrderEntryDisposed());
        };
        try {
            if (throwEvent) {
                WriteAction.run(r);
            } else {
                ReadAction.run(r);
            }
        }
        catch (InvalidDataException e) {
            LOG.error(e);
        }
    }

    void stateChanged() {
        if (Registry.is("store.track.module.root.manager.changes", false)) {
            LOG.error("ModelRootManager state changed");
        }
        ++this.myModificationCount;
    }

    public static class ModuleRootManagerState
    implements JDOMExternalizable {
        private RootModelImpl myRootModel;
        private Element myRootModelElement;

        public ModuleRootManagerState() {
        }

        public ModuleRootManagerState(RootModelImpl rootModel) {
            this.myRootModel = rootModel;
        }

        @Override
        public void readExternal(Element element) {
            this.myRootModelElement = element;
        }

        @Override
        public void writeExternal(Element element) {
            this.myRootModel.writeExternal(element);
        }

        public Element getRootModelElement() {
            return this.myRootModelElement;
        }
    }
}

