/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiPackageAccessibilityStatementStub;
import com.intellij.psi.impl.java.stubs.impl.PsiPackageAccessibilityStatementStubImpl;
import com.intellij.psi.impl.source.PackageAccessibilityStatementElement;
import com.intellij.psi.impl.source.PsiPackageAccessibilityStatementImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaPackageAccessibilityStatementElementType
extends JavaStubElementType<PsiPackageAccessibilityStatementStub, PsiPackageAccessibilityStatement> {
    public JavaPackageAccessibilityStatementElementType(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "<init>"));
        }
        super(debugName);
    }

    @Override
    public PsiPackageAccessibilityStatement createPsi(@NotNull PsiPackageAccessibilityStatementStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createPackageAccessibilityStatement(stub);
    }

    @Override
    public PsiPackageAccessibilityStatement createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "createPsi"));
        }
        return new PsiPackageAccessibilityStatementImpl(node);
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        PackageAccessibilityStatementElement packageAccessibilityStatementElement = new PackageAccessibilityStatementElement(this);
        if (packageAccessibilityStatementElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "createCompositeNode"));
        }
        return packageAccessibilityStatementElement;
    }

    @Override
    public PsiPackageAccessibilityStatementStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String refText = null;
        List<String> to = ContainerUtil.newSmartList();
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaElementType.JAVA_CODE_REFERENCE) {
                refText = JavaSourceUtil.getReferenceText(tree, child);
                continue;
            }
            if (type != JavaElementType.MODULE_REFERENCE) continue;
            to.add(JavaSourceUtil.getReferenceText(tree, child));
        }
        return new PsiPackageAccessibilityStatementStubImpl(parentStub, this, refText, to);
    }

    @Override
    public void serialize(@NotNull PsiPackageAccessibilityStatementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "serialize"));
        }
        dataStream.writeUTFFast(stub.getPackageName());
        dataStream.writeUTFFast(StringUtil.join(stub.getTargets(), "/"));
    }

    @Override
    @NotNull
    public PsiPackageAccessibilityStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "deserialize"));
        }
        String packageName = dataStream.readUTFFast();
        List<String> targets = StringUtil.split(dataStream.readUTFFast(), "/");
        PsiPackageAccessibilityStatementStubImpl psiPackageAccessibilityStatementStubImpl = new PsiPackageAccessibilityStatementStubImpl(parentStub, this, packageName, targets);
        if (psiPackageAccessibilityStatementStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "deserialize"));
        }
        return psiPackageAccessibilityStatementStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiPackageAccessibilityStatementStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "indexStub"));
        }
    }

    @NotNull
    public static PsiPackageAccessibilityStatement.Role typeToRole(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "typeToRole"));
        }
        if (type == JavaElementType.EXPORTS_STATEMENT) {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.EXPORTS;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "typeToRole"));
            }
            return role;
        }
        if (type == JavaElementType.OPENS_STATEMENT) {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.OPENS;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "typeToRole"));
            }
            return role;
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }
}

