/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.HashFunctions;
import gnu.trove.TIntProcedure;
import java.util.Arrays;
import java.util.Random;

public class ByteArrayList
implements Cloneable {
    protected transient byte[] _data;
    protected transient int _pos;
    protected static final int DEFAULT_CAPACITY = 4;

    public ByteArrayList() {
        this(4);
    }

    public ByteArrayList(int capacity) {
        this._data = new byte[capacity];
        this._pos = 0;
    }

    public ByteArrayList(byte[] values) {
        this(Math.max(values.length, 4));
        this.add(values);
    }

    public void ensureCapacity(int capacity) {
        byte[] data = this._data;
        if (capacity > data.length) {
            int newCap = Math.max(data.length < 100000 ? data.length << 1 : data.length * 4 / 3, capacity);
            byte[] tmp = new byte[newCap];
            System.arraycopy(data, 0, tmp, 0, data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            byte[] tmp = new byte[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(byte val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(byte[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(byte[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset, byte value) {
        if (offset == this._pos) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[offset] = value;
        ++this._pos;
    }

    public void insert(int offset, byte[] values) {
        this.insert(offset, values, 0, values.length);
    }

    public void insert(int offset, byte[] values, int valOffset, int len) {
        if (offset == this._pos) {
            this.add(values, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(values, valOffset, this._data, offset, len);
        this._pos += len;
    }

    public byte get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException("Index out of range: " + offset + "; size: " + this._pos);
        }
        return this._data[offset];
    }

    public byte getQuick(int offset) {
        return this._data[offset];
    }

    public void set(int offset, byte val) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data[offset] = val;
    }

    public byte getSet(int offset, byte val) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        byte old = this._data[offset];
        this._data[offset] = val;
        return old;
    }

    public void set(int offset, byte[] values) {
        this.set(offset, values, 0, values.length);
    }

    public void set(int offset, byte[] values, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, values, valOffset, length);
    }

    public void copy(int source, int destination, int length) {
        if (source < 0 || source + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(source);
        }
        if (destination < 0 || destination + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(destination);
        }
        System.arraycopy(this._data, source, this._data, destination, length);
    }

    public void setQuick(int offset, byte val) {
        this._data[offset] = val;
    }

    public void clear() {
        this.clear(4);
    }

    public void clear(int capacity) {
        this._data = new byte[capacity];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill((byte)0);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public byte remove(int offset) {
        byte old = this.get(offset);
        this.remove(offset, 1);
        return old;
    }

    public void remove(int offset, int length) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (offset + length));
        }
        this._pos -= length;
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i2 = from;
        for (int j = to - 1; i2 < j; ++i2, --j) {
            this.swap(i2, j);
        }
    }

    public void shuffle(Random rand) {
        int i2 = this._pos;
        while (i2-- > 1) {
            this.swap(i2, rand.nextInt(i2));
        }
    }

    private final void swap(int i2, int j) {
        byte tmp = this._data[i2];
        this._data[i2] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        ByteArrayList clone = null;
        try {
            clone = (ByteArrayList)super.clone();
            clone._data = (byte[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public byte[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public byte[] toNativeArray(int offset, int len) {
        byte[] rv = new byte[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(byte[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteArrayList) {
            ByteArrayList that = (ByteArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i2 = this._pos;
            while (i2-- > 0) {
                if (this._data[i2] == that._data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i2 = this._pos;
        while (i2-- > 0) {
            h += HashFunctions.hash((int)this._data[i2]);
        }
        return h;
    }

    public boolean forEach(TIntProcedure procedure) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (procedure.execute((int)this._data[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TIntProcedure procedure) {
        int i2 = this._pos;
        while (i2-- > 0) {
            if (procedure.execute((int)this._data[i2])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this._data, fromIndex, toIndex);
    }

    public void fill(byte val) {
        Arrays.fill(this._data, 0, this._pos, val);
    }

    public void fill(int fromIndex, int toIndex, byte val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        Arrays.fill(this._data, fromIndex, toIndex, val);
    }

    public int binarySearch(byte value) {
        return this.binarySearch(value, 0, this._pos);
    }

    public int binarySearch(byte value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            byte midVal = this._data[mid];
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(byte value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int offset, byte value) {
        for (int i2 = offset; i2 < this._pos; ++i2) {
            if (this._data[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(byte value) {
        return this.lastIndexOf(this._pos, value);
    }

    public int lastIndexOf(int offset, byte value) {
        int i2 = offset;
        while (i2-- > 0) {
            if (this._data[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public boolean contains(byte value) {
        return this.lastIndexOf(value) >= 0;
    }

    public ByteArrayList grep(TIntProcedure condition) {
        ByteArrayList list = new ByteArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (!condition.execute((int)this._data[i2])) continue;
            list.add(this._data[i2]);
        }
        return list;
    }

    public ByteArrayList inverseGrep(TIntProcedure condition) {
        ByteArrayList list = new ByteArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (condition.execute((int)this._data[i2])) continue;
            list.add(this._data[i2]);
        }
        return list;
    }

    public int max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        int max = this._data[this._pos - 1];
        int i2 = this._pos - 1;
        while (i2-- > 0) {
            max = Math.max(max, this._data[this._pos]);
        }
        return max;
    }

    public int min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        int min = this._data[this._pos - 1];
        int i2 = this._pos - 1;
        while (i2-- > 0) {
            min = Math.min(min, this._data[this._pos]);
        }
        return min;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TIntProcedure(){

            public boolean execute(int val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }
}

