/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ConstructionUtils {
    @Contract(value="null -> false")
    public static boolean isEmptyStringBuilderInitializer(PsiExpression initializer) {
        return "\"\"".equals(ConstructionUtils.getStringBuilderInitializerText(initializer));
    }

    @Contract(value="null -> null")
    public static String getStringBuilderInitializerText(PsiExpression construction) {
        if (!((construction = PsiUtil.skipParenthesizedExprDown(construction)) instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)construction;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        if (classReference == null) {
            return null;
        }
        PsiElement target = classReference.resolve();
        if (!(target instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)target;
        String qualifiedName = aClass.getQualifiedName();
        if (!"java.lang.StringBuilder".equals(qualifiedName) && !"java.lang.StringBuffer".equals(qualifiedName)) {
            return null;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 0) {
            return "\"\"";
        }
        if (arguments.length != 1) {
            return null;
        }
        PsiExpression argument = arguments[0];
        PsiType argumentType = argument.getType();
        if (PsiType.INT.equals(argumentType)) {
            return "\"\"";
        }
        return argument.getText();
    }

    @Contract(value="null -> false")
    public static boolean isEmptyCollectionInitializer(PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiNewExpression) {
            PsiExpressionList argumentList = ((PsiNewExpression)expression).getArgumentList();
            if (argumentList == null || argumentList.getExpressions().length != 0) {
                return false;
            }
            PsiType type = expression.getType();
            return InheritanceUtil.isInheritor(type, "java.util.Collection") || InheritanceUtil.isInheritor(type, "java.util.Map");
        }
        if (expression instanceof PsiMethodCallExpression) {
            String qualifiedName;
            PsiClass aClass;
            PsiMethod method;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            String name = call.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList = call.getArgumentList();
            if (name != null && name.startsWith("new") && argumentList.getExpressions().length == 0 && (method = call.resolveMethod()) != null && method.getParameterList().getParametersCount() == 0 && (aClass = method.getContainingClass()) != null && ("com.google.common.collect.Maps".equals(qualifiedName = aClass.getQualifiedName()) || "com.google.common.collect.Lists".equals(qualifiedName) || "com.google.common.collect.Sets".equals(qualifiedName))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEmptyArrayInitializer(@Nullable PsiExpression expression) {
        if (!((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression;
        PsiExpression[] dimensions = newExpression.getArrayDimensions();
        if (dimensions.length == 0) {
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return false;
            }
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            return initializers.length == 0;
        }
        for (PsiExpression dimension : dimensions) {
            String dimensionText = dimension.getText();
            if ("0".equals(dimensionText)) continue;
            return false;
        }
        return true;
    }
}

