/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiElementPattern<T extends PsiElement, Self extends PsiElementPattern<T, Self>>
extends TreeElementPattern<PsiElement, T, Self> {
    protected PsiElementPattern(Class<T> aClass) {
        super(aClass);
    }

    protected PsiElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiElementPattern", "<init>"));
        }
        super(condition);
    }

    protected PsiElement[] getChildren(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/patterns/PsiElementPattern", "getChildren"));
        }
        return element.getChildren();
    }

    @Override
    protected PsiElement getParent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/patterns/PsiElementPattern", "getParent"));
        }
        return element.getContext();
    }

    @NotNull
    public Self withElementType(IElementType type) {
        Self Self = this.withElementType((ElementPattern<IElementType>)PlatformPatterns.elementType().equalTo(type));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withElementType"));
        }
        return Self;
    }

    @NotNull
    public Self withElementType(TokenSet type) {
        Self Self = this.withElementType(PlatformPatterns.elementType().tokenSet(type));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withElementType"));
        }
        return Self;
    }

    @NotNull
    public Self afterLeaf(String ... withText) {
        if (withText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "withText", "com/intellij/patterns/PsiElementPattern", "afterLeaf"));
        }
        Self Self = this.afterLeaf((ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withText(StandardPatterns.string().oneOf(withText)));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "afterLeaf"));
        }
        return Self;
    }

    @NotNull
    public Self afterLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "afterLeaf"));
        }
        Self Self = this.afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "afterLeaf"));
        }
        return Self;
    }

    @NotNull
    public Self beforeLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "beforeLeaf"));
        }
        Self Self = this.beforeLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "beforeLeaf"));
        }
        return Self;
    }

    @NotNull
    public Self whitespace() {
        Self Self = this.withElementType(TokenType.WHITE_SPACE);
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "whitespace"));
        }
        return Self;
    }

    @NotNull
    public Self whitespaceCommentOrError() {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class)});
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "whitespaceCommentOrError"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self whitespaceCommentEmptyOrError() {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class), PlatformPatterns.psiElement().withText("")});
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "whitespaceCommentEmptyOrError"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withFirstNonWhitespaceChild(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "withFirstNonWhitespaceChild"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.withChildren(StandardPatterns.collection(PsiElement.class).filter(StandardPatterns.not(PlatformPatterns.psiElement().whitespace()), StandardPatterns.collection(PsiElement.class).first(pattern)));
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withFirstNonWhitespaceChild"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withReference(final Class<? extends PsiReference> referenceClass) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withReference"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$1", "accepts"));
                }
                for (PsiReference reference : t.getReferences()) {
                    if (!referenceClass.isInstance(reference)) continue;
                    return true;
                }
                return false;
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withReference"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self inFile(final @NotNull ElementPattern<? extends PsiFile> filePattern) {
        if (filePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePattern", "com/intellij/patterns/PsiElementPattern", "inFile"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("inFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$2", "accepts"));
                }
                return filePattern.accepts(t.getContainingFile(), context);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "inFile"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self inVirtualFile(final @NotNull ElementPattern<? extends VirtualFile> filePattern) {
        if (filePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePattern", "com/intellij/patterns/PsiElementPattern", "inVirtualFile"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("inVirtualFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$3", "accepts"));
                }
                return filePattern.accepts(t.getContainingFile().getViewProvider().getVirtualFile(), context);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "inVirtualFile"));
        }
        return (Self)psiElementPattern;
    }

    @Override
    @NotNull
    public Self equalTo(@NotNull T o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/PsiElementPattern", "equalTo"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("equalTo", (PsiElement)o){
            final /* synthetic */ PsiElement val$o;
            {
                this.val$o = psiElement;
                super(debugMethodName);
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$4", "accepts"));
                }
                return t.getManager().areElementsEquivalent((PsiElement)t, this.val$o);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "equalTo"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withElementType(final ElementPattern<IElementType> pattern) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withElementType"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$5", "accepts"));
                }
                ASTNode node = t.getNode();
                return node != null && pattern.accepts(node.getElementType());
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withElementType"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withText(@NotNull @NonNls String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/patterns/PsiElementPattern", "withText"));
        }
        Self Self = this.withText((ElementPattern)StandardPatterns.string().equalTo(text));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withText"));
        }
        return Self;
    }

    @NotNull
    public Self withoutText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/patterns/PsiElementPattern", "withoutText"));
        }
        Self Self = this.withoutText((ElementPattern)StandardPatterns.string().equalTo(text));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withoutText"));
        }
        return Self;
    }

    @NotNull
    public Self withName(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/patterns/PsiElementPattern", "withName"));
        }
        Self Self = this.withName((ElementPattern<String>)StandardPatterns.string().equalTo(name));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withName"));
        }
        return Self;
    }

    @NotNull
    public Self withName(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/patterns/PsiElementPattern", "withName"));
        }
        Self Self = this.withName(StandardPatterns.string().oneOf(names));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withName"));
        }
        return Self;
    }

    @NotNull
    public Self withName(@NotNull ElementPattern<String> name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/patterns/PsiElementPattern", "withName"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PsiNamePatternCondition("withName", name));
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withName"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self afterLeafSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        if (skip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skip", "com/intellij/patterns/PsiElementPattern", "afterLeafSkipping"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "afterLeafSkipping"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("afterLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$6", "accepts"));
                }
                Object element = t;
                while ((element = PsiTreeUtil.prevLeaf(element)) != null && element.getTextLength() == 0 || skip.accepts(element, context)) {
                }
                return pattern.accepts(element, context);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "afterLeafSkipping"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self beforeLeafSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        if (skip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skip", "com/intellij/patterns/PsiElementPattern", "beforeLeafSkipping"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "beforeLeafSkipping"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("beforeLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$7", "accepts"));
                }
                Object element = t;
                while ((element = PsiTreeUtil.nextLeaf(element)) != null && element.getTextLength() == 0 || skip.accepts(element, context)) {
                }
                return pattern.accepts(element, context);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "beforeLeafSkipping"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self atStartOf(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "atStartOf"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("atStartOf"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$8", "accepts"));
                }
                for (Object element = t; element != null; element = element.getContext()) {
                    if (!pattern.accepts(element, context)) continue;
                    return element.getTextRange().getStartOffset() == t.getTextRange().getStartOffset();
                }
                return false;
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "atStartOf"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withTextLength(@NotNull ElementPattern lengthPattern) {
        if (lengthPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lengthPattern", "com/intellij/patterns/PsiElementPattern", "withTextLength"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternConditionPlus<T, Integer>("withTextLength", lengthPattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<Integer, ProcessingContext> integerProcessingContextPairProcessor) {
                return integerProcessingContextPairProcessor.process(t.getTextLength(), context);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withTextLength"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self notEmpty() {
        Self Self = this.withTextLengthLongerThan(0);
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "notEmpty"));
        }
        return Self;
    }

    @NotNull
    public Self withTextLengthLongerThan(final int minLength) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withTextLengthLongerThan"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$10", "accepts"));
                }
                return t.getTextLength() > minLength;
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withTextLengthLongerThan"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withText(@NotNull ElementPattern text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/patterns/PsiElementPattern", "withText"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(this._withText(text));
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withText"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    private PatternCondition<T> _withText(ElementPattern pattern) {
        PatternConditionPlus patternConditionPlus = new PatternConditionPlus<T, String>("_withText", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<String, ProcessingContext> processor) {
                return processor.process(t.getText(), context);
            }
        };
        if (patternConditionPlus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "_withText"));
        }
        return patternConditionPlus;
    }

    @NotNull
    public Self withoutText(@NotNull ElementPattern text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/patterns/PsiElementPattern", "withoutText"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.without(this._withText(text));
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withoutText"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withLanguage(final @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/patterns/PsiElementPattern", "withLanguage"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withLanguage"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$12", "accepts"));
                }
                return t.getLanguage().equals(language);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withLanguage"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withMetaData(final ElementPattern<? extends PsiMetaData> metaDataPattern) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withMetaData"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$13", "accepts"));
                }
                return t instanceof PsiMetaOwner && metaDataPattern.accepts(((PsiMetaOwner)t).getMetaData(), context);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withMetaData"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self referencing(final ElementPattern<? extends PsiElement> targetPattern) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("referencing"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiReference[] references;
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$14", "accepts"));
                }
                for (PsiReference reference : references = t.getReferences()) {
                    if (targetPattern.accepts(reference.resolve(), context)) {
                        return true;
                    }
                    if (!(reference instanceof PsiPolyVariantReference)) continue;
                    for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(true)) {
                        if (!targetPattern.accepts(result.getElement(), context)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "referencing"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self compiled() {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("compiled"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$15", "accepts"));
                }
                return t instanceof PsiCompiledElement;
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "compiled"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withTreeParent(final ElementPattern<? extends PsiElement> ancestor) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withTreeParent"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$16", "accepts"));
                }
                return ancestor.accepts(t.getParent(), context);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withTreeParent"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self insideStarting(final ElementPattern<? extends PsiElement> ancestor) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<PsiElement>("insideStarting"){

            @Override
            public boolean accepts(@NotNull PsiElement start, ProcessingContext context) {
                if (start == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/patterns/PsiElementPattern$17", "accepts"));
                }
                PsiElement element = PsiElementPattern.this.getParent(start);
                TextRange range = start.getTextRange();
                if (range == null) {
                    return false;
                }
                int startOffset = range.getStartOffset();
                while (element != null && element.getTextRange() != null && element.getTextRange().getStartOffset() == startOffset) {
                    if (ancestor.accepts(element, context)) {
                        return true;
                    }
                    element = PsiElementPattern.this.getParent(element);
                }
                return false;
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "insideStarting"));
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withLastChildSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        if (skip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skip", "com/intellij/patterns/PsiElementPattern", "withLastChildSkipping"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiElementPattern", "withLastChildSkipping"));
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withLastChildSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiElement last;
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiElementPattern$18", "accepts"));
                }
                for (last = t.getLastChild(); last != null && skip.accepts(last); last = last.getPrevSibling()) {
                }
                return pattern.accepts(last);
            }
        });
        if (psiElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiElementPattern", "withLastChildSkipping"));
        }
        return (Self)psiElementPattern;
    }

    public static class Capture<T extends PsiElement>
    extends PsiElementPattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }

        protected Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiElementPattern$Capture", "<init>"));
            }
            super(condition);
        }
    }
}

