/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiMethodPattern
extends PsiMemberPattern<PsiMethod, PsiMethodPattern> {
    public PsiMethodPattern() {
        super(PsiMethod.class);
    }

    public PsiMethodPattern withParameterCount(final @NonNls int paramCount) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("withParameterCount"){

            @Override
            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/patterns/PsiMethodPattern$1", "accepts"));
                }
                return method.getParameterList().getParametersCount() == paramCount;
            }
        });
    }

    public PsiMethodPattern withParameters(String ... inputTypes) {
        final String[] types = inputTypes.length == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : inputTypes;
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("withParameters"){

            @Override
            public boolean accepts(@NotNull PsiMethod psiMethod, ProcessingContext context) {
                if (psiMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/patterns/PsiMethodPattern$2", "accepts"));
                }
                PsiParameterList parameterList = psiMethod.getParameterList();
                int dotsIndex = -1;
                while (++dotsIndex < types.length && !Comparing.equal("..", types[dotsIndex])) {
                }
                if (dotsIndex == types.length && parameterList.getParametersCount() != dotsIndex || dotsIndex < types.length && parameterList.getParametersCount() < dotsIndex) {
                    return false;
                }
                if (dotsIndex > 0) {
                    PsiParameter[] psiParameters = parameterList.getParameters();
                    for (int i = 0; i < dotsIndex; ++i) {
                        if (Comparing.equal("?", types[i]) || this.typeEquivalent(psiParameters[i].getType(), types[i])) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean typeEquivalent(PsiType type, String expectedText) {
                PsiType erasure = TypeConversionUtil.erasure(type);
                String text = erasure instanceof PsiEllipsisType && expectedText.endsWith("[]") ? ((PsiEllipsisType)erasure).getComponentType().getCanonicalText() + "[]" : (erasure instanceof PsiArrayType && expectedText.endsWith("...") ? ((PsiArrayType)erasure).getComponentType().getCanonicalText() + "..." : erasure.getCanonicalText());
                return expectedText.equals(text);
            }
        });
    }

    @NotNull
    public PsiMethodPattern definedInClass(@NonNls String qname) {
        PsiMethodPattern psiMethodPattern = this.definedInClass(PsiJavaPatterns.psiClass().withQualifiedName(qname));
        if (psiMethodPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiMethodPattern", "definedInClass"));
        }
        return psiMethodPattern;
    }

    @NotNull
    public PsiMethodPattern definedInClass(ElementPattern<? extends PsiClass> pattern) {
        PsiMethodPattern psiMethodPattern = (PsiMethodPattern)this.with(new PatternConditionPlus<PsiMethod, PsiClass>("definedInClass", pattern){

            @Override
            public boolean processValues(PsiMethod t, final ProcessingContext context, final PairProcessor<PsiClass, ProcessingContext> processor) {
                if (!processor.process(t.getContainingClass(), context)) {
                    return false;
                }
                final Ref<Boolean> result = Ref.create(Boolean.TRUE);
                SuperMethodsSearch.search(t, null, true, false).forEach(new Processor<MethodSignatureBackedByPsiMethod>(){

                    @Override
                    public boolean process(MethodSignatureBackedByPsiMethod signature) {
                        if (!processor.process(signature.getMethod().getContainingClass(), context)) {
                            result.set(Boolean.FALSE);
                            return false;
                        }
                        return true;
                    }
                });
                return result.get();
            }
        });
        if (psiMethodPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/PsiMethodPattern", "definedInClass"));
        }
        return psiMethodPattern;
    }

    public PsiMethodPattern constructor(final boolean isConstructor) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("constructor"){

            @Override
            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/patterns/PsiMethodPattern$4", "accepts"));
                }
                return method.isConstructor() == isConstructor;
            }
        });
    }

    public PsiMethodPattern withThrowsList(final ElementPattern<?> pattern) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("withThrowsList"){

            @Override
            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/patterns/PsiMethodPattern$5", "accepts"));
                }
                return pattern.accepts(method.getThrowsList());
            }
        });
    }
}

