/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakInterner;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiModifierListImpl
extends JavaStubPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Map<String, IElementType> NAME_TO_KEYWORD_TYPE_MAP = new THashMap();
    private static final Map<IElementType, String> KEYWORD_TYPE_TO_NAME_MAP;
    private volatile ModifierCache myModifierCache;

    public PsiModifierListImpl(PsiModifierListStub stub) {
        super(stub, JavaStubElementTypes.MODIFIER_LIST);
    }

    public PsiModifierListImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiModifierListImpl", "hasModifierProperty"));
        }
        ModifierCache modifierCache = this.myModifierCache;
        if (modifierCache == null || !modifierCache.isUpToDate()) {
            this.myModifierCache = modifierCache = this.calcModifiers();
        }
        return modifierCache.modifiers.contains(name);
    }

    private ModifierCache calcModifiers() {
        Set<String> modifiers = this.calcExplicitModifiers();
        modifiers.addAll(this.calcImplicitModifiers(modifiers));
        if (!(modifiers.contains("public") || modifiers.contains("protected") || modifiers.contains("private"))) {
            modifiers.add("packageLocal");
        }
        PsiFile file = this.getContainingFile();
        return new ModifierCache(file, PsiAugmentProvider.transformModifierProperties(this, file.getProject(), modifiers));
    }

    private Set<String> calcExplicitModifiers() {
        HashSet<String> explicitModifiers = ContainerUtil.newHashSet();
        PsiModifierListStub stub = (PsiModifierListStub)this.getGreenStub();
        if (stub != null) {
            int mask = stub.getModifiersMask();
            for (int i = 0; i < 31; ++i) {
                int flag = 1 << i;
                if (!BitUtil.isSet(mask, flag)) continue;
                ContainerUtil.addIfNotNull(explicitModifiers, ModifierFlags.MODIFIER_FLAG_TO_NAME_MAP.get(flag));
            }
        } else {
            for (ASTNode child : this.getNode().getChildren(null)) {
                ContainerUtil.addIfNotNull(explicitModifiers, KEYWORD_TYPE_TO_NAME_MAP.get(child.getElementType()));
            }
        }
        return explicitModifiers;
    }

    private Set<String> calcImplicitModifiers(Set<String> explicitModifiers) {
        HashSet<String> implicitModifiers = ContainerUtil.newHashSet();
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClass) {
            PsiElement grandParent = parent.getContext();
            if (grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface()) {
                Collections.addAll(implicitModifiers, "public", "static");
            }
            if (((PsiClass)parent).isInterface()) {
                implicitModifiers.add("abstract");
                if (grandParent instanceof PsiClass) {
                    implicitModifiers.add("static");
                }
            }
            if (((PsiClass)parent).isEnum()) {
                boolean hasSubClass;
                if (!(grandParent instanceof PsiFile)) {
                    implicitModifiers.add("static");
                }
                List<PsiField> fields = parent instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent).getOwnFields() : Arrays.asList(((PsiClass)parent).getFields());
                boolean bl = hasSubClass = ContainerUtil.find(fields, new Condition<PsiField>(){

                    @Override
                    public boolean value(PsiField field) {
                        return field instanceof PsiEnumConstant && ((PsiEnumConstant)field).getInitializingClass() != null;
                    }
                }) != null;
                if (!hasSubClass) {
                    implicitModifiers.add("final");
                }
                List<PsiMethod> methods = parent instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent).getOwnMethods() : Arrays.asList(((PsiClass)parent).getMethods());
                for (PsiMethod method : methods) {
                    if (!method.hasModifierProperty("abstract")) continue;
                    implicitModifiers.add("abstract");
                    break;
                }
            }
        } else if (parent instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                implicitModifiers.add("public");
                if (!(explicitModifiers.contains("default") || explicitModifiers.contains("static") || explicitModifiers.contains("private"))) {
                    implicitModifiers.add("abstract");
                }
            } else if (aClass != null && aClass.isEnum() && ((PsiMethod)parent).isConstructor()) {
                implicitModifiers.add("private");
            }
        } else if (parent instanceof PsiField) {
            if (parent instanceof PsiEnumConstant) {
                Collections.addAll(implicitModifiers, "public", "static", "final");
            } else {
                PsiClass aClass = ((PsiField)parent).getContainingClass();
                if (aClass != null && aClass.isInterface()) {
                    Collections.addAll(implicitModifiers, "public", "static", "final");
                }
            }
        } else if (parent instanceof PsiParameter && parent.getParent() instanceof PsiCatchSection && ((PsiParameter)parent).getType() instanceof PsiDisjunctionType) {
            Collections.addAll(implicitModifiers, "final");
        } else if (parent instanceof PsiResourceVariable) {
            Collections.addAll(implicitModifiers, "final");
        }
        return implicitModifiers;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        IElementType type;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiModifierListImpl", "hasExplicitModifier"));
        }
        PsiModifierListStub stub = (PsiModifierListStub)this.getGreenStub();
        if (stub != null) {
            return BitUtil.isSet(stub.getModifiersMask(), ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.get((Object)name));
        }
        CompositeElement tree = (CompositeElement)this.getNode();
        return tree.findChildByType(type = NAME_TO_KEYWORD_TYPE_MAP.get(name)) != null;
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiModifierListImpl", "setModifierProperty"));
        }
        this.checkSetModifierProperty(name, value);
        PsiElement parent = this.getParent();
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        IElementType type = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        CompositeElement treeElement = (CompositeElement)this.getNode();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            CodeEditUtil.markToReformat(method.getParameterList().getNode(), true);
        }
        if (value) {
            if (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.PRIVATE_KEYWORD || type == JavaTokenType.PROTECTED_KEYWORD || type == null) {
                if (type != JavaTokenType.PUBLIC_KEYWORD) {
                    this.setModifierProperty("public", false);
                }
                if (type != JavaTokenType.PRIVATE_KEYWORD) {
                    this.setModifierProperty("private", false);
                }
                if (type != JavaTokenType.PROTECTED_KEYWORD) {
                    this.setModifierProperty("protected", false);
                }
                if (type == null) {
                    return;
                }
            }
            if (parent instanceof PsiField && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.STATIC_KEYWORD || type == JavaTokenType.FINAL_KEYWORD : (parent instanceof PsiMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD : (parent instanceof PsiClass && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD : parent instanceof PsiAnnotationMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isAnnotationType() && (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD)))) {
                return;
            }
            if (treeElement.findChildByType(type) == null) {
                LeafElement keyword = Factory.createSingleLeafElement(type, name, null, this.getManager());
                treeElement.addInternal(keyword, keyword, null, null);
            }
        } else {
            if (type == null) {
                throw new IncorrectOperationException("Cannot reset package-private modifier.");
            }
            ASTNode child = treeElement.findChildByType(type);
            if (child != null) {
                SourceTreeToPsiMap.treeToPsiNotNull(child).delete();
            }
        }
    }

    @Override
    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiModifierListImpl", "checkSetModifierProperty"));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] own = (PsiAnnotation[])this.getStubOrPsiChildren(JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        List<PsiAnnotation> ext = PsiAugmentProvider.collectAugments(this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = ArrayUtil.mergeArrayAndCollection(own, ext, PsiAnnotation.ARRAY_FACTORY);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiModifierListImpl", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        final PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation(this);
        List<PsiAnnotation> filtered = ContainerUtil.findAll(this.getAnnotations(), new Condition<PsiAnnotation>(){

            @Override
            public boolean value(PsiAnnotation annotation) {
                PsiAnnotation.TargetType target = AnnotationTargetUtil.findAnnotationTarget(annotation, targets);
                return target != null && target != PsiAnnotation.TargetType.UNKNOWN;
            }
        });
        PsiAnnotation[] psiAnnotationArray = filtered.toArray(new PsiAnnotation[filtered.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiModifierListImpl", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/PsiModifierListImpl", "findAnnotation"));
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/PsiModifierListImpl", "addAnnotation"));
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addAfter(JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createAnnotationFromText("@" + qualifiedName, this), null);
        if (psiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiModifierListImpl", "addAnnotation"));
        }
        return psiAnnotation;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiModifierListImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiModifierList:" + this.getText();
    }

    static {
        NAME_TO_KEYWORD_TYPE_MAP.put("public", JavaTokenType.PUBLIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("protected", JavaTokenType.PROTECTED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("private", JavaTokenType.PRIVATE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("static", JavaTokenType.STATIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("abstract", JavaTokenType.ABSTRACT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("final", JavaTokenType.FINAL_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("native", JavaTokenType.NATIVE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("strictfp", JavaTokenType.STRICTFP_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transient", JavaTokenType.TRANSIENT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("volatile", JavaTokenType.VOLATILE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("default", JavaTokenType.DEFAULT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("open", JavaTokenType.OPEN_KEYWORD);
        KEYWORD_TYPE_TO_NAME_MAP = ContainerUtil.newTroveMap();
        for (String name : NAME_TO_KEYWORD_TYPE_MAP.keySet()) {
            KEYWORD_TYPE_TO_NAME_MAP.put(NAME_TO_KEYWORD_TYPE_MAP.get(name), name);
        }
    }

    private static class ModifierCache {
        static final WeakInterner<List<String>> ourInterner = new WeakInterner();
        final PsiFile file;
        final List<String> modifiers;
        final long modCount;

        ModifierCache(@NotNull PsiFile file, @NotNull Set<String> modifiers) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/PsiModifierListImpl$ModifierCache", "<init>"));
            }
            if (modifiers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/psi/impl/source/PsiModifierListImpl$ModifierCache", "<init>"));
            }
            this.file = file;
            ArrayList<String> modifierList = ContainerUtil.newArrayList(modifiers);
            Collections.sort(modifierList);
            this.modifiers = ourInterner.intern(modifierList);
            this.modCount = this.getModCount();
        }

        private long getModCount() {
            return this.file.getManager().getModificationTracker().getModificationCount() + this.file.getModificationStamp();
        }

        boolean isUpToDate() {
            return this.getModCount() == this.modCount;
        }
    }
}

