/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceListStubImpl
extends StubBase<PsiReferenceList>
implements PsiClassReferenceListStub {
    private final StringRef[] myNames;
    private PsiClassType[] myTypes;

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type, StubElement parent, @NotNull String[] names) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        this(type, parent, PsiClassReferenceListStubImpl.toStringRefs(names));
    }

    @NotNull
    private static StringRef[] toStringRefs(String[] names) {
        StringRef[] myNames = StringRef.createArray(names.length);
        for (int i = 0; i < names.length; ++i) {
            myNames[i] = StringRef.fromString(names[i]);
        }
        if (myNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "toStringRefs"));
        }
        return myNames;
    }

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type, StubElement parent, @NotNull StringRef[] names) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        super(parent, type);
        this.myNames = names;
    }

    @Override
    @NotNull
    public PsiClassType[] getReferencedTypes() {
        if (this.myTypes != null) {
            if (this.myTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedTypes"));
            }
            return this.myTypes;
        }
        if (this.myNames.length == 0) {
            this.myTypes = PsiClassType.EMPTY_ARRAY;
            if (this.myTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedTypes"));
            }
            return this.myTypes;
        }
        PsiClassType[] types = new PsiClassType[this.myNames.length];
        boolean compiled = ((JavaClassReferenceListElementType)this.getStubType()).isCompiled(this);
        if (compiled) {
            for (int i = 0; i < types.length; ++i) {
                types[i] = new PsiClassReferenceType(new ClsJavaCodeReferenceElementImpl((PsiElement)this.getPsi(), this.myNames[i].toString()), null);
            }
        } else {
            PsiElementFactory factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            int nullCount = 0;
            PsiReferenceList psi = (PsiReferenceList)this.getPsi();
            for (int i = 0; i < types.length; ++i) {
                try {
                    PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(this.myNames[i].toString(), psi);
                    ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                    types[i] = factory.createType(ref);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    types[i] = null;
                    ++nullCount;
                }
            }
            if (nullCount > 0) {
                PsiClassType[] newTypes = new PsiClassType[types.length - nullCount];
                int cnt = 0;
                for (PsiClassType type : types) {
                    if (type == null) continue;
                    newTypes[cnt++] = type;
                }
                types = newTypes;
            }
        }
        this.myTypes = types;
        PsiClassType[] psiClassTypeArray = (PsiClassType[])types.clone();
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedTypes"));
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public String[] getReferencedNames() {
        String[] names = ArrayUtil.newStringArray(this.myNames.length);
        for (int i = 0; i < names.length; ++i) {
            names[i] = StringRef.toString(this.myNames[i]);
        }
        if (names == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedNames"));
        }
        return names;
    }

    @Override
    @NotNull
    public PsiReferenceList.Role getRole() {
        PsiReferenceList.Role role = JavaClassReferenceListElementType.elementTypeToRole(this.getStubType());
        if (role == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getRole"));
        }
        return role;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiRefListStub[").append((Object)this.getRole()).append(':');
        for (int i = 0; i < this.myNames.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.myNames[i]);
        }
        builder.append(']');
        return builder.toString();
    }
}

