/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collections;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AnonymousHasLambdaAlternativeInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(AnonymousHasLambdaAlternativeInspection.class);
    private static AnonymousLambdaAlternative[] ALTERNATIVES = new AnonymousLambdaAlternative[]{new AnonymousLambdaAlternative("java.lang.ThreadLocal", "initialValue", "java.lang.ThreadLocal.withInitial($lambda$)", "ThreadLocal.withInitial"), new AnonymousLambdaAlternative("java.lang.Thread", "run", "new java.lang.Thread($lambda$)", "constructor accepting lambda")};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                super.visitAnonymousClass(aClass);
                PsiExpressionList argumentList = aClass.getArgumentList();
                if (AnonymousCanBeLambdaInspection.isLambdaForm(aClass, Collections.emptySet()) && argumentList != null && argumentList.getExpressions().length == 0) {
                    PsiMethod method = aClass.getMethods()[0];
                    PsiClassType type = aClass.getBaseClassType();
                    AnonymousLambdaAlternative alternative = this.getAlternative(type.resolve(), method);
                    if (alternative != null) {
                        PsiElement lBrace = aClass.getLBrace();
                        LOG.assertTrue(lBrace != null);
                        TextRange rangeInElement = new TextRange(0, lBrace.getStartOffsetInParent() + aClass.getStartOffsetInParent() - 1);
                        holder.registerProblem(aClass.getParent(), "Anonymous #ref #loc can be replaced with " + alternative.myReplacementMessage, ProblemHighlightType.LIKE_UNUSED_SYMBOL, rangeInElement, new ReplaceWithLambdaAlternativeFix(alternative));
                    }
                }
            }

            @Contract(value="null, _ -> null")
            private AnonymousLambdaAlternative getAlternative(PsiClass type, PsiMethod method) {
                if (type == null) {
                    return null;
                }
                for (AnonymousLambdaAlternative alternative : ALTERNATIVES) {
                    if (!alternative.myClassName.equals(type.getQualifiedName()) || !alternative.myMethodName.equals(method.getName())) continue;
                    return alternative;
                }
                return null;
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    static class ReplaceWithLambdaAlternativeFix
    implements LocalQuickFix {
        @NotNull
        private final AnonymousLambdaAlternative myAlternative;

        public ReplaceWithLambdaAlternativeFix(@NotNull AnonymousLambdaAlternative alternative) {
            if (alternative == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alternative", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection$ReplaceWithLambdaAlternativeFix", "<init>"));
            }
            this.myAlternative = alternative;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with " + this.myAlternative.myReplacementMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection$ReplaceWithLambdaAlternativeFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace anonymous class with lambda alternative" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection$ReplaceWithLambdaAlternativeFix", "getFamilyName"));
            }
            return "Replace anonymous class with lambda alternative";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection$ReplaceWithLambdaAlternativeFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection$ReplaceWithLambdaAlternativeFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiAnonymousClass aClass = ((PsiNewExpression)element).getAnonymousClass();
            if (aClass == null) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length != 1) {
                return;
            }
            PsiMethod method = methods[0];
            if (method.getBody() == null) {
                return;
            }
            UnaryOperator replacer = lambda2 -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection$ReplaceWithLambdaAlternativeFix", "lambda$applyFix$1"));
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
                PsiElement replacement = element.replace(factory.createExpressionFromText(this.myAlternative.myLambdaAlternative, element));
                PsiElement[] lambdaPositions = PsiTreeUtil.collectElements(replacement, e -> e instanceof PsiReference && e.textMatches("$lambda$"));
                LOG.assertTrue(lambdaPositions.length == 1);
                return (PsiLambdaExpression)lambdaPositions[0].replace((PsiElement)lambda2);
            };
            AnonymousCanBeLambdaInspection.generateLambdaByMethod(aClass, method, replacer, true);
        }
    }

    static final class AnonymousLambdaAlternative {
        final String myClassName;
        final String myMethodName;
        final String myLambdaAlternative;
        final String myReplacementMessage;

        public AnonymousLambdaAlternative(String className, String methodName, String lambdaAlternative, String replacementMessage) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myLambdaAlternative = lambdaAlternative;
            this.myReplacementMessage = replacementMessage;
        }
    }
}

