/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiReferenceListImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaClassReferenceListElementType
extends JavaStubElementType<PsiClassReferenceListStub, PsiReferenceList> {
    public JavaClassReferenceListElementType(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "<init>"));
        }
        super(id, true);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull PsiClassReferenceListStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createClassReferenceList(stub);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "createPsi"));
        }
        return new PsiReferenceListImpl(node);
    }

    @Override
    public PsiClassReferenceListStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        JavaClassReferenceListElementType type = (JavaClassReferenceListElementType)node.getTokenType();
        return new PsiClassReferenceListStubImpl(type, parentStub, JavaClassReferenceListElementType.getTexts(tree, node));
    }

    @NotNull
    private static String[] getTexts(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "getTexts"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "getTexts"));
        }
        List<LighterASTNode> refs = LightTreeUtil.getChildrenOfType(tree, node, JavaElementType.JAVA_CODE_REFERENCE);
        String[] texts = ArrayUtil.newStringArray(refs.size());
        for (int i2 = 0; i2 < refs.size(); ++i2) {
            texts[i2] = LightTreeUtil.toFilteredString(tree, refs.get(i2), null);
        }
        if (texts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "getTexts"));
        }
        return texts;
    }

    @Override
    public void serialize(@NotNull PsiClassReferenceListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "serialize"));
        }
        String[] names = stub.getReferencedNames();
        dataStream.writeVarInt(names.length);
        for (String name : names) {
            dataStream.writeName(name);
        }
    }

    @Override
    @NotNull
    public PsiClassReferenceListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "deserialize"));
        }
        int len = dataStream.readVarInt();
        StringRef[] names = StringRef.createArray(len);
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = dataStream.readName();
        }
        PsiClassReferenceListStubImpl psiClassReferenceListStubImpl = new PsiClassReferenceListStubImpl(this, parentStub, names);
        if (psiClassReferenceListStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "deserialize"));
        }
        return psiClassReferenceListStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiClassReferenceListStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "indexStub"));
        }
        PsiReferenceList.Role role = stub.getRole();
        if (role == PsiReferenceList.Role.EXTENDS_LIST || role == PsiReferenceList.Role.IMPLEMENTS_LIST) {
            StubElement parentStub;
            String[] names;
            for (String name : names = stub.getReferencedNames()) {
                String shortName = PsiNameHelper.getShortClassName(name);
                if (StringUtil.isEmptyOrSpaces(shortName)) continue;
                sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, shortName);
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST && (parentStub = stub.getParentStub()) instanceof PsiClassStub) {
                PsiClassStub psiClassStub = (PsiClassStub)parentStub;
                if (psiClassStub.isEnum()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Enum");
                }
                if (psiClassStub.isAnnotationType()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Annotation");
                }
            }
        }
    }

    @NotNull
    public static PsiReferenceList.Role elementTypeToRole(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "elementTypeToRole"));
        }
        if (type == JavaStubElementTypes.EXTENDS_BOUND_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "elementTypeToRole"));
            }
            return role;
        }
        if (type == JavaStubElementTypes.EXTENDS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_LIST;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "elementTypeToRole"));
            }
            return role;
        }
        if (type == JavaStubElementTypes.IMPLEMENTS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.IMPLEMENTS_LIST;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "elementTypeToRole"));
            }
            return role;
        }
        if (type == JavaStubElementTypes.THROWS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.THROWS_LIST;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "elementTypeToRole"));
            }
            return role;
        }
        if (type == JavaStubElementTypes.PROVIDES_WITH_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.PROVIDES_WITH_LIST;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType", "elementTypeToRole"));
            }
            return role;
        }
        throw new RuntimeException("Unknown element type: " + type);
    }
}

