/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\u0006\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\rH\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0013H\u0016J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0016J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0002\"\u0004\b\u0001\u0010\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H\u00180\u001aH\u0017J0\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0002\"\u0004\b\u0001\u0010\u00182\u001a\u0010\u0019\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u00020\u001aH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/concurrency/RejectedPromise;", "T", "Lorg/jetbrains/concurrency/Promise;", "error", "", "(Ljava/lang/Throwable;)V", "blockingGet", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "done", "Lcom/intellij/util/Consumer;", "getState", "Lorg/jetbrains/concurrency/Promise$State;", "notify", "", "child", "Lorg/jetbrains/concurrency/AsyncPromise;", "processed", "fulfilled", "rejected", "then", "SUB_RESULT", "handler", "Lcom/intellij/util/Function;", "thenAsync", "projectModel-api"})
public final class RejectedPromise<T>
implements Promise<T> {
    private final Throwable error;

    @Override
    @NotNull
    public Promise.State getState() {
        return Promise.State.REJECTED;
    }

    @Override
    @NotNull
    public RejectedPromise<T> done(@NotNull Consumer<? super T> done2) {
        Intrinsics.checkParameterIsNotNull(done2, (String)"done");
        return this;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> fulfilled) {
        Intrinsics.checkParameterIsNotNull(fulfilled, (String)"fulfilled");
        fulfilled.setError(this.error);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected2) {
        Intrinsics.checkParameterIsNotNull(rejected2, (String)"rejected");
        if (!AsyncPromiseKt.isObsolete(rejected2)) {
            rejected2.consume(this.error);
        }
        return this;
    }

    @Override
    @NotNull
    public RejectedPromise<T> processed(@NotNull Consumer<? super T> processed2) {
        Intrinsics.checkParameterIsNotNull(processed2, (String)"processed");
        processed2.consume(null);
        return this;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        RejectedPromise rejectedPromise = this;
        if (rejectedPromise == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<SUB_RESULT>");
        }
        return rejectedPromise;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        RejectedPromise rejectedPromise = this;
        if (rejectedPromise == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<SUB_RESULT>");
        }
        return rejectedPromise;
    }

    @Override
    public void notify(@NotNull AsyncPromise<? super T> child) {
        Intrinsics.checkParameterIsNotNull(child, (String)"child");
        child.setError(this.error);
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        throw this.error;
    }

    public RejectedPromise(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this.error = error;
    }
}

