/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaReferencesProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String VALUE_ATTR_NAME = "value";
    @NonNls
    static final String NAME_ATTR_NAME = "name";
    @NonNls
    static final String MEMBER_TYPES_ATTR_NAME = "memberTypes";
    @NonNls
    static final String ITEM_TYPE_ATTR_NAME = "itemType";
    @NonNls
    static final String BASE_ATTR_NAME = "base";
    @NonNls
    static final String GROUP_TAG_NAME = "group";
    @NonNls
    static final String ATTRIBUTE_GROUP_TAG_NAME = "attributeGroup";
    @NonNls
    static final String ATTRIBUTE_TAG_NAME = "attribute";
    @NonNls
    static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    static final String SIMPLE_TYPE_TAG_NAME = "simpleType";
    @NonNls
    static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    static final String REF_ATTR_NAME = "ref";
    @NonNls
    static final String TYPE_ATTR_NAME = "type";
    @NonNls
    static final String SUBSTITUTION_GROUP_ATTR_NAME = "substitutionGroup";

    public String[] getCandidateAttributeNamesForSchemaReferences() {
        return new String[]{REF_ATTR_NAME, TYPE_ATTR_NAME, BASE_ATTR_NAME, NAME_ATTR_NAME, SUBSTITUTION_GROUP_ATTR_NAME, MEMBER_TYPES_ATTR_NAME, VALUE_ATTR_NAME, ITEM_TYPE_ATTR_NAME};
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_TAG_NAME, "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider", "getReferencesByElement"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String attrName = ((XmlAttribute)parent).getName();
        if (VALUE_ATTR_NAME.equals(attrName)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (NAME_ATTR_NAME.equals(attrName)) {
            PsiReference[] psiReferenceArray2 = new PsiReference[]{new NameReference(element)};
            if (psiReferenceArray2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider", "getReferencesByElement"));
            }
            return psiReferenceArray2;
        }
        if (MEMBER_TYPES_ATTR_NAME.equals(attrName)) {
            ArrayList<TypeOrElementOrAttributeReference> result = new ArrayList<TypeOrElementOrAttributeReference>(1);
            String text = element.getText();
            int lastIndex = 1;
            int testLength = text.length();
            for (int i2 = 1; i2 < testLength; ++i2) {
                if (!Character.isWhitespace(text.charAt(i2))) continue;
                if (lastIndex != i2) {
                    result.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, i2)));
                }
                lastIndex = i2 + 1;
            }
            if (lastIndex != testLength - 1) {
                result.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, testLength - 1)));
            }
            PsiReference[] psiReferenceArray3 = result.toArray(new PsiReference[result.size()]);
            if (psiReferenceArray3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider", "getReferencesByElement"));
            }
            return psiReferenceArray3;
        }
        PsiReference prefix = SchemaReferencesProvider.createSchemaPrefixReference(element);
        PsiReference ref = SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, prefix == null ? null : prefix.getCanonicalText());
        if (prefix == null) {
            PsiReference[] psiReferenceArray4 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray4;
            psiReferenceArray4[0] = ref;
        } else {
            PsiReference[] psiReferenceArray5 = new PsiReference[2];
            psiReferenceArray5[0] = ref;
            psiReferenceArray = psiReferenceArray5;
            psiReferenceArray5[1] = prefix;
        }
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static PsiReference createTypeOrElementOrAttributeReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_TAG_NAME, "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider", "createTypeOrElementOrAttributeReference"));
        }
        return SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, null);
    }

    public static PsiReference createTypeOrElementOrAttributeReference(@NotNull PsiElement element, String ns) {
        int offset;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_TAG_NAME, "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider", "createTypeOrElementOrAttributeReference"));
        }
        int length = element.getTextLength();
        int n = offset = element instanceof XmlAttributeValue ? XmlUtil.findPrefixByQualifiedName(((XmlAttributeValue)element).getValue()).length() : 0;
        if (offset > 0) {
            ++offset;
        }
        TypeOrElementOrAttributeReference ref = new TypeOrElementOrAttributeReference(element, length >= 2 ? new TextRange(1 + offset, length - 1) : TextRange.EMPTY_RANGE);
        ref.setNamespacePrefix(ns);
        return ref;
    }

    @Nullable
    private static PsiReference createSchemaPrefixReference(PsiElement element) {
        XmlAttributeValue attributeValue;
        String prefix;
        if (element instanceof XmlAttributeValue && !(prefix = XmlUtil.findPrefixByQualifiedName((attributeValue = (XmlAttributeValue)element).getValue())).isEmpty()) {
            return new SchemaPrefixReference(attributeValue, TextRange.from(1, prefix.length()), prefix, null);
        }
        return null;
    }

    @Nullable
    public static XmlNSDescriptorImpl findRedefinedDescriptor(XmlTag tag, String text) {
        String localName = XmlUtil.findLocalNameByQualifiedName(text);
        for (XmlTag parentTag = tag.getParentTag(); parentTag != null; parentTag = parentTag.getParentTag()) {
            XmlTag grandParent;
            if (!localName.equals(parentTag.getAttributeValue(NAME_ATTR_NAME)) || (grandParent = parentTag.getParentTag()) == null || !"redefine".equals(grandParent.getLocalName())) continue;
            return XmlNSDescriptorImpl.getRedefinedElementDescriptor(grandParent);
        }
        return null;
    }

    public static class NameReference
    implements PsiReference {
        private final PsiElement myElement;

        public NameReference(PsiElement element) {
            this.myElement = element;
        }

        @Override
        public PsiElement getElement() {
            return this.myElement;
        }

        @Override
        public TextRange getRangeInElement() {
            return ElementManipulators.getValueTextRange(this.myElement);
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            return this.myElement.getParent().getParent();
        }

        @Override
        @NotNull
        public String getCanonicalText() {
            String text = this.myElement.getText();
            String string = text.substring(1, text.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$NameReference", "getCanonicalText"));
            }
            return string;
        }

        @Override
        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return ElementManipulators.getManipulator(this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName.substring(newElementName.indexOf(58) + 1));
        }

        @Override
        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SchemaReferencesProvider.ELEMENT_TAG_NAME, "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$NameReference", "bindToElement"));
            }
            return null;
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$NameReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @Override
        public boolean isSoft() {
            return true;
        }
    }
}

