/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlExtension
extends XmlExtension {
    public static final XmlExtension DEFAULT_EXTENSION = new DefaultXmlExtension();
    private static final Logger LOG = Logger.getInstance(DefaultXmlExtension.class);

    @Override
    public boolean isAvailable(PsiFile file) {
        return true;
    }

    @Override
    @NotNull
    public List<XmlExtension.TagInfo> getAvailableTagNames(@NotNull XmlFile file, @NotNull XmlTag context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/DefaultXmlExtension", "getAvailableTagNames"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/DefaultXmlExtension", "getAvailableTagNames"));
        }
        HashSet<String> namespaces = new HashSet<String>(Arrays.asList(context.knownNamespaces()));
        List<XmlSchemaProvider> providers = XmlSchemaProvider.getAvailableProviders(file);
        for (XmlSchemaProvider provider : providers) {
            namespaces.addAll(provider.getAvailableNamespaces(file, null));
        }
        ArrayList<String> nsInfo = new ArrayList<String>();
        List<XmlElementDescriptor> descriptors = TagNameVariantCollector.getTagDescriptors(context, namespaces, nsInfo);
        ArrayList<XmlExtension.TagInfo> set = new ArrayList<XmlExtension.TagInfo>();
        for (int i2 = 0; i2 < descriptors.size(); ++i2) {
            final XmlElementDescriptor descriptor = descriptors.get(i2);
            String qualifiedName = descriptor.getName(context);
            LOG.assertTrue(qualifiedName != null, descriptor + " returned null name");
            int pos = qualifiedName.indexOf(58);
            String name = pos >= 0 ? qualifiedName.substring(pos + 1) : qualifiedName;
            set.add(new XmlExtension.TagInfo(name, (String)nsInfo.get(i2)){

                @Override
                @Nullable
                public PsiElement getDeclaration() {
                    return descriptor.getDeclaration();
                }
            });
        }
        ArrayList<XmlExtension.TagInfo> arrayList = set;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/DefaultXmlExtension", "getAvailableTagNames"));
        }
        return arrayList;
    }

    public static Set<String> filterNamespaces(Set<String> namespaces, String tagName, XmlFile context) {
        if (tagName == null) {
            return namespaces;
        }
        HashSet<String> set = new HashSet<String>();
        block0: for (String namespace : namespaces) {
            XmlElementDescriptor[] elementDescriptors;
            XmlFile xmlFile = XmlUtil.findNamespace(context, namespace);
            if (xmlFile == null) continue;
            XmlDocument document = xmlFile.getDocument();
            assert (document != null);
            XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
            assert (nsDescriptor != null);
            for (XmlElementDescriptor elementDescriptor : elementDescriptors = nsDescriptor.getRootElementsDescriptors(document)) {
                LOG.assertTrue(elementDescriptor != null, "Null returned from " + nsDescriptor);
                if (!DefaultXmlExtension.hasTag(elementDescriptor, tagName, new HashSet<XmlElementDescriptor>())) continue;
                set.add(namespace);
                continue block0;
            }
        }
        return set;
    }

    private static boolean hasTag(@NotNull XmlElementDescriptor elementDescriptor, String tagName, Set<XmlElementDescriptor> visited) {
        if (elementDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDescriptor", "com/intellij/xml/DefaultXmlExtension", "hasTag"));
        }
        String name = elementDescriptor.getDefaultName();
        if (name == null) {
            LOG.error(elementDescriptor + " returned null as default name");
            return false;
        }
        if (name.equals(tagName)) {
            return true;
        }
        for (XmlElementDescriptor descriptor : elementDescriptor.getElementsDescriptors(null)) {
            if (visited.contains(elementDescriptor)) continue;
            visited.add(elementDescriptor);
            if (!DefaultXmlExtension.hasTag(descriptor, tagName, visited)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SchemaPrefix getPrefixDeclaration(XmlTag context, String namespacePrefix) {
        String nsDeclarationAttrName = null;
        for (XmlTag t = context; t != null; t = t.getParentTag()) {
            XmlAttribute attribute;
            if (!t.hasNamespaceDeclarations()) continue;
            if (nsDeclarationAttrName == null) {
                String string = nsDeclarationAttrName = namespacePrefix.length() > 0 ? "xmlns:" + namespacePrefix : "xmlns";
            }
            if ((attribute = t.getAttribute(nsDeclarationAttrName)) == null) continue;
            String attrPrefix = attribute.getNamespacePrefix();
            TextRange textRange = TextRange.from(attrPrefix.length() + 1, namespacePrefix.length());
            return new SchemaPrefix(attribute, textRange, namespacePrefix);
        }
        return null;
    }
}

