/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TrivialIfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getID() {
        if ("RedundantIfStatement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection", "getID"));
        }
        return "RedundantIfStatement";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("trivial.if.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("trivial.if.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new TrivialIfFix();
    }

    public static void simplify(PsiIfStatement statement) {
        if (TrivialIfInspection.isSimplifiableAssignment(statement)) {
            TrivialIfInspection.replaceSimplifiableAssignment(statement);
        } else if (TrivialIfInspection.isSimplifiableReturn(statement)) {
            TrivialIfInspection.replaceSimplifiableReturn(statement);
        } else if (TrivialIfInspection.isSimplifiableImplicitReturn(statement)) {
            TrivialIfInspection.replaceSimplifiableImplicitReturn(statement);
        } else if (TrivialIfInspection.isSimplifiableAssignmentNegated(statement)) {
            TrivialIfInspection.replaceSimplifiableAssignmentNegated(statement);
        } else if (TrivialIfInspection.isSimplifiableReturnNegated(statement)) {
            TrivialIfInspection.replaceSimplifiableReturnNegated(statement);
        } else if (TrivialIfInspection.isSimplifiableImplicitReturnNegated(statement)) {
            TrivialIfInspection.replaceSimplifiableImplicitReturnNegated(statement);
        } else if (TrivialIfInspection.isSimplifiableImplicitAssignment(statement)) {
            TrivialIfInspection.replaceSimplifiableImplicitAssignment(statement);
        } else if (TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(statement)) {
            TrivialIfInspection.replaceSimplifiableImplicitAssignmentNegated(statement);
        }
    }

    private static void replaceSimplifiableImplicitReturn(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward(statement, PsiWhiteSpace.class);
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement(statement, newStatement);
        assert (nextStatement != null);
        nextStatement.delete();
    }

    private static void replaceSimplifiableReturn(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        Collection<PsiComment> comments = PsiTreeUtil.findChildrenOfType(statement, PsiComment.class);
        PsiElement parent = statement.getParent();
        for (PsiComment comment : comments) {
            parent.addBefore(comment.copy(), statement);
        }
        String conditionText = condition.getText();
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement(statement, newStatement);
    }

    private static void replaceSimplifiableAssignment(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        List<PsiComment> comments = ContainerUtil.map(PsiTreeUtil.findChildrenOfType(statement, PsiComment.class), comment -> (PsiComment)comment.copy());
        String conditionText = condition.getText();
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiElement parent = statement.getParent();
        for (PsiComment comment2 : comments) {
            parent.addBefore(comment2, statement);
        }
        PsiReplacementUtil.replaceStatement(statement, lhsText + operand + conditionText + ';');
    }

    private static void replaceSimplifiableImplicitAssignment(PsiIfStatement statement) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward(statement, PsiWhiteSpace.class);
        if (prevStatement == null) {
            return;
        }
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement(statement, lhsText + operand + conditionText + ';');
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitAssignmentNegated(PsiIfStatement statement) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward(statement, PsiWhiteSpace.class);
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement(statement, lhsText + operand + conditionText + ';');
        assert (prevStatement != null);
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitReturnNegated(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward(statement, PsiWhiteSpace.class);
        if (nextStatement == null) {
            return;
        }
        PsiElement nextSibling = statement.getNextSibling();
        if (nextSibling != nextStatement) {
            statement.getParent().deleteChildRange(nextSibling, nextStatement.getPrevSibling());
        }
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement(statement, newStatement);
        nextStatement.delete();
    }

    private static void replaceSimplifiableReturnNegated(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement(statement, newStatement);
    }

    private static void replaceSimplifiableAssignmentNegated(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement(statement, lhsText + operand + conditionText + ';');
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialIfVisitor();
    }

    public static boolean isTrivial(PsiIfStatement ifStatement) {
        if (PsiUtilCore.hasErrorElementChild(ifStatement)) {
            return false;
        }
        if (TrivialIfInspection.isSimplifiableAssignment(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableReturn(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableAssignmentNegated(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableReturnNegated(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableImplicitReturnNegated(ifStatement)) {
            return true;
        }
        if (TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement)) {
            return true;
        }
        return TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(ifStatement);
    }

    private static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableImplicitReturnNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement, String thenReturn, String elseReturn) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward(ifStatement, PsiWhiteSpace.class);
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        return TrivialIfInspection.isReturn(thenBranch, thenReturn) && TrivialIfInspection.isReturn(elseBranch, elseReturn);
    }

    private static boolean isSimplifiableReturn(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableReturn(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableReturnNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableReturn(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableReturn(PsiIfStatement ifStatement, String thenReturn, String elseReturn) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        return TrivialIfInspection.isReturn(thenBranch, thenReturn) && TrivialIfInspection.isReturn(elseBranch, elseReturn);
    }

    private static boolean isSimplifiableAssignment(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableAssignmentNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableAssignment(PsiIfStatement ifStatement, String thenAssignment, String elseAssignment) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        return TrivialIfInspection.isSimplifiableAssignment(thenBranch, elseBranch, thenAssignment, elseAssignment);
    }

    private static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableImplicitAssignmentNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement, String thenAssignment, String elseAssignment) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsBackward(ifStatement, PsiWhiteSpace.class);
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        return TrivialIfInspection.isSimplifiableAssignment(thenBranch, elseBranch, thenAssignment, elseAssignment);
    }

    private static boolean isSimplifiableAssignment(PsiStatement thenBranch, PsiStatement elseBranch, String thenAssignment, String elseAssignment) {
        if (!TrivialIfInspection.isAssignment(thenBranch, thenAssignment) || !TrivialIfInspection.isAssignment(elseBranch, elseAssignment)) {
            return false;
        }
        PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
        PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
        PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
        PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
        IElementType thenTokenType = thenExpression.getOperationTokenType();
        if (!thenTokenType.equals(elseExpression.getOperationTokenType())) {
            return false;
        }
        PsiExpression thenLhs = thenExpression.getLExpression();
        PsiExpression elseLhs = elseExpression.getLExpression();
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs);
    }

    private static boolean isReturn(PsiStatement statement, String value) {
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
        return returnValue != null && value.equals(returnValue.getText());
    }

    private static boolean isAssignment(PsiStatement statement, String value) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
        PsiExpression rhs = ParenthesesUtils.stripParentheses(assignment.getRExpression());
        return rhs != null && value.equals(rhs.getText());
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(ifStatement);
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            if (TrivialIfInspection.isTrivial(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
            }
        }
    }

    private static class TrivialIfFix
    extends InspectionGadgetsFix {
        private TrivialIfFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement ifKeywordElement = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)ifKeywordElement.getParent();
            TrivialIfInspection.simplify(statement);
        }
    }
}

