/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;

public class XmlTextFilter
implements ElementFilter {
    protected final String[] myValue;

    public XmlTextFilter(@NonNls String value) {
        this.myValue = new String[1];
        this.myValue[0] = value;
    }

    public XmlTextFilter(String ... values) {
        this.myValue = values;
    }

    @Override
    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        if (element != null) {
            String text = this.getTextByElement(element);
            for (String value : this.myValue) {
                if (value != null && !value.equals(text)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        String ret = "(";
        for (int i2 = 0; i2 < this.myValue.length; ++i2) {
            ret = ret + this.myValue[i2];
            if (i2 >= this.myValue.length - 1) continue;
            ret = ret + " | ";
        }
        ret = ret + ")";
        return ret;
    }

    protected String getTextByElement(Object element) {
        String elementValue = null;
        if (element instanceof PsiNamedElement) {
            elementValue = element instanceof XmlTag ? ((XmlTag)element).getLocalName() : ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiElement) {
            elementValue = ((PsiElement)element).getText();
        }
        return elementValue;
    }
}

