/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;

public class ReplaceExpressionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil");

    public static boolean isNeedParenthesis(ASTNode oldExpr, ASTNode newExpr) {
        int parentPriority;
        ASTNode oldParent = oldExpr.getTreeParent();
        if (!ElementType.EXPRESSION_BIT_SET.contains(oldParent.getElementType())) {
            return false;
        }
        int priority = ReplaceExpressionUtil.getExpressionPriority(newExpr);
        if (priority > (parentPriority = ReplaceExpressionUtil.getExpressionPriority(oldParent))) {
            return false;
        }
        IElementType i2 = oldParent.getElementType();
        if (i2 == JavaElementType.ASSIGNMENT_EXPRESSION) {
            return priority < parentPriority || ((CompositeElement)oldParent).getChildRole(oldExpr) == 61;
        }
        if (i2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            int role = ((CompositeElement)oldParent).getChildRole(oldExpr);
            if (role == 112) {
                return false;
            }
            return priority < parentPriority || role != 113;
        }
        if (i2 == JavaElementType.BINARY_EXPRESSION || i2 == JavaElementType.POLYADIC_EXPRESSION) {
            if (priority < parentPriority) {
                return true;
            }
            PsiElement element = SourceTreeToPsiMap.treeElementToPsi(oldParent);
            IElementType opType = ((PsiPolyadicExpression)element).getOperationTokenType();
            return ((CompositeElement)oldParent).getChildRole(oldExpr) != 61 && opType != JavaTokenType.PLUS && opType != JavaTokenType.ASTERISK && opType != JavaTokenType.ANDAND && opType != JavaTokenType.OROR;
        }
        if (i2 == JavaElementType.INSTANCE_OF_EXPRESSION) {
            return priority < parentPriority;
        }
        if (i2 == JavaElementType.PREFIX_EXPRESSION || i2 == JavaElementType.TYPE_CAST_EXPRESSION) {
            return priority < parentPriority;
        }
        if (i2 == JavaElementType.POSTFIX_EXPRESSION) {
            return priority <= parentPriority;
        }
        if (i2 == JavaElementType.REFERENCE_EXPRESSION || i2 == JavaElementType.METHOD_REF_EXPRESSION) {
            return priority < parentPriority;
        }
        if (i2 == JavaElementType.METHOD_CALL_EXPRESSION) {
            return false;
        }
        if (i2 == JavaElementType.NEW_EXPRESSION) {
            return false;
        }
        if (i2 == JavaElementType.ARRAY_ACCESS_EXPRESSION) {
            int role = ((CompositeElement)oldParent).getChildRole(oldExpr);
            return role != 76 && role != 89 && priority < parentPriority;
        }
        if (i2 == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
            return false;
        }
        if (i2 == JavaElementType.PARENTH_EXPRESSION) {
            return false;
        }
        if (i2 == JavaElementType.LITERAL_EXPRESSION || i2 == JavaElementType.THIS_EXPRESSION || i2 == JavaElementType.SUPER_EXPRESSION || i2 == JavaElementType.CLASS_OBJECT_ACCESS_EXPRESSION || i2 == JavaElementType.LAMBDA_EXPRESSION) {
            return false;
        }
        LOG.assertTrue(false);
        return false;
    }

    private static int getExpressionPriority(ASTNode expr) {
        IElementType i2 = expr.getElementType();
        if (i2 == JavaElementType.ASSIGNMENT_EXPRESSION) {
            return 0;
        }
        if (i2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            return 1;
        }
        if (i2 == JavaElementType.BINARY_EXPRESSION || i2 == JavaElementType.POLYADIC_EXPRESSION) {
            PsiElement element = SourceTreeToPsiMap.treeElementToPsi(expr);
            IElementType opType = ((PsiPolyadicExpression)element).getOperationTokenType();
            if (opType == JavaTokenType.OROR) {
                return 2;
            }
            if (opType == JavaTokenType.ANDAND) {
                return 3;
            }
            if (opType == JavaTokenType.OR) {
                return 4;
            }
            if (opType == JavaTokenType.XOR) {
                return 5;
            }
            if (opType == JavaTokenType.AND) {
                return 6;
            }
            if (opType == JavaTokenType.EQEQ || opType == JavaTokenType.NE) {
                return 7;
            }
            if (opType == JavaTokenType.LT || opType == JavaTokenType.GT || opType == JavaTokenType.LE || opType == JavaTokenType.GE) {
                return 8;
            }
            if (opType == JavaTokenType.LTLT || opType == JavaTokenType.GTGT || opType == JavaTokenType.GTGTGT) {
                return 9;
            }
            if (opType == JavaTokenType.PLUS || opType == JavaTokenType.MINUS) {
                return 10;
            }
            if (opType == JavaTokenType.ASTERISK || opType == JavaTokenType.DIV || opType == JavaTokenType.PERC) {
                return 11;
            }
            return 8;
        }
        if (i2 == JavaElementType.INSTANCE_OF_EXPRESSION) {
            return 8;
        }
        if (i2 == JavaElementType.PREFIX_EXPRESSION || i2 == JavaElementType.TYPE_CAST_EXPRESSION) {
            return 12;
        }
        if (i2 == JavaElementType.POSTFIX_EXPRESSION) {
            return 13;
        }
        if (i2 == JavaElementType.LITERAL_EXPRESSION || i2 == JavaElementType.REFERENCE_EXPRESSION || i2 == JavaElementType.THIS_EXPRESSION || i2 == JavaElementType.SUPER_EXPRESSION || i2 == JavaElementType.PARENTH_EXPRESSION || i2 == JavaElementType.METHOD_CALL_EXPRESSION || i2 == JavaElementType.CLASS_OBJECT_ACCESS_EXPRESSION || i2 == JavaElementType.NEW_EXPRESSION || i2 == JavaElementType.ARRAY_ACCESS_EXPRESSION || i2 == JavaElementType.ARRAY_INITIALIZER_EXPRESSION || i2 == JavaElementType.JAVA_CODE_REFERENCE || i2 == JavaElementType.METHOD_REF_EXPRESSION || i2 == JavaElementType.LAMBDA_EXPRESSION || i2 == JavaElementType.EMPTY_EXPRESSION) {
            return 14;
        }
        LOG.error("Unknown element type:" + i2);
        return -1;
    }
}

