/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.util.PsiUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JavaModuleNamingInspection
extends BaseJavaLocalInspectionTool {
    private final Pattern TRAILING_DIGITS = Pattern.compile("^([^0-9]+)\\d+$");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/JavaModuleNamingInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = !PsiUtil.isModuleFile(holder.getFile()) ? PsiElementVisitor.EMPTY_VISITOR : new JavaElementVisitor(){

            @Override
            public void visitModule(PsiJavaModule module) {
                super.visitModule(module);
                PsiJavaModuleReferenceElement nameElement = module.getNameIdentifier();
                String name = nameElement.getReferenceText();
                Matcher matcher = JavaModuleNamingInspection.this.TRAILING_DIGITS.matcher(name);
                if (matcher.matches()) {
                    String message = InspectionsBundle.message("inspection.java.module.naming.terminal.digits", name);
                    holder.registerProblem((PsiElement)nameElement, message, QuickFixFactory.getInstance().createRenameElementFix(module, matcher.group(1)));
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/JavaModuleNamingInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }
}

