/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameParameterValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameParameterValueInspectionBase
extends GlobalJavaBatchInspectionTool {
    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        ArrayList<ProblemDescriptor> problems = null;
        if (refEntity instanceof RefMethod) {
            RefParameter[] parameters;
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.hasSuperMethods()) {
                return null;
            }
            if (refMethod.isEntry()) {
                return null;
            }
            for (RefParameter refParameter : parameters = refMethod.getParameters()) {
                String value = refParameter.getActualValueIfSame();
                if (value == null || !globalContext.shouldCheck(refParameter, this)) continue;
                if (problems == null) {
                    problems = new ArrayList<ProblemDescriptor>(1);
                }
                problems.add(this.registerProblem(manager, refParameter.getElement(), value));
            }
        }
        return problems == null ? null : problems.toArray(new CommonProblemDescriptor[problems.size()]);
    }

    @Override
    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "queryExternalUsagesRequests"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "queryExternalUsagesRequests"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "queryExternalUsagesRequests"));
        }
        manager.iterate(new RefJavaVisitor(){

            @Override
            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$1", "visitElement"));
                }
                if (refEntity instanceof RefElement && processor.getDescriptions(refEntity) != null) {
                    refEntity.accept(new RefJavaVisitor(){

                        @Override
                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$1$1", "visitMethod"));
                            }
                            globalContext.enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                                @Override
                                public boolean process(PsiReference psiReference) {
                                    processor.ignoreElement(refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.same.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("SameParameterValue" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "getShortName"));
        }
        return "SameParameterValue";
    }

    @Override
    @Nullable
    public QuickFix getQuickFix(String hint) {
        if (hint == null) {
            return null;
        }
        int spaceIdx = hint.indexOf(32);
        if (spaceIdx == -1 || spaceIdx >= hint.length() - 1) {
            return null;
        }
        String paramName = hint.substring(0, spaceIdx);
        String value = hint.substring(spaceIdx + 1);
        return this.createFix(paramName, value);
    }

    protected LocalQuickFix createFix(String paramName, String value) {
        return null;
    }

    @Override
    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "getHint"));
        }
        return fix.toString();
    }

    @Override
    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new LocalSameParameterValueInspection(this);
    }

    private ProblemDescriptor registerProblem(@NotNull InspectionManager manager, PsiParameter parameter, String value) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "registerProblem"));
        }
        String name = parameter.getName();
        return manager.createProblemDescriptor((PsiElement)ObjectUtils.notNull(parameter.getNameIdentifier(), parameter), InspectionsBundle.message("inspection.same.parameter.problem.descriptor", "<code>" + name + "</code>", "<code>" + value + "</code>"), this.createFix(name, value), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
    }

    private class LocalSameParameterValueInspection
    extends BaseJavaLocalInspectionTool {
        private static final String NOT_CONST = "_NOT_CONST";
        private final SameParameterValueInspectionBase myGlobal;

        private LocalSameParameterValueInspection(SameParameterValueInspectionBase global) {
            this.myGlobal = global;
        }

        @Override
        @NotNull
        public String getGroupDisplayName() {
            String string = this.myGlobal.getGroupDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$LocalSameParameterValueInspection", "getGroupDisplayName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.myGlobal.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$LocalSameParameterValueInspection", "getDisplayName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getShortName() {
            String string = this.myGlobal.getShortName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$LocalSameParameterValueInspection", "getShortName"));
            }
            return string;
        }

        @Override
        @NotNull
        public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$LocalSameParameterValueInspection", "buildVisitor"));
            }
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$LocalSameParameterValueInspection", "buildVisitor"));
            }
            JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){
                private final UnusedDeclarationInspectionBase myDeadCodeTool;
                {
                    InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(holder.getProject()).getCurrentProfile();
                    UnusedDeclarationInspectionBase deadCodeTool = (UnusedDeclarationInspectionBase)profile2.getUnwrappedTool("unused", (PsiElement)holder.getFile());
                    this.myDeadCodeTool = deadCodeTool == null ? new UnusedDeclarationInspectionBase() : deadCodeTool;
                }

                @Override
                public void visitMethod(PsiMethod method) {
                    String[] paramValues;
                    if (method.isConstructor()) {
                        return;
                    }
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length == 0) {
                        return;
                    }
                    if (this.myDeadCodeTool.isEntryPoint(method)) {
                        return;
                    }
                    if (!method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
                        return;
                    }
                    PsiParameter lastParameter = parameters[parameters.length - 1];
                    boolean hasVarArg = lastParameter.getType() instanceof PsiEllipsisType;
                    if (hasVarArg) {
                        if (parameters.length == 1) {
                            return;
                        }
                        paramValues = new String[parameters.length - 1];
                    } else {
                        paramValues = new String[parameters.length];
                    }
                    if (UnusedSymbolUtil.processUsages(holder.getProject(), method.getContainingFile(), method, new EmptyProgressIndicator(), null, info -> {
                        PsiElement element = info.getElement();
                        if (!(element instanceof PsiReferenceExpression)) {
                            return false;
                        }
                        PsiElement parent = element.getParent();
                        if (!(parent instanceof PsiMethodCallExpression)) {
                            return false;
                        }
                        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
                        PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
                        if (arguments.length < paramValues.length) {
                            return false;
                        }
                        boolean needFurtherProcess = false;
                        for (int i2 = 0; i2 < paramValues.length; ++i2) {
                            String value = paramValues[i2];
                            String currentArg = LocalSameParameterValueInspection.this.getArgValue(arguments[i2]);
                            if (value == null) {
                                paramValues[i2] = currentArg;
                                if (currentArg == LocalSameParameterValueInspection.NOT_CONST) continue;
                                needFurtherProcess = true;
                                continue;
                            }
                            if (value == LocalSameParameterValueInspection.NOT_CONST) continue;
                            if (!paramValues[i2].equals(currentArg)) {
                                paramValues[i2] = LocalSameParameterValueInspection.NOT_CONST;
                                continue;
                            }
                            needFurtherProcess = true;
                        }
                        return needFurtherProcess;
                    })) {
                        int length = paramValues.length;
                        for (int i2 = 0; i2 < length; ++i2) {
                            String value = paramValues[i2];
                            if (value == null || value == LocalSameParameterValueInspection.NOT_CONST) continue;
                            holder.registerProblem(SameParameterValueInspectionBase.this.registerProblem(holder.getManager(), parameters[i2], value));
                        }
                    }
                }
            };
            if (javaElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$LocalSameParameterValueInspection", "buildVisitor"));
            }
            return javaElementVisitor;
        }

        private String getArgValue(PsiExpression arg) {
            return arg instanceof PsiLiteralExpression ? arg.getText() : NOT_CONST;
        }
    }
}

