/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.RemoteCastable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import gnu.trove.THashMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.Remote;
import java.rmi.ServerError;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteUtil {
    private static final ConcurrentFactoryMap<Couple<Class<?>>, Map<Method, Method>> ourRemoteToLocalMap = new ConcurrentFactoryMap<Couple<Class<?>>, Map<Method, Method>>(){

        @Override
        protected Map<Method, Method> create(Couple<Class<?>> key) {
            THashMap map = new THashMap();
            for (Method method : ((Class)key.second).getMethods()) {
                Method m = null;
                block1: for (Method candidate : ((Class)key.first).getMethods()) {
                    Class<?>[] mpts;
                    Class<?>[] cpts;
                    if (!candidate.getName().equals(method.getName()) || (cpts = candidate.getParameterTypes()).length != (mpts = method.getParameterTypes()).length) continue;
                    for (int i2 = 0; i2 < mpts.length; ++i2) {
                        Class<?> mpt = mpts[i2];
                        Class cpt = RemoteUtil.castArgumentClassToLocal(cpts[i2]);
                        if (!cpt.isAssignableFrom(mpt)) continue block1;
                    }
                    m = candidate;
                    break;
                }
                if (m == null) continue;
                map.put((Object)method, m);
            }
            return map;
        }
    };

    RemoteUtil() {
    }

    @NotNull
    public static <T> T castToRemoteNotNull(Object object, Class<T> clazz) {
        T t = ObjectUtils.notNull(RemoteUtil.castToRemote(object, clazz));
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/RemoteUtil", "castToRemoteNotNull"));
        }
        return t;
    }

    @Nullable
    public static <T> T castToRemote(Object object, Class<T> clazz) {
        RemoteInvocationHandler rih;
        if (!Proxy.isProxyClass(object.getClass())) {
            return null;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(object);
        if (handler instanceof RemoteInvocationHandler && clazz.isInstance((rih = (RemoteInvocationHandler)handler).myRemote)) {
            return (T)rih.myRemote;
        }
        return null;
    }

    @NotNull
    public static <T> T castToLocal(Object remote, Class<T> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        Object object = Proxy.newProxyInstance(loader, new Class[]{clazz}, (InvocationHandler)new RemoteInvocationHandler(remote, clazz, loader));
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/RemoteUtil", "castToLocal"));
        }
        return (T)object;
    }

    private static Class<?> tryFixReturnType(Object result, Class<?> returnType, ClassLoader loader) throws Exception {
        if (returnType.isInterface()) {
            return returnType;
        }
        if (result instanceof RemoteCastable) {
            String className = ((RemoteCastable)result).getCastToClassName();
            return Class.forName(className, true, loader);
        }
        return returnType;
    }

    private static Class<?> castArgumentClassToLocal(@NotNull Class<?> remote) {
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "com/intellij/execution/rmi/RemoteUtil", "castArgumentClassToLocal"));
        }
        try {
            Type[] generics;
            if (!CastableArgument.class.isAssignableFrom(remote)) {
                return remote;
            }
            for (Type generic : generics = remote.getGenericInterfaces()) {
                Type rawType;
                if (!(generic instanceof ParameterizedType) || (rawType = ((ParameterizedType)generic).getRawType()) != CastableArgument.class) continue;
                return (Class)((ParameterizedType)generic).getActualTypeArguments()[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return remote;
    }

    @Nullable
    private static Object[] fixArgs(@Nullable Object[] args, @NotNull Method method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/execution/rmi/RemoteUtil", "fixArgs"));
        }
        if (args == null) {
            return null;
        }
        Object[] result = new Object[args.length];
        try {
            Class<?>[] methodArgs = method.getParameterTypes();
            if (methodArgs.length != args.length) {
                return args;
            }
            for (int i2 = 0; i2 < args.length; ++i2) {
                result[i2] = RemoteUtil.fixArg(args[i2], methodArgs[i2]);
            }
        }
        catch (Exception e) {
            return args;
        }
        return result;
    }

    @Nullable
    private static Object fixArg(@Nullable Object arg, @NotNull Class<?> fieldClass) {
        if (fieldClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldClass", "com/intellij/execution/rmi/RemoteUtil", "fixArg"));
        }
        if (arg == null) {
            return null;
        }
        if (!fieldClass.isPrimitive() && Proxy.isProxyClass(arg.getClass())) {
            boolean isCastableArg;
            InvocationHandler handler = Proxy.getInvocationHandler(arg);
            RemoteInvocationHandler remoteHandler = ObjectUtils.tryCast(handler, RemoteInvocationHandler.class);
            boolean bl = isCastableArg = remoteHandler != null && CastableArgument.class.isAssignableFrom(remoteHandler.myRemote.getClass());
            if (isCastableArg && remoteHandler.myClazz == fieldClass) {
                return remoteHandler.myRemote;
            }
        }
        return arg;
    }

    public static <T> T substituteClassLoader(final @NotNull T remote, final @Nullable ClassLoader classLoader) throws Exception {
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "com/intellij/execution/rmi/RemoteUtil", "substituteClassLoader"));
        }
        return RemoteUtil.executeWithClassLoader(new ThrowableComputable<T, Exception>(){

            @Override
            public T compute() {
                Object proxy = Proxy.newProxyInstance(classLoader, remote.getClass().getInterfaces(), new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                        return RemoteUtil.executeWithClassLoader(new ThrowableComputable<Object, Exception>(){

                            @Override
                            public Object compute() throws Exception {
                                return RemoteUtil.invokeRemote(method, method, remote, args, classLoader, true);
                            }
                        }, classLoader);
                    }
                });
                return proxy;
            }
        }, classLoader);
    }

    private static Object invokeRemote(@NotNull Method localMethod, @NotNull Method remoteMethod, @NotNull Object remoteObj, @Nullable Object[] args, @Nullable ClassLoader loader, boolean substituteClassLoader) throws Exception {
        if (localMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localMethod", "com/intellij/execution/rmi/RemoteUtil", "invokeRemote"));
        }
        if (remoteMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteMethod", "com/intellij/execution/rmi/RemoteUtil", "invokeRemote"));
        }
        if (remoteObj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteObj", "com/intellij/execution/rmi/RemoteUtil", "invokeRemote"));
        }
        boolean canThrowError = false;
        try {
            Object result = remoteMethod.invoke(remoteObj, args);
            canThrowError = true;
            return RemoteUtil.handleRemoteResult(result, localMethod.getReturnType(), loader, substituteClassLoader);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServerError) {
                cause = ObjectUtils.chooseNotNull(cause.getCause(), cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (canThrowError && cause instanceof Error || cause instanceof LinkageError) {
                throw (Error)cause;
            }
            if (cause instanceof Exception && RemoteUtil.canThrow(cause, localMethod)) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <T> T handleRemoteResult(Object value, Class<? super T> clazz, Object requestor) throws Exception {
        return RemoteUtil.handleRemoteResult(value, clazz, requestor.getClass().getClassLoader(), false);
    }

    private static <T> T handleRemoteResult(Object value, Class<?> methodReturnType, ClassLoader classLoader, boolean substituteClassLoader) throws Exception {
        Object result;
        if (value instanceof Remote) {
            result = value instanceof RemoteCastable ? RemoteUtil.castToLocal(value, RemoteUtil.tryFixReturnType(value, methodReturnType, classLoader)) : (substituteClassLoader ? RemoteUtil.substituteClassLoader(value, classLoader) : value);
        } else if (value instanceof List && methodReturnType.isInterface()) {
            result = Arrays.asList((Object[])RemoteUtil.handleRemoteResult(((List)value).toArray(), Object.class, classLoader, substituteClassLoader));
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = RemoteUtil.handleRemoteResult(array[i2], Object.class, classLoader, substituteClassLoader);
            }
            result = array;
        } else {
            result = value;
        }
        return (T)result;
    }

    private static boolean canThrow(@NotNull Throwable cause, @NotNull Method method) {
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/intellij/execution/rmi/RemoteUtil", "canThrow"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/execution/rmi/RemoteUtil", "canThrow"));
        }
        for (Class<?> each : method.getExceptionTypes()) {
            if (!each.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithClassLoader(ThrowableComputable<T, Exception> action, ClassLoader classLoader) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader prev = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(classLoader);
            T t = action.compute();
            return t;
        }
        finally {
            thread.setContextClassLoader(prev);
        }
    }

    @NotNull
    public static Throwable unwrap(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/rmi/RemoteUtil", "unwrap"));
        }
        for (Throwable candidate = e; candidate != null; candidate = candidate.getCause()) {
            Class<?> clazz = candidate.getClass();
            if (clazz == InvocationTargetException.class || clazz == UndeclaredThrowableException.class) continue;
            Throwable throwable = candidate;
            if (throwable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/RemoteUtil", "unwrap"));
            }
            return throwable;
        }
        Throwable throwable = e;
        if (throwable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/RemoteUtil", "unwrap"));
        }
        return throwable;
    }

    public static interface CastableArgument<T> {
    }

    private static class RemoteInvocationHandler
    implements InvocationHandler {
        private final Object myRemote;
        private final Class<?> myClazz;
        private final ClassLoader myLoader;

        public RemoteInvocationHandler(Object remote, Class<?> clazz, ClassLoader loader) {
            this.myRemote = remote;
            this.myClazz = clazz;
            this.myLoader = loader;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if ("equals".equals(method.getName())) {
                    return proxy == args[0];
                }
                if ("hashCode".equals(method.getName())) {
                    return this.hashCode();
                }
                return method.invoke(this.myRemote, args);
            }
            Method remoteMethod = (Method)((Map)ourRemoteToLocalMap.get(Couple.of(this.myRemote.getClass(), this.myClazz))).get(method);
            if (remoteMethod == null) {
                throw new NoSuchMethodError(method.getName() + " in " + this.myRemote.getClass());
            }
            return RemoteUtil.invokeRemote(method, remoteMethod, this.myRemote, RemoteUtil.fixArgs(args, method), this.myLoader, false);
        }
    }
}

