/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class CommentTracker {
    private Set<PsiElement> ignoredParents = new HashSet<PsiElement>();
    private List<PsiComment> comments = new ArrayList<PsiComment>();

    @NotNull
    public String text(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/CommentTracker", "text"));
        }
        this.checkState();
        this.addIgnored(element);
        String string = element.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/CommentTracker", "text"));
        }
        return string;
    }

    @NotNull
    public <T extends PsiElement> T markUnchanged(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/CommentTracker", "markUnchanged"));
        }
        this.checkState();
        this.addIgnored(element);
        T t = element;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/CommentTracker", "markUnchanged"));
        }
        return t;
    }

    public void delete(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/CommentTracker", "delete"));
        }
        this.grabComments(element);
        element.delete();
    }

    public void delete(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/siyeh/ig/psiutils/CommentTracker", "delete"));
        }
        for (PsiElement element : elements) {
            this.delete(element);
        }
    }

    public void deleteAndRestoreComments(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/CommentTracker", "deleteAndRestoreComments"));
        }
        this.grabComments(element);
        this.insertCommentsBefore(element instanceof PsiVariable ? element.getParent() : element);
        element.delete();
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/CommentTracker", "replace"));
        }
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/siyeh/ig/psiutils/CommentTracker", "replace"));
        }
        this.grabComments(element);
        PsiElement psiElement = element.replace(replacement);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/CommentTracker", "replace"));
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/CommentTracker", "replace"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/siyeh/ig/psiutils/CommentTracker", "replace"));
        }
        PsiElement replacement = CommentTracker.createElement(element, text);
        PsiElement psiElement = this.replace(element, replacement);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/CommentTracker", "replace"));
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/CommentTracker", "replaceAndRestoreComments"));
        }
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/siyeh/ig/psiutils/CommentTracker", "replaceAndRestoreComments"));
        }
        PsiElement result = this.replace(element, replacement);
        Object anchor = PsiTreeUtil.getNonStrictParentOfType(result, PsiStatement.class, PsiLambdaExpression.class, PsiVariable.class);
        if (anchor instanceof PsiLambdaExpression && anchor != result) {
            anchor = ((PsiLambdaExpression)anchor).getBody();
        }
        if (anchor instanceof PsiVariable && anchor.getParent() instanceof PsiDeclarationStatement) {
            anchor = anchor.getParent();
        }
        if (anchor == null) {
            anchor = result;
        }
        this.insertCommentsBefore((PsiElement)anchor);
        PsiElement psiElement = result;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/CommentTracker", "replaceAndRestoreComments"));
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/CommentTracker", "replaceAndRestoreComments"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/siyeh/ig/psiutils/CommentTracker", "replaceAndRestoreComments"));
        }
        PsiElement replacement = CommentTracker.createElement(element, text);
        PsiElement psiElement = this.replaceAndRestoreComments(element, replacement);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/CommentTracker", "replaceAndRestoreComments"));
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement createElement(@NotNull PsiElement element, @NotNull String text) {
        PsiElement replacement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/CommentTracker", "createElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/siyeh/ig/psiutils/CommentTracker", "createElement"));
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(element.getProject());
        if (element instanceof PsiExpression) {
            replacement = factory.createExpressionFromText(text, element);
        } else if (element instanceof PsiStatement) {
            replacement = factory.createStatementFromText(text, element);
        } else if (element instanceof PsiTypeElement) {
            replacement = factory.createTypeElementFromText(text, element);
        } else if (element instanceof PsiIdentifier) {
            replacement = factory.createIdentifier(text);
        } else if (element instanceof PsiComment) {
            replacement = factory.createCommentFromText(text, element);
        } else {
            throw new IllegalArgumentException("Unsupported element type: " + element);
        }
        PsiExpression psiExpression = replacement;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/CommentTracker", "createElement"));
        }
        return psiExpression;
    }

    public void insertCommentsBefore(@NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/siyeh/ig/psiutils/CommentTracker", "insertCommentsBefore"));
        }
        this.checkState();
        if (!this.comments.isEmpty()) {
            PsiElement parent = anchor.getParent();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(anchor.getProject());
            for (PsiComment comment : this.comments) {
                PsiElement added;
                PsiElement prevSibling;
                if (this.shouldIgnore(comment) || !((prevSibling = (added = parent.addBefore(factory.createCommentFromText(comment.getText(), anchor), anchor)).getPrevSibling()) instanceof PsiWhiteSpace)) continue;
                ASTNode whiteSpaceBefore = CommentTracker.normalizeWhiteSpace((PsiWhiteSpace)prevSibling);
                PsiElement prev = anchor.getPrevSibling();
                parent.getNode().addChild(whiteSpaceBefore, anchor.getNode());
                if (!(prev instanceof PsiWhiteSpace)) continue;
                prev.delete();
            }
        }
        this.comments = null;
    }

    @NotNull
    private static ASTNode normalizeWhiteSpace(PsiWhiteSpace whiteSpace) {
        int endLPos;
        String text = whiteSpace.getText();
        if (text.lastIndexOf(10, (endLPos = text.lastIndexOf(10)) - 1) >= 0) {
            LeafElement leafElement = ASTFactory.whitespace(text.substring(endLPos));
            if (leafElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/CommentTracker", "normalizeWhiteSpace"));
            }
            return leafElement;
        }
        LeafElement leafElement = ASTFactory.whitespace(text);
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/CommentTracker", "normalizeWhiteSpace"));
        }
        return leafElement;
    }

    private boolean shouldIgnore(PsiComment comment) {
        return this.ignoredParents.stream().anyMatch(p -> PsiTreeUtil.isAncestor(p, comment, false));
    }

    private void grabComments(PsiElement element) {
        this.checkState();
        for (PsiComment comment : PsiTreeUtil.collectElementsOfType(element, PsiComment.class)) {
            if (this.shouldIgnore(comment)) continue;
            this.comments.add(comment);
        }
    }

    private void checkState() {
        if (this.comments == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been already used");
        }
    }

    private void addIgnored(PsiElement element) {
        if (element instanceof LeafPsiElement && !(element instanceof PsiComment)) {
            return;
        }
        this.ignoredParents.add(element);
    }

    public static String textWithSurroundingComments(PsiElement element) {
        Predicate<PsiElement> commentOrWhiteSpace = e -> e instanceof PsiComment || e instanceof PsiWhiteSpace;
        List prev = StreamEx.iterate((Object)element.getPrevSibling(), commentOrWhiteSpace, PsiElement::getPrevSibling).toList();
        List next = StreamEx.iterate((Object)element.getNextSibling(), commentOrWhiteSpace, PsiElement::getNextSibling).toList();
        if (StreamEx.of((Object[])new List[]{prev, next}).flatCollection(Function.identity()).anyMatch(PsiComment.class::isInstance)) {
            return StreamEx.ofReversed((List)prev).append((Object)element).append((Collection)next).map(PsiElement::getText).joining();
        }
        return element.getText();
    }
}

