/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DependencyValidationManager", storages={@Storage(value="scopes", stateSplitter=ScopesStateSplitter.class)})
public class DependencyValidationManagerImpl
extends DependencyValidationManager {
    private static final NotNullLazyValue<Icon> ourSharedScopeIcon = new NotNullLazyValue<Icon>(){

        @Override
        @NotNull
        protected Icon compute() {
            LayeredIcon layeredIcon = new LayeredIcon(AllIcons.Ide.LocalScope, AllIcons.Nodes.Shared);
            if (layeredIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$1", "compute"));
            }
            return layeredIcon;
        }
    };
    private State myState = new State();
    private final NamedScopeManager myNamedScopeManager;
    private boolean mySkipImportStatements;
    private boolean mySkipImportStatementsWasSpecified;
    @NonNls
    private static final String DENY_RULE_KEY = "deny_rule";
    @NonNls
    private static final String FROM_SCOPE_KEY = "from_scope";
    @NonNls
    private static final String TO_SCOPE_KEY = "to_scope";
    @NonNls
    private static final String IS_DENY_KEY = "is_deny";
    @NonNls
    private static final String UNNAMED_SCOPE = "unnamed_scope";
    @NonNls
    private static final String VALUE = "value";
    private final List<Pair<NamedScope, NamedScopesHolder>> myScopePairs = ContainerUtil.createLockFreeCopyOnWriteList();

    public DependencyValidationManagerImpl(Project project, NamedScopeManager namedScopeManager) {
        super(project);
        this.myNamedScopeManager = namedScopeManager;
        namedScopeManager.addScopeListener(new NamedScopesHolder.ScopeListener(){

            @Override
            public void scopesChanged() {
                DependencyValidationManagerImpl.this.reloadScopes();
            }
        });
    }

    @Override
    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        CustomScopesProvider[] scopesProviders;
        ArrayList<NamedScope> predefinedScopes = new ArrayList<NamedScope>();
        for (CustomScopesProvider scopesProvider : scopesProviders = CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions(this.myProject)) {
            predefinedScopes.addAll(scopesProvider.getFilteredScopes());
        }
        ArrayList<NamedScope> arrayList = predefinedScopes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getPredefinedScopes"));
        }
        return arrayList;
    }

    @Override
    public NamedScope getPredefinedScope(@NotNull String name) {
        CustomScopesProvider[] scopesProviders;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getPredefinedScope"));
        }
        for (CustomScopesProvider scopesProvider : scopesProviders = CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions(this.myProject)) {
            NamedScope scope;
            NamedScope namedScope = scope = scopesProvider instanceof CustomScopesProviderEx ? ((CustomScopesProviderEx)scopesProvider).getCustomScope(name) : CustomScopesProviderEx.findPredefinedScope(name, scopesProvider.getFilteredScopes());
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    @Override
    public boolean hasRules() {
        return !this.myState.rules.isEmpty();
    }

    @Override
    @Nullable
    public DependencyRule getViolatorDependencyRule(@NotNull PsiFile from, @NotNull PsiFile to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRule"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRule"));
        }
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            return dependencyRule;
        }
        return null;
    }

    @Override
    @NotNull
    public DependencyRule[] getViolatorDependencyRules(@NotNull PsiFile from, @NotNull PsiFile to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRules"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRules"));
        }
        ArrayList<DependencyRule> result = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            result.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result.toArray(new DependencyRule[result.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRules"));
        }
        return dependencyRuleArray;
    }

    @Override
    @NotNull
    public DependencyRule[] getApplicableRules(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getApplicableRules"));
        }
        ArrayList<DependencyRule> result = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isApplicable(file)) continue;
            result.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result.toArray(new DependencyRule[result.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getApplicableRules"));
        }
        return dependencyRuleArray;
    }

    @Override
    public boolean skipImportStatements() {
        return this.mySkipImportStatements;
    }

    @Override
    public void setSkipImportStatements(boolean skip) {
        this.mySkipImportStatements = skip;
    }

    @Override
    @NotNull
    public Map<String, PackageSet> getUnnamedScopes() {
        Map map = this.myState.unnamedScopes;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getUnnamedScopes"));
        }
        return map;
    }

    @Override
    @NotNull
    public DependencyRule[] getAllRules() {
        List rules = this.myState.rules;
        DependencyRule[] dependencyRuleArray = rules.toArray(new DependencyRule[rules.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getAllRules"));
        }
        return dependencyRuleArray;
    }

    @Override
    public void removeAllRules() {
        this.myState.rules.clear();
    }

    private void addRule(@NotNull DependencyRule rule, @NotNull State state) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addRule"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addRule"));
        }
        this.appendUnnamedScope(rule.getFromScope(), state);
        this.appendUnnamedScope(rule.getToScope(), state);
        state.rules.add(rule);
    }

    @Override
    public void addRule(@NotNull DependencyRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addRule"));
        }
        this.addRule(rule, this.myState);
    }

    private void appendUnnamedScope(@NotNull NamedScope fromScope, @NotNull State state) {
        PackageSet packageSet;
        if (fromScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromScope", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "appendUnnamedScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "appendUnnamedScope"));
        }
        if (this.getScope(fromScope.getName()) == null && (packageSet = fromScope.getValue()) != null && !state.unnamedScopes.containsKey(packageSet.getText())) {
            state.unnamedScopes.put(packageSet.getText(), packageSet);
        }
    }

    @Override
    public String getDisplayName() {
        return IdeBundle.message("shared.scopes.node.text", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return ourSharedScopeIcon.getValue();
    }

    @Override
    public void loadState(Element element) {
        Element option = element.getChild("option");
        if (option != null && "SKIP_IMPORT_STATEMENTS".equals(option.getAttributeValue("name"))) {
            this.mySkipImportStatementsWasSpecified = !this.myProject.isDefault();
            this.mySkipImportStatements = Boolean.parseBoolean(option.getAttributeValue(VALUE));
        }
        super.loadState(element);
        NamedScope[] scopes = this.getEditableScopes();
        Arrays.sort(scopes, (s1, s2) -> {
            int i2;
            String name2;
            String name1 = s1.getName();
            if (Comparing.equal(name1, name2 = s2.getName())) {
                return 0;
            }
            List<String> order = this.myNamedScopeManager.myOrderState.myOrder;
            int i1 = order.indexOf(name1);
            return i1 > (i2 = order.indexOf(name2)) ? 1 : -1;
        });
        super.setScopes(scopes);
        State state = new State();
        PackageSetFactory packageSetFactory = PackageSetFactory.getInstance();
        for (Element unnamedScope : element.getChildren(UNNAMED_SCOPE)) {
            try {
                String packageSet = unnamedScope.getAttributeValue(VALUE);
                state.unnamedScopes.put(packageSet, packageSetFactory.compile(packageSet));
            }
            catch (ParsingException parsingException) {}
        }
        this.readRules(element, state);
        this.myState = state;
    }

    private void readRules(@NotNull Element element, State state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "readRules"));
        }
        for (Element rule1 : element.getChildren(DENY_RULE_KEY)) {
            DependencyRule rule = this.readRule(rule1);
            if (rule == null) continue;
            this.addRule(rule, state);
        }
    }

    @Override
    public Element getState() {
        State state;
        Element element = super.getState();
        assert (element != null);
        if (this.mySkipImportStatements || this.mySkipImportStatementsWasSpecified) {
            element.addContent(new Element("option").setAttribute("name", "SKIP_IMPORT_STATEMENTS").setAttribute(VALUE, Boolean.toString(this.mySkipImportStatements)));
        }
        if (!(state = this.myState).unnamedScopes.isEmpty()) {
            Object[] unnamedScopes = state.unnamedScopes.keySet().toArray(new String[state.unnamedScopes.size()]);
            Arrays.sort(unnamedScopes);
            for (Object unnamedScope : unnamedScopes) {
                element.addContent(new Element(UNNAMED_SCOPE).setAttribute(VALUE, (String)unnamedScope));
            }
        }
        DependencyValidationManagerImpl.writeRules(element, state);
        return element;
    }

    private static void writeRules(@NotNull Element element, @NotNull State state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "writeRules"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "writeRules"));
        }
        for (DependencyRule rule : state.rules) {
            Element ruleElement = DependencyValidationManagerImpl.writeRule(rule);
            if (ruleElement == null) continue;
            element.addContent(ruleElement);
        }
    }

    @Override
    @Nullable
    public NamedScope getScope(@Nullable String name) {
        return this.getScope(name, this.myState);
    }

    private NamedScope getScope(@Nullable String name, @NotNull State state) {
        PackageSet packageSet;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getScope"));
        }
        NamedScope scope = super.getScope(name);
        if (scope == null && (packageSet = (PackageSet)state.unnamedScopes.get(name)) != null) {
            return new NamedScope.UnnamedScope(packageSet);
        }
        if (scope == null && Comparing.strEqual(name, "Project")) {
            return super.getScope("All");
        }
        return scope;
    }

    @Nullable
    private static Element writeRule(DependencyRule rule) {
        NamedScope fromScope = rule.getFromScope();
        NamedScope toScope = rule.getToScope();
        if (fromScope == null || toScope == null) {
            return null;
        }
        Element ruleElement = new Element(DENY_RULE_KEY);
        ruleElement.setAttribute(FROM_SCOPE_KEY, fromScope.getName());
        ruleElement.setAttribute(TO_SCOPE_KEY, toScope.getName());
        ruleElement.setAttribute(IS_DENY_KEY, Boolean.valueOf(rule.isDenyRule()).toString());
        return ruleElement;
    }

    @Nullable
    private DependencyRule readRule(@NotNull Element ruleElement) {
        if (ruleElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleElement", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "readRule"));
        }
        String fromScope = ruleElement.getAttributeValue(FROM_SCOPE_KEY);
        String toScope = ruleElement.getAttributeValue(TO_SCOPE_KEY);
        String denyRule = ruleElement.getAttributeValue(IS_DENY_KEY);
        if (fromScope == null || toScope == null || denyRule == null) {
            return null;
        }
        NamedScope fromNamedScope = this.getScope(fromScope);
        NamedScope toNamedScope = this.getScope(toScope);
        if (fromNamedScope == null || toNamedScope == null) {
            return null;
        }
        return new DependencyRule(fromNamedScope, toNamedScope, Boolean.valueOf(denyRule));
    }

    private void reloadScopes() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            ArrayList<Pair<NamedScope, NamedScopesHolder>> scopeList = new ArrayList<Pair<NamedScope, NamedScopesHolder>>();
            DependencyValidationManagerImpl.addScopesToList(scopeList, this);
            DependencyValidationManagerImpl.addScopesToList(scopeList, this.myNamedScopeManager);
            this.myScopePairs.clear();
            this.myScopePairs.addAll(scopeList);
            Element element = new Element("rules_2_reload");
            DependencyValidationManagerImpl.writeRules(element, this.myState);
            State state = new State();
            this.readRules(element, state);
            this.myState = state;
        });
    }

    private static void addScopesToList(@NotNull List<Pair<NamedScope, NamedScopesHolder>> scopeList, @NotNull NamedScopesHolder holder) {
        if (scopeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeList", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addScopesToList"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addScopesToList"));
        }
        for (NamedScope scope : holder.getScopes()) {
            scopeList.add(Pair.create(scope, holder));
        }
    }

    @NotNull
    public List<Pair<NamedScope, NamedScopesHolder>> getScopeBasedHighlightingCachedScopes() {
        List<Pair<NamedScope, NamedScopesHolder>> list = this.myScopePairs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getScopeBasedHighlightingCachedScopes"));
        }
        return list;
    }

    @Override
    public void fireScopeListeners() {
        super.fireScopeListeners();
        this.reloadScopes();
    }

    @Override
    public void setScopes(NamedScope[] scopes) {
        super.setScopes(scopes);
        List<String> order = this.myNamedScopeManager.myOrderState.myOrder;
        order.clear();
        for (NamedScope scope : scopes) {
            order.add(scope.getName());
        }
    }

    static final class ScopesStateSplitter
    extends MainConfigurationStateSplitter {
        ScopesStateSplitter() {
        }

        @Override
        @NotNull
        protected String getSubStateFileName(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter", "getSubStateFileName"));
            }
            String string = element.getAttributeValue("name");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter", "getSubStateFileName"));
            }
            return string;
        }

        @Override
        @NotNull
        protected String getComponentStateFileName() {
            if ("scope_settings" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter", "getComponentStateFileName"));
            }
            return "scope_settings";
        }

        @Override
        @NotNull
        protected String getSubStateTagName() {
            if ("scope" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter", "getSubStateTagName"));
            }
            return "scope";
        }
    }

    private static class State {
        private final List<DependencyRule> rules = new ArrayList<DependencyRule>();
        private final Map<String, PackageSet> unnamedScopes = new THashMap();

        private State() {
        }
    }
}

