/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorColorPalette {
    private EditorColorsScheme myColorsScheme;
    private final Set<Color> myColors = new HashSet<Color>();
    public static final Comparator<Color> ORDER_NONE = Comparator.comparingInt(EditorColorPalette::getDefaultOrder);
    public static final Comparator<Color> ORDER_BY_INTENSITY = Comparator.comparingInt(EditorColorPalette::getIntensity);

    public EditorColorPalette(EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    public EditorColorPalette withBackgroundColors() {
        return this.collectColors(attr -> attr.getBackgroundColor());
    }

    public EditorColorPalette withForegroundColors() {
        return this.collectColors(attr -> attr.getForegroundColor());
    }

    private Collection<Color> orderBy(@Nullable Comparator<Color> comparator) {
        ArrayList<Color> sorted = new ArrayList<Color>();
        sorted.addAll(this.myColors);
        Collections.sort(sorted, comparator);
        return sorted;
    }

    private static int getIntensity(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/colors/EditorColorPalette", "getIntensity"));
        }
        return (color.getRed() + color.getGreen() + color.getBlue()) / 3;
    }

    private static int getDefaultOrder(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/colors/EditorColorPalette", "getDefaultOrder"));
        }
        return 0;
    }

    public Collection<Color> getColors(@NotNull Comparator<Color> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/openapi/editor/colors/EditorColorPalette", "getColors"));
        }
        return comparator == ORDER_NONE ? this.myColors : this.orderBy(comparator);
    }

    private EditorColorPalette collectColors(@NotNull Function<TextAttributes, Color> attrColorReader) {
        if (attrColorReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrColorReader", "com/intellij/openapi/editor/colors/EditorColorPalette", "collectColors"));
        }
        HashSet<Color> colors = new HashSet<Color>();
        for (TextAttributesKey key : this.getTextAttributeKeys()) {
            Color usedColor;
            TextAttributes attributes = this.myColorsScheme.getAttributes(key);
            if (attributes == null || (usedColor = attrColorReader.fun(attributes)) == null) continue;
            colors.add(usedColor);
        }
        this.myColors.addAll(colors);
        return this;
    }

    @Nullable
    public Color getClosestNonConflictingColor(@NotNull Color sampleColor) {
        if (sampleColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleColor", "com/intellij/openapi/editor/colors/EditorColorPalette", "getClosestNonConflictingColor"));
        }
        boolean searchBrighter = ColorUtil.isDark(sampleColor);
        Color foundColor = this.getClosestNonConflictingColor(sampleColor, EditorColorPalette.getAdjuster(searchBrighter));
        if (foundColor == null) {
            foundColor = this.getClosestNonConflictingColor(sampleColor, EditorColorPalette.getAdjuster(!searchBrighter));
        }
        return foundColor;
    }

    private static Function<Color, Color> getAdjuster(boolean searchBrighter) {
        return searchBrighter ? Color::brighter : Color::darker;
    }

    @Nullable
    public Color getClosestNonConflictingColor(@NotNull Color sampleColor, @NotNull Function<Color, Color> colorAdjuster) {
        if (sampleColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleColor", "com/intellij/openapi/editor/colors/EditorColorPalette", "getClosestNonConflictingColor"));
        }
        if (colorAdjuster == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorAdjuster", "com/intellij/openapi/editor/colors/EditorColorPalette", "getClosestNonConflictingColor"));
        }
        if (this.myColors.contains(sampleColor)) {
            Color newColor = colorAdjuster.fun(sampleColor);
            return !sampleColor.equals(newColor) ? this.getClosestNonConflictingColor(newColor, colorAdjuster) : null;
        }
        return sampleColor;
    }

    protected abstract Collection<TextAttributesKey> getTextAttributeKeys();
}

