/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class HierarchicalMethodSignature
extends MethodSignatureBackedByPsiMethod {
    public HierarchicalMethodSignature(@NotNull MethodSignatureBackedByPsiMethod signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/HierarchicalMethodSignature", "<init>"));
        }
        super(signature.getMethod(), signature.getSubstitutor(), signature.isRaw(), HierarchicalMethodSignature.getParameterTypes(signature.getMethod()), signature.getTypeParameters());
    }

    private static PsiType[] getParameterTypes(PsiMethod method) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType[] paramTypes = PsiType.createArray(parameters.length);
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            paramTypes[i2] = parameters[i2].getType();
        }
        return paramTypes;
    }

    @NotNull
    public abstract List<HierarchicalMethodSignature> getSuperSignatures();

    @NotNull
    public List<HierarchicalMethodSignature> getInaccessibleSuperSignatures() {
        List<HierarchicalMethodSignature> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/HierarchicalMethodSignature", "getInaccessibleSuperSignatures"));
        }
        return list;
    }
}

