/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlipIntersectionSidesFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance("#" + FlipIntersectionSidesFix.class.getName());
    private final String myClassName;
    private final List<PsiTypeElement> myConjuncts;
    private final PsiTypeElement myConjunct;
    private final PsiTypeElement myCastTypeElement;

    public FlipIntersectionSidesFix(String className, @NotNull List<PsiTypeElement> conjList, PsiTypeElement conjunct, PsiTypeElement castTypeElement) {
        if (conjList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conjList", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "<init>"));
        }
        this.myClassName = className;
        this.myConjuncts = conjList;
        LOG.assertTrue(!conjList.isEmpty());
        this.myConjunct = conjunct;
        this.myCastTypeElement = castTypeElement;
    }

    @Override
    @NotNull
    public String getText() {
        String string = "Move '" + this.myClassName + "' to the beginning";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Move to front" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "getFamilyName"));
        }
        return "Move to front";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "isAvailable"));
        }
        for (PsiTypeElement typeElement : this.myConjuncts) {
            if (typeElement.isValid()) continue;
            return false;
        }
        return !Comparing.strEqual(this.myConjunct.getText(), this.myConjuncts.get(0).getText());
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "invoke"));
        }
        this.myConjuncts.remove(this.myConjunct);
        this.myConjuncts.add(0, this.myConjunct);
        String intersectionTypeText = StringUtil.join(this.myConjuncts, element -> element.getText(), " & ");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        PsiTypeCastExpression fixedCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + intersectionTypeText + ") a", this.myCastTypeElement);
        PsiTypeElement fixedCastCastType = fixedCast.getCastType();
        LOG.assertTrue(fixedCastCastType != null);
        PsiElement flippedTypeElement = this.myCastTypeElement.replace(fixedCastCastType);
        CodeStyleManager.getInstance(project).reformat(flippedTypeElement);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

