/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddThisQualifierFix;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedFieldAccessInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unqualified.field.access.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnqualifiedFieldAccessInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedFieldAccessVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unqualified.field.access.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnqualifiedFieldAccessInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddThisQualifierFix();
    }

    private static class UnqualifiedFieldAccessVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedFieldAccessVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiClass expressionClass;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/UnqualifiedFieldAccessInspection$UnqualifiedFieldAccessVisitor", "visitReferenceExpression"));
            }
            super.visitReferenceExpression(expression);
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            if (qualifierExpression != null) {
                return;
            }
            PsiReferenceParameterList parameterList = expression.getParameterList();
            if (parameterList == null) {
                return;
            }
            PsiElement element = expression.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("static")) {
                return;
            }
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            if (PsiUtil.isLocalOrAnonymousClass(fieldClass) && (expressionClass = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) != null && !expressionClass.equals(fieldClass)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }
}

