/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiredModuleFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ModuleHighlightUtil {
    @Nullable
    static PsiJavaModule getModuleDescriptor(@NotNull PsiFileSystemItem fsItem) {
        if (fsItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fsItem", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "getModuleDescriptor"));
        }
        VirtualFile file = fsItem.getVirtualFile();
        if (file == null) {
            return null;
        }
        Project project = fsItem.getProject();
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance(project);
        if (index.isInLibraryClasses(file)) {
            VirtualFile classRoot = index.getClassRootForFile(file);
            if (classRoot != null) {
                VirtualFile descriptorFile = classRoot.findChild("module-info.class");
                if (descriptorFile == null) {
                    descriptorFile = classRoot.findFileByRelativePath("META-INF/versions/9/module-info.class");
                }
                if (descriptorFile != null) {
                    PsiFile psiFile = PsiManager.getInstance(project).findFile(descriptorFile);
                    if (psiFile instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile).getModuleDeclaration();
                    }
                } else if (classRoot.getFileSystem() instanceof JarFileSystem && "jar".equalsIgnoreCase(classRoot.getExtension())) {
                    return LightJavaModule.getModule(PsiManager.getInstance(project), classRoot);
                }
            }
            return null;
        }
        return ModuleHighlightUtil.getModuleDescriptor(index.getModuleForFile(file));
    }

    static PsiJavaModule getModuleDescriptor(Module module) {
        return Optional.ofNullable(module).map(m -> FilenameIndex.getVirtualFilesByName(module.getProject(), "module-info.java", m.getModuleScope(false))).map(c -> c.size() == 1 ? (VirtualFile)c.iterator().next() : null).map(f -> PsiManager.getInstance(module.getProject()).findFile((VirtualFile)f)).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).orElse(null);
    }

    static HighlightInfo checkPackageStatement(@NotNull PsiPackageStatement statement, @NotNull PsiFile file, @Nullable PsiJavaModule module) {
        PsiJavaModule origin;
        String packageName;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageStatement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageStatement"));
        }
        if (PsiUtil.isModuleFile(file)) {
            String message = JavaErrorMessages.message("module.no.package", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).description(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createDeleteFix(statement));
            return info;
        }
        if (module != null && (packageName = statement.getPackageName()) != null && (origin = JavaModuleGraphUtil.findOrigin(module, packageName)) != null) {
            String message = JavaErrorMessages.message("module.conflicting.packages", packageName, origin.getName());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileName(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileName"));
        }
        if (!"module-info.java".equals(file.getName())) {
            String message = JavaErrorMessages.message("module.file.wrong.name", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).description(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createRenameFileFix("module-info.java"));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileDuplicates(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        Project project;
        Collection<VirtualFile> others;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileDuplicates"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileDuplicates"));
        }
        Module module = ModuleHighlightUtil.findModule(file);
        if (module != null && (others = FilenameIndex.getVirtualFilesByName(project = file.getProject(), "module-info.java", module.getModuleScope(false))).size() > 1) {
            String message = JavaErrorMessages.message("module.file.duplicate", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).description(message).create();
            others.stream().map(f -> PsiManager.getInstance(project).findFile((VirtualFile)f)).filter(f -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "lambda$checkFileDuplicates$5"));
                }
                return f != file;
            }).findFirst().ifPresent(duplicate -> QuickFixAction.registerQuickFixAction(info, new GoToSymbolFix((NavigatablePsiElement)duplicate, JavaErrorMessages.message("module.open.duplicate.text", new Object[0]))));
            return info;
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkDuplicateStatements(@NotNull PsiJavaModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkDuplicateStatements"));
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        ModuleHighlightUtil.checkDuplicateRefs(module.getRequires(), st -> Optional.ofNullable(st.getReferenceElement()).map(PsiJavaModuleReferenceElement::getReferenceText), "module.duplicate.requires", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getExports(), st -> Optional.ofNullable(st.getPackageReference()).map(ModuleHighlightUtil::refText), "module.duplicate.export", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getUses(), st -> Optional.ofNullable(st.getClassReference()).map(ModuleHighlightUtil::refText), "module.duplicate.uses", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getProvides(), st -> Optional.ofNullable(st.getInterfaceReference()).map(ModuleHighlightUtil::refText), "module.duplicate.provides", results);
        List<HighlightInfo> list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkDuplicateStatements"));
        }
        return list;
    }

    private static <T extends PsiElement> void checkDuplicateRefs(Iterable<T> statements, Function<T, Optional<String>> ref, @PropertyKey(resourceBundle="messages.JavaErrorMessages") String key, List<HighlightInfo> results) {
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiElement statement : statements) {
            String refText = ref.apply(statement).orElse(null);
            if (refText == null || filter.add((String)refText)) continue;
            String message = JavaErrorMessages.message(key, refText);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).description(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createDeleteFix(statement));
            results.add(info);
        }
    }

    @NotNull
    static List<HighlightInfo> checkUnusedServices(@NotNull PsiJavaModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkUnusedServices"));
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        Set<String> exports = JBIterable.from(module.getExports()).map(st -> ModuleHighlightUtil.refText(st.getPackageReference())).filter(Objects::nonNull).toSet();
        Set<String> uses = JBIterable.from(module.getUses()).map(st -> ModuleHighlightUtil.refText(st.getClassReference())).filter(Objects::nonNull).toSet();
        Module host = ModuleHighlightUtil.findModule(module);
        for (PsiProvidesStatement statement : module.getProvides()) {
            String className;
            String packageName;
            PsiElement target;
            PsiJavaCodeReferenceElement ref = statement.getInterfaceReference();
            if (ref == null || !((target = ref.resolve()) instanceof PsiClass) || ModuleHighlightUtil.findModule(target) != host || exports.contains(packageName = StringUtil.getPackageName(className = ModuleHighlightUtil.refText(ref))) || uses.contains(className)) continue;
            String message = JavaErrorMessages.message("module.service.unused", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(ref)).description(message).create());
        }
        List<HighlightInfo> list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkUnusedServices"));
        }
        return list;
    }

    private static String refText(PsiJavaCodeReferenceElement ref) {
        return ref != null ? PsiNameHelper.getQualifiedClassName(ref.getText(), true) : null;
    }

    @Nullable
    static HighlightInfo checkFileLocation(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        VirtualFile root;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileLocation"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileLocation"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile != null && (root = ProjectFileIndex.SERVICE.getInstance(file.getProject()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            String message = JavaErrorMessages.message("module.file.wrong.location", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(element)).description(message).create();
            QuickFixAction.registerQuickFixAction(info, new MoveFileFix(vFile, root, QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkModuleReference(@Nullable PsiJavaModuleReferenceElement refElement, @NotNull PsiJavaModule container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkModuleReference"));
        }
        if (refElement != null) {
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            PsiElement target = ref.resolve();
            if (!(target instanceof PsiJavaModule)) {
                return ModuleHighlightUtil.moduleResolveError(refElement, ref);
            }
            if (target == container) {
                String message = JavaErrorMessages.message("module.cyclic.dependence", container.getName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).description(message).create();
            }
            Collection<PsiJavaModule> cycle = JavaModuleGraphUtil.findCycle((PsiJavaModule)target);
            if (cycle != null && cycle.contains(container)) {
                Stream<String> stream = cycle.stream().map(PsiJavaModule::getName);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    stream = stream.sorted();
                }
                String message = JavaErrorMessages.message("module.cyclic.dependence", stream.collect(Collectors.joining(", ")));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).description(message).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkHostModuleStrength(@NotNull PsiPackageAccessibilityStatement statement) {
        PsiElement parent;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkHostModuleStrength"));
        }
        if (statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS && (parent = statement.getParent()) instanceof PsiJavaModule && ((PsiJavaModule)parent).hasModifierProperty("open")) {
            String message = JavaErrorMessages.message("module.opens.in.weak.module", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).description(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createModifierListFix((PsiModifierListOwner)parent, "open", false, false));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageReference(@NotNull PsiPackageAccessibilityStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageReference"));
        }
        PsiJavaCodeReferenceElement refElement = statement.getPackageReference();
        if (refElement != null) {
            HighlightInfoType type;
            PsiElement target = refElement.resolve();
            Module module = ModuleHighlightUtil.findModule(refElement);
            PsiDirectory[] directories = target instanceof PsiPackage && module != null ? ((PsiPackage)target).getDirectories(module.getModuleScope(false)) : null;
            String packageName = ModuleHighlightUtil.refText(refElement);
            HighlightInfoType highlightInfoType = type = statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            if (directories == null || directories.length == 0) {
                String message = JavaErrorMessages.message("package.not.found", packageName);
                return HighlightInfo.newHighlightInfo(type).range(refElement).description(message).create();
            }
            if (PsiUtil.isPackageEmpty(directories, packageName)) {
                String message = JavaErrorMessages.message("package.is.empty", packageName);
                return HighlightInfo.newHighlightInfo(type).range(refElement).description(message).create();
            }
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkPackageAccessTargets(@NotNull PsiPackageAccessibilityStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessTargets"));
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        THashSet targets = ContainerUtil.newTroveSet();
        for (PsiJavaModuleReferenceElement refElement : statement.getModuleReferences()) {
            String message;
            String refText = refElement.getReferenceText();
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : statement;
            if (!targets.add((String)refText)) {
                message = JavaErrorMessages.message("module.duplicate.export", refText);
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).description(message).create());
                continue;
            }
            if (ref.multiResolve(true).length != 0) continue;
            message = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(refElement).description(message).create());
        }
        List<HighlightInfo> list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessTargets"));
        }
        return list;
    }

    @Nullable
    static HighlightInfo checkServiceReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        if (refElement != null) {
            PsiElement target = refElement.resolve();
            if (target == null) {
                String message = JavaErrorMessages.message("cannot.resolve.symbol", refElement.getReferenceName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).description(message).create();
            }
            if (target instanceof PsiClass && ((PsiClass)target).isEnum()) {
                String message = JavaErrorMessages.message("module.service.enum", ((PsiClass)target).getName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).description(message).create();
            }
        }
        return null;
    }

    @Nullable
    static List<HighlightInfo> checkServiceImplementations(@NotNull PsiProvidesStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkServiceImplementations"));
        }
        PsiReferenceList implRefList = statement.getImplementationList();
        if (implRefList == null) {
            return null;
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        PsiJavaCodeReferenceElement intRef = statement.getInterfaceReference();
        PsiElement intTarget = intRef != null ? intRef.resolve() : null;
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiJavaCodeReferenceElement implRef : implRefList.getReferenceElements()) {
            String message;
            PsiMethod provider;
            PsiElement implTarget;
            String refText = ModuleHighlightUtil.refText(implRef);
            if (!filter.add((String)refText)) {
                String message2 = JavaErrorMessages.message("module.duplicate.impl", refText);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(implRef).description(message2).create();
                QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createDeleteFix(implRef, QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
                results.add(info);
                continue;
            }
            if (!(intTarget instanceof PsiClass) || !((implTarget = implRef.resolve()) instanceof PsiClass)) continue;
            PsiClass implClass = (PsiClass)implTarget;
            if (ModuleHighlightUtil.findModule(statement) != ModuleHighlightUtil.findModule(implClass)) {
                String message3 = JavaErrorMessages.message("module.service.alien", new Object[0]);
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message3).create());
            }
            if ((provider = ContainerUtil.find(implClass.findMethodsByName("provider", false), m -> m.hasModifierProperty("public") && m.hasModifierProperty("static") && m.getParameterList().getParametersCount() == 0)) != null) {
                PsiClass typeClass;
                PsiType type = provider.getReturnType();
                PsiClass psiClass = typeClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
                if (InheritanceUtil.isInheritorOrSelf(typeClass, (PsiClass)intTarget, true)) continue;
                String message4 = JavaErrorMessages.message("module.service.provider.type", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message4).create());
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf(implClass, (PsiClass)intTarget, true)) {
                if (implClass.hasModifierProperty("abstract")) {
                    message = JavaErrorMessages.message("module.service.abstract", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create());
                    continue;
                }
                if (!ClassUtil.isTopLevelClass(implClass) && !implClass.hasModifierProperty("static")) {
                    message = JavaErrorMessages.message("module.service.inner", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create());
                    continue;
                }
                if (PsiUtil.hasDefaultConstructor(implClass)) continue;
                message = JavaErrorMessages.message("module.service.no.ctor", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create());
                continue;
            }
            message = JavaErrorMessages.message("module.service.impl", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create());
        }
        return results;
    }

    @Nullable
    static HighlightInfo checkPackageAccessibility(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiElement target, @NotNull PsiJavaModule refModule) {
        Module module;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessibility"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessibility"));
        }
        if (refModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refModule", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessibility"));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)ref, PsiDocComment.class) == null && (module = ModuleHighlightUtil.findModule(refModule)) != null) {
            PsiDirectory[] dirs;
            PsiElement refImport;
            if (target instanceof PsiClass) {
                PsiElement targetFile = target.getParent();
                if (targetFile instanceof PsiClassOwner) {
                    PsiJavaModule targetModule = ModuleHighlightUtil.getModuleDescriptor((PsiFileSystemItem)targetFile);
                    String packageName = ((PsiClassOwner)targetFile).getPackageName();
                    return ModuleHighlightUtil.checkPackageAccessibility(ref, refModule, targetModule, packageName);
                }
            } else if (target instanceof PsiPackage && (refImport = ref.getParent()) instanceof PsiImportStatementBase && ((PsiImportStatementBase)refImport).isOnDemand() && (dirs = ((PsiPackage)target).getDirectories(module.getModuleWithDependenciesAndLibrariesScope(false))).length == 1) {
                PsiJavaModule targetModule = ModuleHighlightUtil.getModuleDescriptor(dirs[0]);
                String packageName = ((PsiPackage)target).getQualifiedName();
                return ModuleHighlightUtil.checkPackageAccessibility(ref, refModule, targetModule, packageName);
            }
        }
        return null;
    }

    private static HighlightInfo checkPackageAccessibility(PsiJavaCodeReferenceElement ref, PsiJavaModule refModule, PsiJavaModule targetModule, String packageName) {
        if (!refModule.equals(targetModule)) {
            if (targetModule == null) {
                String message = JavaErrorMessages.message("module.package.on.classpath", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(ref).description(message).create();
            }
            String refModuleName = refModule.getName();
            String requiredName = targetModule.getName();
            if (!(targetModule instanceof LightJavaModule) && !JavaModuleGraphUtil.exports(targetModule, packageName, refModule)) {
                String message = JavaErrorMessages.message("module.package.not.exported", requiredName, packageName, refModuleName);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(ref).description(message).create();
            }
            if (!"java.base".equals(requiredName) && !JavaModuleGraphUtil.reads(refModule, targetModule)) {
                String message = JavaErrorMessages.message("module.not.in.requirements", refModuleName, requiredName);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(ref).description(message).create();
                QuickFixAction.registerQuickFixAction(info, new AddRequiredModuleFix(refModule, requiredName));
                return info;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClashingReads(@NotNull PsiJavaModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkClashingReads"));
        }
        Trinity<String, PsiJavaModule, PsiJavaModule> conflict = JavaModuleGraphUtil.findConflict(module);
        if (conflict != null) {
            String message = JavaErrorMessages.message("module.conflicting.reads", module.getName(), conflict.first, ((PsiJavaModule)conflict.second).getName(), ((PsiJavaModule)conflict.third).getName());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(module)).descriptionAndTooltip(message).create();
        }
        return null;
    }

    private static Module findModule(PsiElement element) {
        return Optional.ofNullable(element.getContainingFile()).map(PsiFile::getVirtualFile).map(f -> ModuleUtilCore.findModuleForFile(f, element.getProject())).orElse(null);
    }

    private static HighlightInfo moduleResolveError(PsiJavaModuleReferenceElement refElement, PsiPolyVariantReference ref) {
        if (ref.multiResolve(true).length == 0) {
            String message = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refElement).description(message).create();
        }
        if (ref.multiResolve(false).length > 1) {
            String message = JavaErrorMessages.message("module.ambiguous", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(refElement).description(message).create();
        }
        String message = JavaErrorMessages.message("module.not.on.path", refElement.getReferenceText());
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refElement).description(message).create();
        ModuleHighlightUtil.factory().registerOrderEntryFixes(new QuickFixActionRegistrarImpl(info), ref);
        return info;
    }

    private static QuickFixFactory factory() {
        return QuickFixFactory.getInstance();
    }

    private static TextRange range(PsiJavaModule module) {
        PsiKeyword kw = PsiTreeUtil.getChildOfType(module, PsiKeyword.class);
        return new TextRange(kw != null ? kw.getTextOffset() : module.getTextOffset(), module.getNameIdentifier().getTextRange().getEndOffset());
    }

    private static PsiElement range(PsiJavaCodeReferenceElement refElement) {
        return ObjectUtils.notNull(refElement.getReferenceNameElement(), refElement);
    }
}

