/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveExtraClosingTagIntentionAction
implements LocalQuickFix,
IntentionAction {
    @Override
    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("remove.extra.closing.tag.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "isAvailable"));
        }
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null || !psiElement.isValid() || !(psiElement instanceof XmlToken)) {
            return;
        }
        RemoveExtraClosingTagIntentionAction.doFix(psiElement);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static void doFix(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "doFix"));
        }
        XmlToken endNameToken = (XmlToken)element;
        PsiElement tagElement = endNameToken.getParent();
        if (!(tagElement instanceof XmlTag) && !(tagElement instanceof PsiErrorElement)) {
            return;
        }
        if (tagElement instanceof PsiErrorElement) {
            tagElement.delete();
        } else {
            Document document;
            ASTNode endTagStart;
            ASTNode astNode = tagElement.getNode();
            if (astNode != null && (endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(astNode)) != null && (document = PsiDocumentManager.getInstance(element.getProject()).getDocument(tagElement.getContainingFile())) != null) {
                document.deleteString(endTagStart.getStartOffset(), tagElement.getLastChild().getTextRange().getEndOffset());
            }
        }
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof XmlToken)) {
            return;
        }
        RemoveExtraClosingTagIntentionAction.doFix(element);
    }
}

