/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightingAwareElementDescriptor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddHtmlTagOrAttributeToCustomsIntention;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RequiredAttributesInspectionBase
extends HtmlLocalInspectionTool
implements XmlEntitiesInspection {
    @NonNls
    public static final Key<InspectionProfileEntry> SHORT_NAME_KEY = Key.create("RequiredAttributes");
    protected static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.htmlInspections.RequiredAttributesInspection");
    public String myAdditionalRequiredHtmlAttributes = "";

    private static String appendName(String toAppend, String text) {
        toAppend = !toAppend.isEmpty() ? toAppend + "," + text : text;
        return toAppend;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.HTML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RequiredAttributesInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.required.attributes.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RequiredAttributesInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if ("RequiredAttributes" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RequiredAttributesInspectionBase", "getShortName"));
        }
        return "RequiredAttributes";
    }

    @Override
    public String getAdditionalEntries() {
        return this.myAdditionalRequiredHtmlAttributes;
    }

    @Override
    public void addEntry(String text) {
        this.myAdditionalRequiredHtmlAttributes = RequiredAttributesInspectionBase.appendName(this.getAdditionalEntries(), text);
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    public static LocalQuickFix getIntentionAction(String name) {
        return new AddHtmlTagOrAttributeToCustomsIntention(SHORT_NAME_KEY, name, XmlBundle.message("add.optional.html.attribute", name));
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/RequiredAttributesInspectionBase", "checkTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/RequiredAttributesInspectionBase", "checkTag"));
        }
        String name = tag.getName();
        XmlElementDescriptor elementDescriptor = XmlUtil.getDescriptorFromContext(tag);
        if (elementDescriptor instanceof AnyXmlElementDescriptor || elementDescriptor == null) {
            elementDescriptor = tag.getDescriptor();
        }
        if (elementDescriptor == null) {
            return;
        }
        if (elementDescriptor instanceof XmlHighlightingAwareElementDescriptor && !((XmlHighlightingAwareElementDescriptor)((Object)elementDescriptor)).shouldCheckRequiredAttributes()) {
            return;
        }
        XmlAttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributesDescriptors(tag);
        HashSet<String> requiredAttributes = null;
        for (XmlAttributeDescriptor attribute : attributeDescriptors) {
            if (attribute == null || !attribute.isRequired()) continue;
            if (requiredAttributes == null) {
                requiredAttributes = new HashSet<String>();
            }
            requiredAttributes.add(attribute.getName(tag));
        }
        if (requiredAttributes != null) {
            for (String attrName : requiredAttributes) {
                if (RequiredAttributesInspectionBase.hasAttribute(tag, attrName) || XmlExtension.getExtension(tag.getContainingFile()).isRequiredAttributeImplicitlyPresent(tag, attrName)) continue;
                LocalQuickFixAndIntentionActionOnPsiElement insertRequiredAttributeIntention = XmlQuickFixFactory.getInstance().insertRequiredAttributeFix(tag, attrName, new String[0]);
                String localizedMessage = XmlErrorMessages.message("element.doesnt.have.required.attribute", name, attrName);
                this.reportOneTagProblem(tag, attrName, localizedMessage, insertRequiredAttributeIntention, holder, RequiredAttributesInspectionBase.getIntentionAction(attrName));
            }
        }
    }

    private static boolean hasAttribute(XmlTag tag, String attrName) {
        XmlAttribute attribute = tag.getAttribute(attrName);
        if (attribute == null) {
            return false;
        }
        if (attribute.getValueElement() != null) {
            return true;
        }
        if (!(tag instanceof HtmlTag)) {
            return false;
        }
        XmlAttributeDescriptor descriptor = attribute.getDescriptor();
        return descriptor != null && HtmlUtil.isBooleanAttribute(descriptor, tag);
    }

    private void reportOneTagProblem(XmlTag tag, String name, @NotNull String localizedMessage, LocalQuickFix basicIntention, ProblemsHolder holder, LocalQuickFix addAttributeFix) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/codeInspection/htmlInspections/RequiredAttributesInspectionBase", "reportOneTagProblem"));
        }
        boolean htmlTag = false;
        if (tag instanceof HtmlTag) {
            htmlTag = true;
            if (RequiredAttributesInspectionBase.isAdditionallyDeclared(this.getAdditionalEntries(), name)) {
                return;
            }
        }
        if (htmlTag) {
            RequiredAttributesInspectionBase.addElementsForTag(tag, localizedMessage, XmlHighlightVisitor.isInjectedWithoutValidation(tag) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder, addAttributeFix, basicIntention);
        } else {
            RequiredAttributesInspectionBase.addElementsForTag(tag, localizedMessage, ProblemHighlightType.ERROR, holder, basicIntention);
        }
    }

    private static void addElementsForTag(XmlTag tag, String message, ProblemHighlightType error, ProblemsHolder holder, LocalQuickFix ... fixes) {
        RequiredAttributesInspectionBase.registerProblem(message, error, holder, XmlTagUtil.getStartTagNameElement(tag), fixes);
        RequiredAttributesInspectionBase.registerProblem(message, error, holder, XmlTagUtil.getEndTagNameElement(tag), fixes);
    }

    private static void registerProblem(String message, ProblemHighlightType error, ProblemsHolder holder, XmlToken start, LocalQuickFix[] fixes) {
        if (start != null) {
            holder.registerProblem((PsiElement)start, message, error, fixes);
        }
    }

    private static boolean isAdditionallyDeclared(String additional, String name) {
        if (!additional.contains(name = name.toLowerCase())) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(additional, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!name.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }
}

