/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import java.util.Arrays;

public class IndexPatternUtil {
    public static IndexPatternProvider[] getIndexPatternProviders() {
        return Extensions.getExtensions(IndexPatternProvider.EP_NAME);
    }

    public static int getIndexPatternCount() {
        return Arrays.stream(IndexPatternUtil.getIndexPatternProviders()).mapToInt(provider -> provider.getIndexPatterns().length).sum();
    }

    public static IndexPattern[] getIndexPatterns() {
        IndexPattern[] result = new IndexPattern[IndexPatternUtil.getIndexPatternCount()];
        int destIndex = 0;
        for (IndexPatternProvider provider : IndexPatternUtil.getIndexPatternProviders()) {
            for (IndexPattern pattern : provider.getIndexPatterns()) {
                result[destIndex++] = pattern;
            }
        }
        return result;
    }
}

