/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryUnicodeEscapeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.unicode.escape.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Character c = (Character)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessary.unicode.escape.problem.descriptor", c);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryUnicodeEscapeFix(((Character)infos[0]).charValue(), (RangeMarker)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnicodeEscapeVisitor();
    }

    private class UnnecessaryUnicodeEscapeVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnicodeEscapeVisitor() {
        }

        @Override
        public void visitFile(PsiFile file) {
            super.visitFile(file);
            if (InjectedLanguageManager.getInstance(file.getProject()).isInjectedFragment(file) || !file.isPhysical()) {
                return;
            }
            Document document = PsiDocumentManager.getInstance(file.getProject()).getDocument(file);
            if (document == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            String text = file.getText();
            Charset charset = LoadTextUtil.extractCharsetFromFileContent(file.getProject(), virtualFile, text);
            CharsetEncoder encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT);
            CharBuffer charBuffer = CharBuffer.allocate(1);
            ByteBuffer byteBuffer = ByteBuffer.allocate(10);
            int length = text.length();
            for (int i2 = 0; i2 < length; ++i2) {
                int escapeEnd;
                char d;
                int type;
                char c = text.charAt(i2);
                if (c != '\\') continue;
                boolean isEscape = true;
                for (int previousChar = i2 - 1; previousChar >= 0 && text.charAt(previousChar) == '\\'; --previousChar) {
                    isEscape = !isEscape;
                }
                if (!isEscape) continue;
                int nextChar = i2;
                while (++nextChar < length && text.charAt(nextChar) == 'u') {
                }
                if (nextChar == i2 + 1 || nextChar + 3 >= length || !StringUtil.isHexDigit(text.charAt(nextChar)) || !StringUtil.isHexDigit(text.charAt(nextChar + 1)) || !StringUtil.isHexDigit(text.charAt(nextChar + 2)) || !StringUtil.isHexDigit(text.charAt(nextChar + 3)) || (type = Character.getType(d = (char)Integer.parseInt(text.substring(nextChar, escapeEnd = nextChar + 4), 16))) == 15 || type == 16 || type == 18 || type == 19 || type == 0 || type == 13 || type == 14 || type == 12 && d != ' ') continue;
                byteBuffer.clear();
                charBuffer.clear();
                charBuffer.put(d).rewind();
                CoderResult coderResult = encoder.encode(charBuffer, byteBuffer, true);
                if (coderResult.isError()) continue;
                PsiElement element = file.findElementAt(i2);
                if (element != null && UnnecessaryUnicodeEscapeInspection.this.isSuppressedFor(element)) {
                    return;
                }
                RangeMarker rangeMarker = document.createRangeMarker(new TextRange(i2, escapeEnd));
                this.registerErrorAtOffset((PsiElement)file, i2, escapeEnd - i2, Character.valueOf(d), rangeMarker);
            }
        }
    }

    private static class UnnecessaryUnicodeEscapeFix
    extends InspectionGadgetsFix {
        private final char c;
        private final RangeMarker myRangeMarker;

        public UnnecessaryUnicodeEscapeFix(char c, RangeMarker rangeMarker) {
            this.c = c;
            this.myRangeMarker = rangeMarker;
        }

        @Override
        @NotNull
        public String getName() {
            String string = "Replace with '" + this.c + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection$UnnecessaryUnicodeEscapeFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with character" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection$UnnecessaryUnicodeEscapeFix", "getFamilyName"));
            }
            return "Replace with character";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            this.myRangeMarker.getDocument().replaceString(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset(), String.valueOf(this.c));
        }
    }
}

