/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class BeforeOrAfterIsPublicVoidNoArgInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("BeforeOrAfterWithIncorrectSignature" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspectionBase", "getID"));
        }
        return "BeforeOrAfterWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("before.or.after.is.public.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("before.or.after.is.public.void.no.arg.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BeforeOrAfterIsPublicVoidNoArgVisitor();
    }

    private static class BeforeOrAfterIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private BeforeOrAfterIsPublicVoidNoArgVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspectionBase$BeforeOrAfterIsPublicVoidNoArgVisitor", "visitMethod"));
            }
            if (!TestUtils.isJUnit4BeforeOrAfterMethod(method)) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0 || !returnType.equals(PsiType.VOID) || !method.hasModifierProperty("public") || method.hasModifierProperty("static")) {
                this.registerMethodError(method, method);
            }
        }
    }
}

