/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsElementExtensionSerializerBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;

public abstract class JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsLoaderBase.class);
    private static final int MAX_ATTEMPTS = 5;
    private final JpsMacroExpander myMacroExpander;

    protected JpsLoaderBase(JpsMacroExpander macroExpander) {
        this.myMacroExpander = macroExpander;
    }

    protected Element loadRootElement(File file) {
        return JpsLoaderBase.loadRootElement(file, this.myMacroExpander);
    }

    protected <E extends JpsElement> void loadComponents(File dir, String defaultFileName, JpsElementExtensionSerializerBase<E> serializer2, E element) {
        String fileName = serializer2.getConfigFileName();
        File configFile = new File(dir, fileName != null ? fileName : defaultFileName);
        Runnable timingLog = TimingLog.startActivity("loading: " + configFile.getName() + ":" + serializer2.getComponentName());
        Element componentTag = configFile.exists() ? JDomSerializationUtil.findComponent(this.loadRootElement(configFile), serializer2.getComponentName()) : null;
        if (componentTag != null) {
            serializer2.loadExtension(element, componentTag);
        } else {
            serializer2.loadExtensionWithDefaultSettings(element);
        }
        timingLog.run();
    }

    protected static Element loadRootElement(File file, JpsMacroExpander macroExpander) {
        try {
            Element element = JpsLoaderBase.tryLoadRootElement(file);
            macroExpander.substitute(element, SystemInfo.isFileSystemCaseSensitive);
            return element;
        }
        catch (JDOMException e) {
            throw new CannotLoadJpsModelException(file, "Cannot parse xml file " + file.getAbsolutePath() + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CannotLoadJpsModelException(file, "Cannot read file " + file.getAbsolutePath() + ": " + e.getMessage(), e);
        }
    }

    private static Element tryLoadRootElement(File file) throws IOException, JDOMException {
        for (int i2 = 0; i2 < 4; ++i2) {
            try {
                return JDOMUtil.load(file);
            }
            catch (Exception e) {
                LOG.info("Loading attempt #" + i2 + " failed", e);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return JDOMUtil.load(file);
    }
}

