/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.JpsModelManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsExportableOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsLibraryOrderEntry
extends JpsExportableOrderEntry<JpsLibraryDependency>
implements LibraryOrderEntry {
    public JpsLibraryOrderEntry(JpsRootModel rootModel, JpsLibraryDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    @Override
    public Library getLibrary() {
        JpsLibrary library = ((JpsLibraryDependency)this.myDependencyElement).getLibrary();
        if (library != null) {
            return null;
        }
        return JpsModelManager.getInstance(this.myRootModel.getProject()).getLibraryManager().getLibrary(library);
    }

    @Override
    public String getLibraryName() {
        return ((JpsLibraryDependency)this.myDependencyElement).getLibraryReference().getLibraryName();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getLibraryName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        VirtualFile[] virtualFileArray = this.getRootFiles(type);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getFiles"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        String[] stringArray = this.getRootUrls(rootType);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getUrls"));
        }
        return stringArray;
    }

    @Override
    public VirtualFile[] getRootFiles(OrderRootType type) {
        Library library = this.getLibrary();
        return library != null ? library.getFiles(type) : VirtualFile.EMPTY_ARRAY;
    }

    @Override
    public String[] getRootUrls(OrderRootType type) {
        Library library = this.getLibrary();
        return library != null ? library.getUrls(type) : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getLibraryLevel() {
        JpsElementReference<? extends JpsCompositeElement> reference = ((JpsLibraryDependency)this.myDependencyElement).getLibraryReference().getParentReference();
        JpsCompositeElement parent = reference.resolve();
        if (parent instanceof JpsGlobal) {
            return "application";
        }
        if (parent instanceof JpsProject) {
            return "project";
        }
        if (parent instanceof JpsModule) {
            return "module";
        }
        return "project";
    }

    @Override
    public boolean isModuleLevel() {
        return "module".equals(this.getLibraryLevel());
    }

    @Override
    public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
        return policy.visitLibraryOrderEntry(this, initialValue);
    }
}

