/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnclearBinaryExpressionInspection
extends BaseInspection {
    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("UnclearExpression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection", "getID"));
        }
        return "UnclearExpression";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unclear.binary.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unclear.binary.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnclearBinaryExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnclearBinaryExpressionVisitor();
    }

    public static boolean mightBeConfusingExpression(@Nullable PsiElement element) {
        return element instanceof PsiPolyadicExpression || element instanceof PsiConditionalExpression || element instanceof PsiInstanceOfExpression || element instanceof PsiAssignmentExpression || element instanceof PsiParenthesizedExpression;
    }

    @Contract(value="null, _ -> false")
    public static boolean isUnclearExpression(PsiExpression expression, PsiElement parent) {
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression nestedAssignment;
            IElementType nestedTokenType;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (parent instanceof PsiVariable ? !tokenType.equals(JavaTokenType.EQ) : parent instanceof PsiAssignmentExpression && !tokenType.equals(nestedTokenType = (nestedAssignment = (PsiAssignmentExpression)parent).getOperationTokenType())) {
                return true;
            }
            return UnclearBinaryExpressionInspection.isUnclearExpression(assignmentExpression.getRExpression(), assignmentExpression);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            if (PsiUtilCore.hasErrorElementChild(expression)) {
                return false;
            }
            return parent instanceof PsiConditionalExpression || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getCondition(), conditionalExpression) || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getThenExpression(), conditionalExpression) || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getElseExpression(), conditionalExpression);
        }
        if (expression instanceof PsiPolyadicExpression) {
            if (parent instanceof PsiConditionalExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiInstanceOfExpression) {
                return true;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                PsiType type = operand.getType();
                if (type == null || type.equalsToText("java.lang.String")) {
                    return false;
                }
                if (!UnclearBinaryExpressionInspection.isUnclearExpression(operand, polyadicExpression)) continue;
                return true;
            }
        } else {
            if (expression instanceof PsiInstanceOfExpression) {
                if (parent instanceof PsiPolyadicExpression || parent instanceof PsiConditionalExpression) {
                    return true;
                }
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
                return UnclearBinaryExpressionInspection.isUnclearExpression(instanceOfExpression.getOperand(), instanceOfExpression);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression nestedExpression = parenthesizedExpression.getExpression();
                return UnclearBinaryExpressionInspection.isUnclearExpression(nestedExpression, parenthesizedExpression);
            }
        }
        return false;
    }

    public static void replaceElement(PsiElement element) {
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression = (PsiExpression)element;
        String newExpressionText = UnclearBinaryExpressionInspection.createReplacementText(expression, new StringBuilder()).toString();
        PsiReplacementUtil.replaceExpression(expression, newExpressionText);
    }

    private static StringBuilder createReplacementText(@Nullable PsiExpression expression, StringBuilder out) {
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            PsiElement parent = expression.getParent();
            boolean parentheses = parent instanceof PsiConditionalExpression || parent instanceof PsiInstanceOfExpression || parent instanceof PsiPolyadicExpression;
            UnclearBinaryExpressionInspection.appendText(polyadicExpression, parentheses, out);
        } else if (expression instanceof PsiParenthesizedExpression) {
            for (PsiElement child : expression.getChildren()) {
                if (child instanceof PsiExpression) {
                    PsiExpression unwrappedExpression = (PsiExpression)child;
                    UnclearBinaryExpressionInspection.createReplacementText(unwrappedExpression, out);
                    continue;
                }
                out.append(child.getText());
            }
        } else if (expression instanceof PsiInstanceOfExpression) {
            PsiElement parent = expression.getParent();
            boolean parentheses = parent instanceof PsiPolyadicExpression || parent instanceof PsiConditionalExpression;
            UnclearBinaryExpressionInspection.appendText(expression, parentheses, out);
        } else if (expression instanceof PsiConditionalExpression) {
            PsiElement parent = expression.getParent();
            boolean parentheses = parent instanceof PsiConditionalExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiInstanceOfExpression;
            UnclearBinaryExpressionInspection.appendText(expression, parentheses, out);
        } else if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiElement parent = expression.getParent();
            boolean parentheses = !UnclearBinaryExpressionInspection.isSimpleAssignment(assignmentExpression, parent);
            UnclearBinaryExpressionInspection.appendText(assignmentExpression, parentheses, out);
        } else if (expression != null) {
            out.append(expression.getText());
        }
        return out;
    }

    private static boolean isSimpleAssignment(PsiAssignmentExpression assignmentExpression, PsiElement parent) {
        IElementType parentTokenType;
        if (parent instanceof PsiExpressionStatement) {
            return true;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression parentAssignmentExpression = (PsiAssignmentExpression)parent;
            parentTokenType = parentAssignmentExpression.getOperationTokenType();
        } else if (parent instanceof PsiVariable) {
            parentTokenType = JavaTokenType.EQ;
        } else {
            return false;
        }
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        return parentTokenType.equals(tokenType);
    }

    private static void appendText(PsiExpression expression, boolean parentheses, StringBuilder out) {
        if (parentheses) {
            out.append('(');
        }
        for (PsiElement child : expression.getChildren()) {
            if (child instanceof PsiExpression) {
                UnclearBinaryExpressionInspection.createReplacementText((PsiExpression)child, out);
                continue;
            }
            out.append(child.getText());
        }
        if (parentheses) {
            out.append(')');
        }
    }

    private static class UnclearBinaryExpressionVisitor
    extends BaseInspectionVisitor {
        private UnclearBinaryExpressionVisitor() {
        }

        @Override
        public void visitExpression(PsiExpression expression) {
            super.visitExpression(expression);
            PsiElement parent = expression.getParent();
            if (UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent) || !UnclearBinaryExpressionInspection.isUnclearExpression(expression, parent)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class UnclearBinaryExpressionFix
    extends InspectionGadgetsFix {
        private UnclearBinaryExpressionFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unclear.binary.expression.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection$UnclearBinaryExpressionFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            UnclearBinaryExpressionInspection.replaceElement(descriptor.getPsiElement());
        }
    }
}

