/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.codeInspection.nullable.ChangeNullableDefaultsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableStuffInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @Deprecated
    public boolean REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = true;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_GETTER = true;
    public boolean IGNORE_EXTERNAL_SUPER_NOTNULL;
    public boolean REQUIRE_NOTNULL_FIELDS_INITIALIZED = true;
    public boolean REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_SETTER_PARAMETER = true;
    @Deprecated
    public boolean REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = true;
    public boolean REPORT_NULLS_PASSED_TO_NON_ANNOTATED_METHOD = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.nullable.NullableStuffInspectionBase");

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        for (Element child : new ArrayList(node.getChildren())) {
            String name = child.getAttributeValue("name");
            String value = child.getAttributeValue("value");
            if (!("IGNORE_EXTERNAL_SUPER_NOTNULL".equals(name) && "false".equals(value) || "REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED".equals(name) && "false".equals(value) || "REQUIRE_NOTNULL_FIELDS_INITIALIZED".equals(name) && "true".equals(value)) && (!"REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER".equals(name) || !"true".equals(value))) continue;
            node.removeContent((Content)child);
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
        }
        PsiFile file = holder.getFile();
        if (!PsiUtil.isLanguageLevel5OrHigher(file) || NullableStuffInspectionBase.nullabilityAnnotationsNotAvailable(file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethod(PsiMethod method) {
                NullableStuffInspectionBase.this.checkNullableStuffForMethod(method, holder, isOnTheFly);
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                NullableStuffInspectionBase.this.checkMethodReference(expression, holder);
            }

            @Override
            public void visitField(PsiField field) {
                PsiType type = field.getType();
                Annotated annotated = NullableStuffInspectionBase.check(field, holder, type);
                if (TypeConversionUtil.isPrimitiveAndNotNull(type)) {
                    return;
                }
                Project project = holder.getProject();
                NullableNotNullManager manager = NullableNotNullManager.getInstance(project);
                if (annotated.isDeclaredNotNull ^ annotated.isDeclaredNullable) {
                    List<String> annoToRemove;
                    String anno = annotated.isDeclaredNotNull ? manager.getDefaultNotNull() : manager.getDefaultNullable();
                    List<String> list = annoToRemove = annotated.isDeclaredNotNull ? manager.getNullables() : manager.getNotNulls();
                    if (!NullableStuffInspectionBase.checkNonStandardAnnotations(field, annotated, manager, anno, holder)) {
                        return;
                    }
                    NullableStuffInspectionBase.this.checkAccessors(field, annotated, project, manager, anno, annoToRemove, holder);
                    NullableStuffInspectionBase.this.checkConstructorParameters(field, annotated, manager, anno, annoToRemove, holder);
                }
                if (NullableStuffInspectionBase.this.REQUIRE_NOTNULL_FIELDS_INITIALIZED && !annotated.isDeclaredNullable) {
                    NullableStuffInspectionBase.checkNotNullFieldsInitialized(field, manager, holder);
                }
            }

            @Override
            public void visitParameter(PsiParameter parameter) {
                NullableStuffInspectionBase.check(parameter, holder, parameter.getType());
            }

            @Override
            public void visitAnnotation(PsiAnnotation annotation) {
                PsiClass psiClass;
                if (!"org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("exception");
                if (value instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInClassTypeOnly(((PsiClassObjectAccessExpression)value).getOperand().getType())) != null && !this.hasStringConstructor(psiClass)) {
                    holder.registerProblem((PsiElement)value, "Custom exception class should have a constructor with a single message parameter of String type", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private boolean hasStringConstructor(PsiClass aClass) {
                for (PsiMethod method : aClass.getConstructors()) {
                    PsiParameterList list = method.getParameterList();
                    if (list.getParametersCount() != 1 || !list.getParameters()[0].getType().equalsToText("java.lang.String")) continue;
                    return true;
                }
                return false;
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private void checkMethodReference(PsiMethodReferenceExpression expression, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkMethodReference"));
        }
        PsiMethod superMethod = LambdaUtil.getFunctionalInterfaceMethod(expression);
        PsiMethod targetMethod = ObjectUtils.tryCast(expression.resolve(), PsiMethod.class);
        if (superMethod == null || targetMethod == null) {
            return;
        }
        PsiElement refName = expression.getReferenceNameElement();
        assert (refName != null);
        if (this.isNullableOverridingNotNull(NullableStuffInspectionBase.check(targetMethod, holder, expression.getType()), superMethod)) {
            holder.registerProblem(refName, InspectionsBundle.message("inspection.nullable.problems.Nullable.method.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName(targetMethod), NullableStuffInspectionBase.getPresentableAnnoName(superMethod)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        } else if (this.isNonAnnotatedOverridingNotNull(targetMethod, superMethod)) {
            holder.registerProblem(refName, "Not annotated method is used as an override for a method annotated with " + NullableStuffInspectionBase.getPresentableAnnoName(superMethod), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.createFixForNonAnnotatedOverridesNotNull(targetMethod, superMethod));
        }
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return null;
    }

    private static boolean nullabilityAnnotationsNotAvailable(PsiFile file) {
        Project project = file.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope(project);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        return ContainerUtil.find(NullableNotNullManager.getInstance(project).getNullables(), s -> facade.findClass((String)s, scope) != null) == null;
    }

    private static boolean checkNonStandardAnnotations(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkNonStandardAnnotations"));
        }
        if (!AnnotationUtil.isAnnotatingApplicable(field, anno)) {
            PsiAnnotation annotation;
            PsiAnnotation notNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, manager.getNotNulls());
            PsiAnnotation nullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, manager.getNullables());
            String message = "Not '";
            if (annotated.isDeclaredNullable) {
                message = message + nullable.getQualifiedName();
                annotation = nullable;
            } else {
                message = message + notNull.getQualifiedName();
                annotation = notNull;
            }
            message = message + "' but '" + anno + "' would be used for code generation.";
            PsiJavaCodeReferenceElement annotationNameReferenceElement = annotation.getNameReferenceElement();
            holder.registerProblem(annotationNameReferenceElement != null && annotationNameReferenceElement.isPhysical() ? annotationNameReferenceElement : field.getNameIdentifier(), message, ProblemHighlightType.WEAK_WARNING, new ChangeNullableDefaultsFix(notNull, nullable, manager));
            return false;
        }
        return true;
    }

    private void checkAccessors(PsiField field, Annotated annotated, Project project, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod setter;
        PsiIdentifier nameIdentifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkAccessors"));
        }
        String propName = JavaCodeStyleManager.getInstance(project).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
        boolean isStatic = field.hasModifierProperty("static");
        PsiMethod getter = PropertyUtil.findPropertyGetter(field.getContainingClass(), propName, isStatic, false);
        PsiIdentifier psiIdentifier = nameIdentifier = getter == null ? null : getter.getNameIdentifier();
        if (nameIdentifier != null && nameIdentifier.isPhysical() && PropertyUtil.isSimpleGetter(getter)) {
            AnnotateMethodFix getterAnnoFix = new AnnotateMethodFix(anno, ArrayUtil.toStringArray(annoToRemove)){

                @Override
                public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
                    return 1;
                }
            };
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability(getter) && !TypeConversionUtil.isPrimitiveAndNotNull(getter.getReturnType())) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message("inspection.nullable.problems.annotated.field.getter.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName(field)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, getterAnnoFix);
            }
            if (annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred(getter, false) || annotated.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred(getter, false, false)) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message("inspection.nullable.problems.annotated.field.getter.conflict", NullableStuffInspectionBase.getPresentableAnnoName(field), NullableStuffInspectionBase.getPresentableAnnoName(getter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, getterAnnoFix);
            }
        }
        if ((setter = PropertyUtil.findPropertySetter(containingClass = field.getContainingClass(), propName, isStatic, false)) != null && setter.isPhysical()) {
            PsiIdentifier nameIdentifier1;
            PsiParameter[] parameters = setter.getParameterList().getParameters();
            assert (parameters.length == 1) : setter.getText();
            PsiParameter parameter = parameters[0];
            LOG.assertTrue(parameter != null, setter.getText());
            AddAnnotationPsiFix addAnnoFix = NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter);
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability(parameter) && !TypeConversionUtil.isPrimitiveAndNotNull(parameter.getType())) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message("inspection.nullable.problems.annotated.field.setter.parameter.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName(field)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, addAnnoFix);
            }
            if (PropertyUtil.isSimpleSetter(setter) && annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred(parameter, false)) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message("inspection.nullable.problems.annotated.field.setter.parameter.conflict", NullableStuffInspectionBase.getPresentableAnnoName(field), NullableStuffInspectionBase.getPresentableAnnoName(parameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, addAnnoFix);
            }
        }
    }

    @NotNull
    private static AddAnnotationPsiFix createAddAnnotationFix(String anno, List<String> annoToRemove, PsiParameter parameter) {
        AddAnnotationPsiFix addAnnotationPsiFix = new AddAnnotationPsiFix(anno, parameter, PsiNameValuePair.EMPTY_ARRAY, ArrayUtil.toStringArray(annoToRemove));
        if (addAnnotationPsiFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "createAddAnnotationFix"));
        }
        return addAnnotationPsiFix;
    }

    private static void assertValidElement(PsiMethod setter, PsiParameter parameter, PsiIdentifier nameIdentifier1) {
        LOG.assertTrue(nameIdentifier1 != null && nameIdentifier1.isPhysical(), setter.getText());
        LOG.assertTrue(parameter.isPhysical(), setter.getText());
    }

    private static void checkNotNullFieldsInitialized(PsiField field, NullableNotNullManager manager, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkNotNullFieldsInitialized"));
        }
        PsiAnnotation annotation = manager.getNotNullAnnotation(field, false);
        if (annotation == null || HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
            return;
        }
        boolean byDefault = manager.isContainerAnnotation(annotation);
        PsiJavaCodeReferenceElement name = annotation.getNameReferenceElement();
        holder.registerProblem(annotation.isPhysical() && !byDefault ? annotation : field.getNameIdentifier(), (byDefault && name != null ? "@" + name.getReferenceName() : "Not-null") + " fields must be initialized", new LocalQuickFix[0]);
    }

    private void checkConstructorParameters(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkConstructorParameters"));
        }
        List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
        if (initializers.isEmpty()) {
            return;
        }
        ArrayList notNullParams = ContainerUtil.newArrayList();
        boolean isFinal = field.hasModifierProperty("final");
        for (PsiExpression rhs : initializers) {
            PsiIdentifier nameIdentifier;
            PsiElement target;
            if (!(rhs instanceof PsiReferenceExpression) || !NullableStuffInspectionBase.isConstructorParameter(target = ((PsiReferenceExpression)rhs).resolve()) || !target.isPhysical()) continue;
            PsiParameter parameter = (PsiParameter)target;
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability(parameter) && !TypeConversionUtil.isPrimitiveAndNotNull(parameter.getType()) && (nameIdentifier = parameter.getNameIdentifier()) != null && nameIdentifier.isPhysical()) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message("inspection.nullable.problems.annotated.field.constructor.parameter.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName(field)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter));
                continue;
            }
            if (!isFinal || !annotated.isDeclaredNullable || !NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false)) continue;
            notNullParams.add(parameter);
        }
        if (notNullParams.size() != initializers.size()) {
            return;
        }
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        if (nameIdentifier.isPhysical()) {
            holder.registerProblem((PsiElement)nameIdentifier, "@" + NullableStuffInspectionBase.getPresentableAnnoName(field) + " field is always initialized not-null", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new AddNotNullAnnotationFix(field));
        }
    }

    private static boolean isConstructorParameter(@Nullable PsiElement parameter) {
        return parameter instanceof PsiParameter && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiParameterList.class).withParent(PsiJavaPatterns.psiMethod().constructor(true))).accepts(parameter.getParent());
    }

    @NotNull
    private static String getPresentableAnnoName(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance(owner.getProject());
        HashSet<String> names = ContainerUtil.newHashSet(manager.getNullables());
        names.addAll(manager.getNotNulls());
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy(owner, names);
        if (annotation != null) {
            String string = NullableStuffInspectionBase.getPresentableAnnoName(annotation);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
            }
            return string;
        }
        String anno = manager.getNotNull(owner);
        String string = StringUtil.getShortName(anno != null ? anno : StringUtil.notNullize(manager.getNullable(owner), "???"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        return string;
    }

    public static String getPresentableAnnoName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        return StringUtil.getShortName(StringUtil.notNullize(annotation.getQualifiedName(), "???"));
    }

    private static Annotated check(PsiModifierListOwner parameter, ProblemsHolder holder, PsiType type) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance(holder.getProject());
        PsiAnnotation isDeclaredNotNull = AnnotationUtil.findAnnotation(parameter, manager.getNotNulls());
        PsiAnnotation isDeclaredNullable = AnnotationUtil.findAnnotation(parameter, manager.getNullables());
        if (isDeclaredNullable != null && isDeclaredNotNull != null) {
            NullableStuffInspectionBase.reportNullableNotNullConflict(holder, parameter, isDeclaredNullable, isDeclaredNotNull);
        }
        if ((isDeclaredNotNull != null || isDeclaredNullable != null) && type != null && TypeConversionUtil.isPrimitive(type.getCanonicalText())) {
            PsiAnnotation annotation = isDeclaredNotNull == null ? isDeclaredNullable : isDeclaredNotNull;
            NullableStuffInspectionBase.reportPrimitiveType(holder, annotation, annotation, parameter);
        }
        return new Annotated(isDeclaredNotNull != null, isDeclaredNullable != null);
    }

    private static void reportPrimitiveType(ProblemsHolder holder, PsiElement psiElement, PsiAnnotation annotation, PsiModifierListOwner listOwner) {
        holder.registerProblem(psiElement.isPhysical() ? psiElement : listOwner.getNavigationElement(), InspectionsBundle.message("inspection.nullable.problems.primitive.type.annotation", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RemoveAnnotationQuickFix(annotation, listOwner));
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.nullable.problems.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("NullableProblems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getShortName"));
        }
        return "NullableProblems";
    }

    private void checkNullableStuffForMethod(PsiMethod method, ProblemsHolder holder, boolean isOnFly) {
        Annotated annotated = NullableStuffInspectionBase.check(method, holder, method.getReturnType());
        List<PsiMethod> superMethods = ContainerUtil.map(method.findSuperMethodSignaturesIncludingStatic(true), signature -> signature.getMethod());
        NullableNotNullManager nullableManager = NullableNotNullManager.getInstance(holder.getProject());
        this.checkSupers(method, holder, annotated, superMethods);
        this.checkParameters(method, holder, superMethods, nullableManager, isOnFly);
        this.checkOverriders(method, holder, annotated, nullableManager);
    }

    private void checkSupers(PsiMethod method, ProblemsHolder holder, Annotated annotated, List<PsiMethod> superMethods) {
        for (PsiMethod superMethod : superMethods) {
            if (this.isNullableOverridingNotNull(annotated, superMethod)) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, this.getNullityManager(method).getNullables(), true);
                holder.registerProblem(annotation != null ? annotation : method.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.Nullable.method.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName(method), NullableStuffInspectionBase.getPresentableAnnoName(superMethod)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                break;
            }
            if (!this.isNonAnnotatedOverridingNotNull(method, superMethod)) continue;
            holder.registerProblem((PsiElement)method.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.method.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName(superMethod)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.createFixForNonAnnotatedOverridesNotNull(method, superMethod));
            break;
        }
    }

    private NullableNotNullManager getNullityManager(PsiMethod method) {
        return NullableNotNullManager.getInstance(method.getProject());
    }

    private LocalQuickFix createFixForNonAnnotatedOverridesNotNull(PsiMethod method, PsiMethod superMethod) {
        NullableNotNullManager nullableManager = this.getNullityManager(method);
        String defaultNotNull = nullableManager.getDefaultNotNull();
        String[] annotationsToRemove = ArrayUtil.toStringArray(nullableManager.getNullables());
        return AnnotationUtil.isAnnotatingApplicable(method, defaultNotNull) ? this.createAnnotateMethodFix(defaultNotNull, annotationsToRemove) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, superMethod);
    }

    private boolean isNullableOverridingNotNull(Annotated methodInfo, PsiMethod superMethod) {
        return this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && methodInfo.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred(superMethod, true, false);
    }

    private boolean isNonAnnotatedOverridingNotNull(PsiMethod method, PsiMethod superMethod) {
        return this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !(method.getReturnType() instanceof PsiPrimitiveType) && !method.isConstructor() && !this.getNullityManager(method).hasNullability(method) && NullableStuffInspectionBase.isNotNullNotInferred(superMethod, true, this.IGNORE_EXTERNAL_SUPER_NOTNULL) && !NullableStuffInspectionBase.hasInheritableNotNull(superMethod);
    }

    private static boolean hasInheritableNotNull(PsiModifierListOwner owner) {
        return AnnotationUtil.isAnnotated(owner, "javax.annotation.constraints.NotNull", true);
    }

    private void checkParameters(PsiMethod method, ProblemsHolder holder, List<PsiMethod> superMethods, NullableNotNullManager nullableManager, boolean isOnFly) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiParameter parameter = parameters[i2];
            ArrayList<PsiParameter> superParameters = ContainerUtil.newArrayList();
            for (PsiMethod superMethod : superMethods) {
                PsiParameter[] _superParameters = superMethod.getParameterList().getParameters();
                if (_superParameters.length != parameters.length) continue;
                superParameters.add(_superParameters[i2]);
            }
            if (this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE) {
                for (PsiParameter superParameter : superParameters) {
                    if (!NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false) || !NullableStuffInspectionBase.isNullableNotInferred(superParameter, false)) continue;
                    PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, nullableManager.getNotNulls(), true);
                    holder.registerProblem(annotation != null ? annotation : parameter.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.NotNull.parameter.overrides.Nullable", NullableStuffInspectionBase.getPresentableAnnoName(parameter), NullableStuffInspectionBase.getPresentableAnnoName(superParameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    break;
                }
            }
            if (this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL) {
                for (PsiParameter superParameter : superParameters) {
                    if (nullableManager.hasNullability(parameter) || !NullableStuffInspectionBase.isNotNullNotInferred(superParameter, false, this.IGNORE_EXTERNAL_SUPER_NOTNULL) || NullableStuffInspectionBase.hasInheritableNotNull(superParameter)) continue;
                    LocalQuickFix fix = AnnotationUtil.isAnnotatingApplicable(parameter, nullableManager.getDefaultNotNull()) ? new AddNotNullAnnotationFix(parameter) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, superParameter);
                    holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.parameter.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName(superParameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
                    break;
                }
            }
            if (this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED) {
                for (PsiParameter superParameter : superParameters) {
                    if (nullableManager.hasNullability(superParameter) || !NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false)) continue;
                    PsiAnnotation notNullAnnotation = nullableManager.getNotNullAnnotation(parameter, false);
                    assert (notNullAnnotation != null);
                    boolean physical = PsiTreeUtil.isAncestor(parameter, notNullAnnotation, true);
                    RemoveAnnotationQuickFix fix = physical ? new RemoveAnnotationQuickFix(notNullAnnotation, parameter) : null;
                    holder.registerProblem(physical ? notNullAnnotation : parameter.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.NotNull.parameter.overrides.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName(parameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
                    break;
                }
            }
            this.checkNullLiteralArgumentOfNotNullParameterUsages(method, holder, nullableManager, isOnFly, i2, parameter);
        }
    }

    private void checkNullLiteralArgumentOfNotNullParameterUsages(PsiMethod method, ProblemsHolder holder, NullableNotNullManager nullableManager, boolean isOnFly, int parameterIdx, PsiParameter parameter) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && isOnFly && NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false)) {
            PsiAnnotation notNullAnnotation = nullableManager.getNotNullAnnotation(parameter, false);
            if (JavaNullMethodArgumentUtil.hasNullArgument(method, parameterIdx)) {
                boolean physical = PsiTreeUtil.isAncestor(parameter, notNullAnnotation, true);
                holder.registerProblem(physical ? notNullAnnotation : parameter.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.NotNull.parameter.receives.null.literal", NullableStuffInspectionBase.getPresentableAnnoName(parameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.createNavigateToNullParameterUsagesFix(parameter));
            }
        }
    }

    private void checkOverriders(PsiMethod method, ProblemsHolder holder, Annotated annotated, NullableNotNullManager nullableManager) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS) {
            boolean[] parameterAnnotated = new boolean[parameters.length];
            boolean[] parameterQuickFixSuggested = new boolean[parameters.length];
            boolean hasAnnotatedParameter = false;
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                PsiParameter parameter = parameters[i2];
                parameterAnnotated[i2] = NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false) && !NullableStuffInspectionBase.hasInheritableNotNull(parameter);
                hasAnnotatedParameter |= parameterAnnotated[i2];
            }
            if (hasAnnotatedParameter || annotated.isDeclaredNotNull && !NullableStuffInspectionBase.hasInheritableNotNull(method)) {
                PsiManager manager = method.getManager();
                String defaultNotNull = nullableManager.getDefaultNotNull();
                boolean superMethodApplicable = AnnotationUtil.isAnnotatingApplicable(method, defaultNotNull);
                PsiMethod[] overridings = OverridingMethodsSearch.search(method).toArray((PsiMethod[])PsiMethod.EMPTY_ARRAY);
                boolean methodQuickFixSuggested = false;
                for (PsiMethod overriding : overridings) {
                    if (!manager.isInProject(overriding)) continue;
                    boolean applicable = AnnotationUtil.isAnnotatingApplicable(overriding, defaultNotNull);
                    if (!(methodQuickFixSuggested || !annotated.isDeclaredNotNull || NullableStuffInspectionBase.isNotNullNotInferred(overriding, false, false) || !NullableStuffInspectionBase.isNullableNotInferred(overriding, false) && NullableStuffInspectionBase.isNullableNotInferred(overriding, true))) {
                        method.getNameIdentifier();
                        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, nullableManager.getNotNulls());
                        String[] annotationsToRemove = ArrayUtil.toStringArray(nullableManager.getNullables());
                        LocalQuickFix fix = applicable ? new MyAnnotateMethodFix(defaultNotNull, annotationsToRemove) : (superMethodApplicable ? null : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, method));
                        PsiElement psiElement = annotation;
                        if (!annotation.isPhysical() && (psiElement = method.getNameIdentifier()) == null) continue;
                        holder.registerProblem(psiElement, InspectionsBundle.message("nullable.stuff.problems.overridden.methods.are.not.annotated", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
                        methodQuickFixSuggested = true;
                    }
                    if (!hasAnnotatedParameter) continue;
                    PsiParameter[] psiParameters = overriding.getParameterList().getParameters();
                    for (int i3 = 0; i3 < psiParameters.length; ++i3) {
                        PsiAnnotation annotation;
                        if (parameterQuickFixSuggested[i3]) continue;
                        PsiParameter parameter = psiParameters[i3];
                        if (!parameterAnnotated[i3] || NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false) || NullableStuffInspectionBase.isNullableNotInferred(parameter, false)) continue;
                        parameters[i3].getNameIdentifier();
                        PsiElement psiElement = annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameters[i3], nullableManager.getNotNulls());
                        if ((annotation == null || !annotation.isPhysical()) && (psiElement = parameters[i3].getNameIdentifier()) == null) continue;
                        holder.registerProblem(psiElement, InspectionsBundle.message("nullable.stuff.problems.overridden.method.parameters.are.not.annotated", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, !applicable ? NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, parameters[i3]) : new AnnotateOverriddenMethodParameterFix(defaultNotNull, nullableManager.getDefaultNullable()));
                        parameterQuickFixSuggested[i3] = true;
                    }
                }
            }
        }
    }

    private static boolean isNotNullNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean skipExternal) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "isNotNullNotInferred"));
        }
        Project project = owner.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance(project);
        if (!manager.isNotNull(owner, checkBases)) {
            return false;
        }
        PsiAnnotation anno = manager.getNotNullAnnotation(owner, checkBases);
        if (anno == null || AnnotationUtil.isInferredAnnotation(anno)) {
            return false;
        }
        return !skipExternal || !AnnotationUtil.isExternalAnnotation(anno);
    }

    public static boolean isNullableNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "isNullableNotInferred"));
        }
        Project project = owner.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance(project);
        if (!manager.isNullable(owner, checkBases)) {
            return false;
        }
        PsiAnnotation anno = manager.getNullableAnnotation(owner, checkBases);
        return anno == null || !AnnotationUtil.isInferredAnnotation(anno);
    }

    private static LocalQuickFix createChangeDefaultNotNullFix(NullableNotNullManager nullableManager, PsiModifierListOwner modifierListOwner) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation(modifierListOwner, nullableManager.getNotNulls());
        if (annotation != null && (referenceElement = annotation.getNameReferenceElement()) != null && referenceElement.resolve() != null) {
            return new ChangeNullableDefaultsFix(annotation.getQualifiedName(), null, nullableManager);
        }
        return null;
    }

    protected AnnotateMethodFix createAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
        return new AnnotateMethodFix(defaultNotNull, annotationsToRemove);
    }

    private static void reportNullableNotNullConflict(ProblemsHolder holder, PsiModifierListOwner listOwner, PsiAnnotation declaredNullable, PsiAnnotation declaredNotNull) {
        String bothNullableNotNullMessage = InspectionsBundle.message("inspection.nullable.problems.Nullable.NotNull.conflict", NullableStuffInspectionBase.getPresentableAnnoName(declaredNullable), NullableStuffInspectionBase.getPresentableAnnoName(declaredNotNull));
        holder.registerProblem(declaredNotNull.isPhysical() ? declaredNotNull : listOwner.getNavigationElement(), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RemoveAnnotationQuickFix(declaredNotNull, listOwner));
        holder.registerProblem(declaredNullable.isPhysical() ? declaredNullable : listOwner.getNavigationElement(), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RemoveAnnotationQuickFix(declaredNullable, listOwner));
    }

    @Override
    public JComponent createOptionsPanel() {
        throw new RuntimeException("No UI in headless mode");
    }

    private static class MyAnnotateMethodFix
    extends AnnotateMethodFix {
        public MyAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
            super(defaultNotNull, annotationsToRemove);
        }

        @Override
        protected boolean annotateOverriddenMethods() {
            return true;
        }

        @Override
        public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
            return 1;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("annotate.overridden.methods.as.notnull", ClassUtil.extractClassName(this.myAnnotation));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$MyAnnotateMethodFix", "getName"));
            }
            return string;
        }
    }

    private static class Annotated {
        private final boolean isDeclaredNotNull;
        private final boolean isDeclaredNullable;

        private Annotated(boolean isDeclaredNotNull, boolean isDeclaredNullable) {
            this.isDeclaredNotNull = isDeclaredNotNull;
            this.isDeclaredNullable = isDeclaredNullable;
        }
    }
}

