/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.CustomPropertyScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SimpleAccessorReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SimpleAccessorReferenceSearcher() {
        super(true);
    }

    @Override
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/SimpleAccessorReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/SimpleAccessorReferenceSearcher", "processQuery"));
        }
        PsiElement refElement = queryParameters.getElementToSearch();
        if (!(refElement instanceof PsiMethod)) {
            return;
        }
        SimpleAccessorReferenceSearcher.addPropertyAccessUsages((PsiMethod)refElement, queryParameters.getEffectiveSearchScope(), queryParameters.getOptimizer());
    }

    static void addPropertyAccessUsages(@NotNull PsiMethod method, @NotNull SearchScope scope, @NotNull SearchRequestCollector collector) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/SimpleAccessorReferenceSearcher", "addPropertyAccessUsages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/SimpleAccessorReferenceSearcher", "addPropertyAccessUsages"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/impl/search/SimpleAccessorReferenceSearcher", "addPropertyAccessUsages"));
        }
        String propertyName = PropertyUtil.getPropertyName(method);
        if (StringUtil.isNotEmpty(propertyName)) {
            SearchScope additional = GlobalSearchScope.EMPTY_SCOPE;
            for (CustomPropertyScopeProvider provider : Extensions.getExtensions(CustomPropertyScopeProvider.EP_NAME)) {
                additional = ((SearchScope)additional).union(provider.getScope(method.getProject()));
            }
            SearchScope propScope = scope.intersectWith(method.getUseScope()).intersectWith(additional);
            collector.searchWord(propertyName, propScope, (short)8, true, method);
        }
    }
}

