/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class AllOverridingMethodsSearch
extends ExtensibleQueryFactory<Pair<PsiMethod, PsiMethod>, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create("com.intellij.allOverridingMethodsSearch");
    public static final AllOverridingMethodsSearch INSTANCE = new AllOverridingMethodsSearch();

    private AllOverridingMethodsSearch() {
    }

    @NotNull
    public static Query<Pair<PsiMethod, PsiMethod>> search(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/AllOverridingMethodsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AllOverridingMethodsSearch", "search"));
        }
        if (aClass.hasModifierProperty("final")) {
            Query<Pair<PsiMethod, PsiMethod>> query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AllOverridingMethodsSearch", "search"));
            }
            return query;
        }
        Query<Pair<PsiMethod, PsiMethod>> query = INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope));
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AllOverridingMethodsSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<Pair<PsiMethod, PsiMethod>> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/AllOverridingMethodsSearch", "search"));
        }
        Query<Pair<PsiMethod, PsiMethod>> query = AllOverridingMethodsSearch.search(aClass, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(aClass)));
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AllOverridingMethodsSearch", "search"));
        }
        return query;
    }

    public static class SearchParameters {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final SearchScope myScope;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/AllOverridingMethodsSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AllOverridingMethodsSearch$SearchParameters", "<init>"));
            }
            this.myClass = aClass;
            this.myScope = scope;
        }

        @NotNull
        public PsiClass getPsiClass() {
            PsiClass psiClass = this.myClass;
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AllOverridingMethodsSearch$SearchParameters", "getPsiClass"));
            }
            return psiClass;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AllOverridingMethodsSearch$SearchParameters", "getScope"));
            }
            return searchScope;
        }
    }
}

