/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    @NonNls
    private static final Set<String> keywordTable = new HashSet<String>();
    @NonNls
    private static final String AN = "an";

    private StringUtils() {
    }

    @NotNull
    public static String createSingularFromName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/siyeh/ig/psiutils/StringUtils", "createSingularFromName"));
        }
        int nameLength = name.length();
        String singularName = name.endsWith("ies") ? name.substring(0, nameLength - 3) + 'y' : (name.endsWith("sses") || name.endsWith("shes") ? name.substring(0, nameLength - 2) : (name.charAt(nameLength - 1) == 's' ? name.substring(0, nameLength - 1) : (name.endsWith("IES") ? name.substring(0, nameLength - 3) + 'Y' : (name.endsWith("SSES") || name.endsWith("SHES") ? name.substring(0, nameLength - 2) : (name.charAt(nameLength - 1) == 'S' ? name.substring(0, nameLength - 1) : StringUtils.prependIndefiniteArticle(name))))));
        if (keywordTable.contains(singularName)) {
            String string = StringUtils.prependIndefiniteArticle(singularName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StringUtils", "createSingularFromName"));
            }
            return string;
        }
        String string = singularName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StringUtils", "createSingularFromName"));
        }
        return string;
    }

    @NotNull
    private static String prependIndefiniteArticle(String singularName) {
        switch (singularName.charAt(0)) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                String string = AN + StringUtil.capitalize(singularName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StringUtils", "prependIndefiniteArticle"));
                }
                return string;
            }
        }
        String string = 'a' + StringUtil.capitalize(singularName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StringUtils", "prependIndefiniteArticle"));
        }
        return string;
    }

    public static String stripAngleBrackets(String string) {
        int index = string.indexOf(60);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index);
    }

    static {
        keywordTable.add("abstract");
        keywordTable.add("assert");
        keywordTable.add("boolean");
        keywordTable.add("break");
        keywordTable.add("byte");
        keywordTable.add("case");
        keywordTable.add("catch");
        keywordTable.add("char");
        keywordTable.add("class");
        keywordTable.add("const");
        keywordTable.add("continue");
        keywordTable.add("default");
        keywordTable.add("do");
        keywordTable.add("double");
        keywordTable.add("else");
        keywordTable.add("enum");
        keywordTable.add("extends");
        keywordTable.add("false");
        keywordTable.add("final");
        keywordTable.add("finally");
        keywordTable.add("float");
        keywordTable.add("for");
        keywordTable.add("goto");
        keywordTable.add("if");
        keywordTable.add("implements");
        keywordTable.add("import");
        keywordTable.add("instanceof");
        keywordTable.add("int");
        keywordTable.add("interface");
        keywordTable.add("long");
        keywordTable.add("native");
        keywordTable.add("new");
        keywordTable.add("null");
        keywordTable.add("package");
        keywordTable.add("private");
        keywordTable.add("protected");
        keywordTable.add("public");
        keywordTable.add("return");
        keywordTable.add("short");
        keywordTable.add("static");
        keywordTable.add("strictfp");
        keywordTable.add("super");
        keywordTable.add("switch");
        keywordTable.add("synchronized");
        keywordTable.add("this");
        keywordTable.add("throw");
        keywordTable.add("throws");
        keywordTable.add("transient");
        keywordTable.add("true");
        keywordTable.add("try");
        keywordTable.add("void");
        keywordTable.add("volatile");
        keywordTable.add("while");
    }
}

