/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassEscapesItsScopeInspection
extends BaseJavaBatchLocalInspectionTool {
    public boolean checkModuleApi = true;
    public boolean checkPublicApi;
    public boolean checkPackageLocal;

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("ClassEscapesDefinedScope" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "getID"));
        }
        return "ClassEscapesDefinedScope";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.escapes.defined.scope.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("class.escapes.defined.scope.display.module.option", new Object[0]), "checkModuleApi");
        panel.addCheckbox(InspectionGadgetsBundle.message("class.escapes.defined.scope.display.public.option", new Object[0]), "checkPublicApi");
        panel.addCheckbox(InspectionGadgetsBundle.message("class.escapes.defined.scope.display.package.option", new Object[0]), "checkPackageLocal");
        return panel;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        THashSet exportedPackageNames;
        Module module;
        VirtualFile vFile;
        PsiJavaModule psiModule;
        PsiJavaFile javaFile;
        PsiFile file;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "buildVisitor"));
        }
        ArrayList<VisibilityChecker> checkers = new ArrayList<VisibilityChecker>(2);
        if (this.checkModuleApi && (file = holder.getFile()) instanceof PsiJavaFile && (javaFile = (PsiJavaFile)file).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) && (psiModule = JavaModuleGraphUtil.findDescriptorByElement(file)) != null && (vFile = file.getVirtualFile()) != null && (module = ProjectFileIndex.SERVICE.getInstance(holder.getProject()).getModuleForFile(vFile)) != null && (exportedPackageNames = new THashSet(ContainerUtil.mapNotNull(psiModule.getExports(), PsiPackageAccessibilityStatement::getPackageName))).contains(javaFile.getPackageName())) {
            checkers.add(new Java9NonAccessibleTypeExposedVisitor(holder, module, psiModule.getName(), (Set<String>)exportedPackageNames));
        }
        if (this.checkPublicApi || this.checkPackageLocal) {
            checkers.add(new ClassEscapesItsScopeVisitor(holder));
        }
        PsiElementVisitor psiElementVisitor = !checkers.isEmpty() ? new VisibilityVisitor(checkers.toArray(VisibilityChecker.EMPTY_ARRAY)) : PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static class Java9NonAccessibleTypeExposedVisitor
    extends VisibilityChecker {
        private final ModuleFileIndex myModuleFileIndex;
        private final Set<String> myExportedPackageNames;
        private final String myModuleName;

        public Java9NonAccessibleTypeExposedVisitor(@NotNull ProblemsHolder holder, @NotNull Module module, @NotNull String moduleName, @NotNull Set<String> exportedPackageNames) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$Java9NonAccessibleTypeExposedVisitor", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$Java9NonAccessibleTypeExposedVisitor", "<init>"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$Java9NonAccessibleTypeExposedVisitor", "<init>"));
            }
            if (exportedPackageNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportedPackageNames", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$Java9NonAccessibleTypeExposedVisitor", "<init>"));
            }
            super(holder);
            this.myModuleName = moduleName;
            this.myModuleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
            this.myExportedPackageNames = exportedPackageNames;
        }

        @Override
        public boolean checkVisibilityIssue(PsiMember member, PsiClass psiClass, PsiJavaCodeReferenceElement reference) {
            if (this.isModulePublicApi(member) && !this.isModulePublicApi(psiClass) && this.isInModuleSource(psiClass)) {
                this.myHolder.registerProblem((PsiElement)reference, InspectionGadgetsBundle.message("class.escapes.defined.scope.java9.modules.descriptor", this.myModuleName), new LocalQuickFix[0]);
                return true;
            }
            return false;
        }

        @Contract(value="null -> false")
        private boolean isModulePublicApi(@Nullable PsiMember member) {
            if (member != null && !(member instanceof PsiTypeParameter) && (member.hasModifierProperty("public") || member.hasModifierProperty("protected"))) {
                PsiElement parent = member.getParent();
                if (parent instanceof PsiClass) {
                    return this.isModulePublicApi((PsiClass)parent);
                }
                if (parent instanceof PsiJavaFile) {
                    String packageName = ((PsiJavaFile)parent).getPackageName();
                    return this.myExportedPackageNames.contains(packageName);
                }
            }
            return false;
        }

        private boolean isInModuleSource(@NotNull PsiClass psiClass) {
            VirtualFile vFile;
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$Java9NonAccessibleTypeExposedVisitor", "isInModuleSource"));
            }
            PsiFile psiFile = psiClass.getContainingFile();
            if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                return this.myModuleFileIndex.isInSourceContent(vFile);
            }
            return false;
        }
    }

    private class ClassEscapesItsScopeVisitor
    extends VisibilityChecker {
        public ClassEscapesItsScopeVisitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        boolean checkVisibilityIssue(PsiMember member, PsiClass psiClass, PsiJavaCodeReferenceElement reference) {
            if (this.needToCheck(member) && this.isLessRestrictiveScope(member, psiClass)) {
                this.myHolder.registerProblem((PsiElement)reference, InspectionGadgetsBundle.message("class.escapes.defined.scope.problem.descriptor", new Object[0]), new LocalQuickFix[0]);
                return true;
            }
            return false;
        }

        private boolean needToCheck(PsiMember member) {
            return ClassEscapesItsScopeInspection.this.checkPublicApi && (member.hasModifierProperty("public") || member.hasModifierProperty("protected")) || ClassEscapesItsScopeInspection.this.checkPackageLocal && member.hasModifierProperty("packageLocal");
        }

        private boolean isLessRestrictiveScope(@NotNull PsiMember member, @NotNull PsiClass aClass) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$ClassEscapesItsScopeVisitor", "isLessRestrictiveScope"));
            }
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$ClassEscapesItsScopeVisitor", "isLessRestrictiveScope"));
            }
            int methodScopeOrder = this.getScopeOrder(member);
            int classScopeOrder = this.getScopeOrder(aClass);
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null || containingClass.getQualifiedName() == null) {
                return false;
            }
            int containingClassScopeOrder = this.getScopeOrder(containingClass);
            return methodScopeOrder > classScopeOrder && containingClassScopeOrder > classScopeOrder;
        }

        private int getScopeOrder(@NotNull PsiModifierListOwner element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$ClassEscapesItsScopeVisitor", "getScopeOrder"));
            }
            if (element.hasModifierProperty("public")) {
                return 4;
            }
            if (element.hasModifierProperty("private")) {
                return 1;
            }
            if (element.hasModifierProperty("protected")) {
                return 3;
            }
            return 2;
        }
    }

    private static abstract class VisibilityChecker {
        static final VisibilityChecker[] EMPTY_ARRAY = new VisibilityChecker[0];
        final ProblemsHolder myHolder;

        protected VisibilityChecker(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        abstract boolean checkVisibilityIssue(PsiMember var1, PsiClass var2, PsiJavaCodeReferenceElement var3);
    }

    private static class VisibilityVisitor
    extends JavaElementVisitor {
        private final VisibilityChecker[] myCheckers;

        public VisibilityVisitor(VisibilityChecker[] checkers) {
            this.myCheckers = checkers;
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            PsiElement resolved;
            PsiMember member;
            PsiElement grandParent;
            super.visitReferenceElement(reference);
            PsiElement parent = reference.getParent();
            if ((parent instanceof PsiTypeElement || parent instanceof PsiReferenceList) && ((grandParent = PsiTreeUtil.skipParentsOfType(reference, PsiTypeElement.class, PsiReferenceList.class, PsiParameter.class, PsiParameterList.class, PsiReferenceParameterList.class, PsiJavaCodeReferenceElement.class, PsiTypeParameter.class, PsiTypeParameterList.class)) instanceof PsiField || grandParent instanceof PsiMethod) && !VisibilityVisitor.isPrivate(member = (PsiMember)grandParent) && (resolved = reference.resolve()) instanceof PsiClass && !(resolved instanceof PsiTypeParameter)) {
                PsiClass psiClass = (PsiClass)resolved;
                for (VisibilityChecker checker : this.myCheckers) {
                    if (!checker.checkVisibilityIssue(member, psiClass, reference)) continue;
                    return;
                }
            }
        }

        private static boolean isPrivate(@NotNull PsiMember member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$VisibilityVisitor", "isPrivate"));
            }
            if (member.hasModifierProperty("private")) {
                return true;
            }
            PsiClass containingClass = member.getContainingClass();
            return containingClass != null && VisibilityVisitor.isPrivate(containingClass);
        }
    }
}

