/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiImportListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiImportStatementImpl;
import com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PsiImportListImpl
extends JavaStubPsiElement<PsiImportListStub>
implements PsiImportList {
    private volatile Map<String, PsiImportStatement> myClassNameToImportMap;
    private volatile Map<String, PsiImportStatement> myPackageNameToImportMap;
    private volatile Map<String, PsiImportStatementBase> myNameToSingleImportMap;
    private static final PsiImportStatementBase[] EMPTY_ARRAY = PsiImportStatementBase.EMPTY_ARRAY;
    private static final ArrayFactory<PsiImportStatementBase> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiImportStatementBase[count];
    private static final TokenSet IMPORT_STATEMENT_BIT_SET = TokenSet.create(JavaElementType.IMPORT_STATEMENT);
    private static final TokenSet IMPORT_STATIC_STATEMENT_BIT_SET = TokenSet.create(JavaElementType.IMPORT_STATIC_STATEMENT);

    public PsiImportListImpl(PsiImportListStub stub) {
        super(stub, JavaStubElementTypes.IMPORT_LIST);
    }

    public PsiImportListImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiImportListImpl clone = (PsiImportListImpl)super.clone();
        clone.myClassNameToImportMap = null;
        clone.myPackageNameToImportMap = null;
        clone.myNameToSingleImportMap = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        this.myClassNameToImportMap = null;
        this.myPackageNameToImportMap = null;
        this.myNameToSingleImportMap = null;
        super.subtreeChanged();
    }

    @Override
    @NotNull
    public PsiImportStatement[] getImportStatements() {
        PsiImportStatement[] psiImportStatementArray = (PsiImportStatement[])this.getStubOrPsiChildren(IMPORT_STATEMENT_BIT_SET, PsiImportStatementImpl.ARRAY_FACTORY);
        if (psiImportStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImportListImpl", "getImportStatements"));
        }
        return psiImportStatementArray;
    }

    @Override
    @NotNull
    public PsiImportStaticStatement[] getImportStaticStatements() {
        PsiImportStaticStatement[] psiImportStaticStatementArray = (PsiImportStaticStatement[])this.getStubOrPsiChildren(IMPORT_STATIC_STATEMENT_BIT_SET, PsiImportStaticStatementImpl.ARRAY_FACTORY);
        if (psiImportStaticStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImportListImpl", "getImportStaticStatements"));
        }
        return psiImportStaticStatementArray;
    }

    @Override
    @NotNull
    public PsiImportStatementBase[] getAllImportStatements() {
        PsiImportStatementBase[] psiImportStatementBaseArray = (PsiImportStatementBase[])this.getStubOrPsiChildren(ElementType.IMPORT_STATEMENT_BASE_BIT_SET, ARRAY_FACTORY);
        if (psiImportStatementBaseArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImportListImpl", "getAllImportStatements"));
        }
        return psiImportStatementBaseArray;
    }

    @Override
    public PsiImportStatement findSingleClassImportStatement(String name) {
        Map<String, PsiImportStatement> map;
        while ((map = this.myClassNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name);
    }

    @Override
    public PsiImportStatement findOnDemandImportStatement(String name) {
        Map<String, PsiImportStatement> map;
        while ((map = this.myPackageNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name);
    }

    @Override
    public PsiImportStatementBase findSingleImportStatement(String name) {
        Map<String, PsiImportStatementBase> map;
        while ((map = this.myNameToSingleImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name);
    }

    @Override
    public boolean isReplaceEquivalent(PsiImportList otherList) {
        return this.getText().equals(otherList.getText());
    }

    private void initializeMaps() {
        PsiImportStaticStatement[] importStatics;
        PsiImportStatement[] imports;
        HashMap<String, PsiImportStatement> classNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatement> packageNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatementBase> nameToSingleImportMap = new HashMap<String, PsiImportStatementBase>();
        for (PsiImportStatement anImport : imports = this.getImportStatements()) {
            String qName = anImport.getQualifiedName();
            if (qName == null) continue;
            if (anImport.isOnDemand()) {
                packageNameToImportMap.put(qName, anImport);
                continue;
            }
            classNameToImportMap.put(qName, anImport);
            PsiJavaCodeReferenceElement importReference = anImport.getImportReference();
            if (importReference == null) continue;
            nameToSingleImportMap.put(importReference.getReferenceName(), anImport);
        }
        for (PsiImportStaticStatement importStatic : importStatics = this.getImportStaticStatements()) {
            String referenceName;
            if (importStatic.isOnDemand() || (referenceName = importStatic.getReferenceName()) == null) continue;
            nameToSingleImportMap.put(referenceName, importStatic);
        }
        this.myClassNameToImportMap = classNameToImportMap;
        this.myPackageNameToImportMap = packageNameToImportMap;
        this.myNameToSingleImportMap = nameToSingleImportMap;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiImportListImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiImportList";
    }
}

