/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeleteRepeatedInterfaceFix
implements IntentionAction {
    private final PsiTypeElement myConjunct;
    private final List<PsiTypeElement> myConjList;

    public DeleteRepeatedInterfaceFix(PsiTypeElement conjunct, List<PsiTypeElement> conjList) {
        this.myConjunct = conjunct;
        this.myConjList = conjList;
    }

    @Override
    @NotNull
    public String getText() {
        String string = "Delete repeated '" + this.myConjunct.getText() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteRepeatedInterfaceFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Delete repeated interface" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteRepeatedInterfaceFix", "getFamilyName"));
        }
        return "Delete repeated interface";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteRepeatedInterfaceFix", "isAvailable"));
        }
        for (PsiTypeElement element : this.myConjList) {
            if (element.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiType type;
        PsiTypeElement castType;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteRepeatedInterfaceFix", "invoke"));
        }
        PsiTypeCastExpression castExpression = PsiTreeUtil.getParentOfType((PsiElement)this.myConjunct, PsiTypeCastExpression.class);
        if (castExpression != null && (castType = castExpression.getCastType()) != null && (type = castType.getType()) instanceof PsiIntersectionType) {
            String typeText = StringUtil.join(ContainerUtil.filter(this.myConjList, element -> element != this.myConjunct), element -> element.getText(), " & ");
            PsiTypeCastExpression newCastExpr = (PsiTypeCastExpression)JavaPsiFacade.getElementFactory(project).createExpressionFromText("(" + typeText + ")a", castType);
            CodeStyleManager.getInstance(project).reformat(castType.replace(newCastExpr.getCastType()));
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

